/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.infordata.em.crt5250.XI5250Crt;
import net.infordata.em.crt5250.XI5250CrtCtrl;
import net.infordata.em.crt5250.XI5250CrtFrame;
import net.infordata.em.tn5250.XI5250Emulator;
import net.infordata.em.tn5250.XI5250EmulatorAdapter;
import net.infordata.em.tn5250.XI5250EmulatorEvent;
import net.infordata.em.tn5250.XIImagesBdl;

public class XI5250EmulatorCtrl
extends XI5250CrtCtrl {
    private static XIImagesBdl cvImagesBdl = XIImagesBdl.getImagesBdl();
    private static ResourceBundle cvRes = ResourceBundle.getBundle("net.infordata.em.tn5250.resources.Res");
    public static final String CONNECT_CMD = "CONNECT_CMD";
    public static final String DISCONNECT_CMD = "DISCONNECT_CMD";
    public static final String ABOUT_CMD = "ABOUT_CMD";
    public static final String SNAPSHOT_CMD = "SNAPSHOT_CMD";
    private int ivSnapShotCount = 0;

    public XI5250EmulatorCtrl(XI5250Emulator aCrt) {
        super(aCrt);
        this.getEmulator().addEmulatorListener(new EmulatorListener());
        this.getCommandMgr().enableCommand(CONNECT_CMD, !this.getEmulator().isActive());
        this.getCommandMgr().setCommand(CONNECT_CMD, this::processConnectCmd);
        this.getCommandMgr().enableCommand(DISCONNECT_CMD, this.getEmulator().isActive());
        this.getCommandMgr().setCommand(DISCONNECT_CMD, this::processDisconnectCmd);
        this.getCommandMgr().setCommand(ABOUT_CMD, this::processAboutCmd);
        this.getCommandMgr().setCommand(SNAPSHOT_CMD, this::processSnapShotCmd);
    }

    public final XI5250Emulator getEmulator() {
        return (XI5250Emulator)this.getCrt();
    }

    protected void processConnectCmd() {
        if (!this.getEmulator().isActive()) {
            Object ret = JOptionPane.showInputDialog(this.getEmulator(), cvRes.getString("TXT_HostNameInput"), "", 3, null, null, this.getEmulator().getHost());
            if (ret == null) {
                return;
            }
            this.getEmulator().setHost((String)ret);
        }
        this.getEmulator().setActive(true);
    }

    protected void processDisconnectCmd() {
        int ret;
        if (this.getEmulator().isActive() && (ret = JOptionPane.showConfirmDialog(this.getEmulator(), cvRes.getString("TXT_ConfirmDisconnect"), "", 0)) == 1) {
            return;
        }
        this.getEmulator().setActive(false);
    }

    protected void processAboutCmd() {
        JOptionPane.showMessageDialog(this.getEmulator(), "Version 1.19m\n\nInfordata S.p.A.\nhttp://xtn5250.sourceforge.net", "About", 1, cvImagesBdl.getIcon("Logo"));
    }

    protected void processSnapShotCmd() {
        XI5250Crt clone = this.getEmulator().getStaticClone();
        String title = "Snap-shot " + this.getEmulator().getHost() + " #" + ++this.ivSnapShotCount;
        XI5250CrtFrame frm = new XI5250CrtFrame(title, clone);
        frm.setBounds(0, 0, 728, 512);
        frm.centerOnScreen();
        frm.setVisible(true);
    }

    class EmulatorListener
    extends XI5250EmulatorAdapter {
        EmulatorListener() {
        }

        protected void enableCmd() {
            XI5250EmulatorCtrl.this.getCommandMgr().enableCommand(XI5250EmulatorCtrl.CONNECT_CMD, !XI5250EmulatorCtrl.this.getEmulator().isActive());
            XI5250EmulatorCtrl.this.getCommandMgr().enableCommand(XI5250EmulatorCtrl.DISCONNECT_CMD, XI5250EmulatorCtrl.this.getEmulator().isActive());
        }

        @Override
        public void connecting(XI5250EmulatorEvent e) {
            this.enableCmd();
        }

        @Override
        public void connected(XI5250EmulatorEvent e) {
            this.enableCmd();
        }

        @Override
        public void disconnected(XI5250EmulatorEvent e) {
            this.enableCmd();
        }

        @Override
        public void stateChanged(XI5250EmulatorEvent e) {
        }
    }
}

