/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.crt5250;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.infordata.em.crt5250.XI5250BaseField;
import net.infordata.em.crt5250.XI5250Crt;
import net.infordata.em.crt5250.XI5250Field;
import net.infordata.em.crt5250.XI5250FieldSaver;

public class XI5250FieldsList
implements XI5250BaseField,
Cloneable {
    private XI5250Crt ivCrt;
    private ArrayList<XI5250Field> ivFields = new ArrayList(40);
    private List<XI5250Field> ivROFields = Collections.unmodifiableList(this.ivFields);

    public XI5250FieldsList(XI5250Crt aCrt) {
        this.ivCrt = aCrt;
    }

    public Object clone() {
        try {
            XI5250FieldsList aClone = (XI5250FieldsList)super.clone();
            aClone.ivFields = (ArrayList)this.ivFields.clone();
            aClone.ivROFields = Collections.unmodifiableList(aClone.ivFields);
            return aClone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public void init() {
        for (XI5250Field ivField : this.ivFields) {
            ivField.init();
        }
    }

    public void removeNotify() {
        for (XI5250Field ivField : this.ivFields) {
            ivField.removeNotify();
        }
    }

    @Override
    public void saveTo(XI5250FieldSaver aSaver) throws IOException {
        for (XI5250Field ivField : this.ivFields) {
            ivField.saveTo(aSaver);
        }
    }

    public void resized() {
        for (XI5250Field ivField : this.ivFields) {
            ivField.resized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        for (XI5250Field ivField : this.ivFields) {
            XI5250Field field = ivField;
            Rectangle fr = field.getBoundingRect();
            if (!clip.intersects(fr)) continue;
            Graphics fg = g.create(fr.x, fr.y, fr.width, fr.height);
            try {
                field.paint(fg);
            }
            finally {
                fg.dispose();
            }
        }
    }

    private int searchField(int aCol, int aRow) {
        int kk = this.ivCrt.toLinearPos(aCol, aRow);
        int min = 0;
        int max = this.ivFields.size();
        int med = (max + min) / 2;
        while (med < this.ivFields.size() && min <= max) {
            XI5250Field field = this.ivFields.get(med);
            if (field.getSortKey() == kk) {
                return med;
            }
            if (field.getSortKey() > kk) {
                max = med - 1;
            } else {
                min = med + 1;
            }
            med = (max + min) / 2;
        }
        return -(min + 1);
    }

    public void addField(XI5250Field aField) {
        XI5250Field field = this.fieldFromPos(aField.getCol(), aField.getRow());
        if (field != null) {
            this.ivFields.set(this.fromFieldToIdx(field), aField);
        } else {
            int idx = this.searchField(aField.getCol(), aField.getRow());
            idx = -idx - 1;
            this.ivFields.add(idx, aField);
        }
    }

    private XI5250Field prevFieldFromPosInternal(int aCol, int aRow) {
        int idx = this.searchField(aCol, aRow);
        if (idx >= 0) {
            return this.ivFields.get(idx);
        }
        if ((idx = -idx - 1) == 0) {
            return null;
        }
        return this.ivFields.get(idx - 1);
    }

    protected int fromFieldToIdx(XI5250Field aField) {
        int i = 0;
        for (XI5250Field field : this.ivFields) {
            if (field == aField) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public XI5250Field fieldFromPos(int aCol, int aRow) {
        int fk;
        XI5250Field field = this.prevFieldFromPosInternal(aCol, aRow);
        if (field == null) {
            return null;
        }
        int kk = this.ivCrt.toLinearPos(aCol, aRow);
        if (kk >= (fk = field.getSortKey()) && kk < fk + field.getLength()) {
            return field;
        }
        return null;
    }

    public XI5250Field nextFieldFromPos(int aCol, int aRow) {
        if (this.ivFields.isEmpty()) {
            return null;
        }
        XI5250Field field = this.prevFieldFromPosInternal(aCol, aRow);
        if (field == null || field == this.ivFields.get(this.ivFields.size() - 1)) {
            return !this.ivFields.isEmpty() ? this.ivFields.get(0) : null;
        }
        int idx = this.fromFieldToIdx(field);
        return this.ivFields.get(idx + 1);
    }

    public XI5250Field prevFieldFromPos(int aCol, int aRow) {
        if (this.ivFields.isEmpty()) {
            return null;
        }
        XI5250Field field = this.fieldFromPos(aCol, aRow);
        if (field != null) {
            if (field == this.ivFields.get(0)) {
                return this.ivFields.get(this.ivFields.size() - 1);
            }
            int idx = this.fromFieldToIdx(field);
            idx = idx == 0 ? this.ivFields.size() - 1 : idx - 1;
            return this.ivFields.get(idx);
        }
        field = this.prevFieldFromPosInternal(aCol, aRow);
        if (field == null) {
            return !this.ivFields.isEmpty() ? this.ivFields.get(this.ivFields.size() - 1) : null;
        }
        return field;
    }

    public List<XI5250Field> getFields() {
        return this.ivROFields;
    }

    public XI5250Field getField(int idx) {
        try {
            return this.ivFields.get(idx);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }
}

