/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.crt5250;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.EventListener;
import net.infordata.em.crt5250.XI5250BaseField;
import net.infordata.em.crt5250.XI5250Crt;
import net.infordata.em.crt5250.XI5250FieldEvent;
import net.infordata.em.crt5250.XI5250FieldListener;
import net.infordata.em.crt5250.XI5250FieldPaintEvent;
import net.infordata.em.crt5250.XI5250FieldPaintListener;
import net.infordata.em.crt5250.XI5250FieldSaver;
import net.infordata.em.crt5250.XIEbcdicTranslator;
import net.infordata.em.tnprot.XITelnet;

public class XI5250Field
implements XI5250BaseField {
    public static final int DEFAULT_BORDER = 0;
    public static final int NO_BORDER = 1;
    public static final int RAISED_BORDER = 2;
    public static final int LOWERED_BORDER = 3;
    private XI5250Crt ivCrt;
    private byte[] ivFFW;
    private byte[] ivFCW;
    private int ivCol;
    private int ivRow;
    private int ivInputLen;
    private int ivLength;
    private int ivAttr;
    private String ivStr;
    private int ivFldPos;
    private int ivCurPos;
    private int ivPos;
    private XI5250FieldListener ivFieldListener;
    private XI5250FieldPaintListener ivFieldPaintListener;
    private boolean ivEnabled = true;
    private int ivBorderStyle = 0;

    public XI5250Field(XI5250Crt aCrt, int aCol, int aRow, int aLen, int aAttr) {
        this(aCrt, new byte[2], new byte[2], aCol, aRow, aLen, aAttr);
    }

    public XI5250Field(XI5250Crt aCrt, byte[] aFFW, byte[] aFCW, int aCol, int aRow, int aLen, int aAttr) {
        this.ivCrt = aCrt;
        this.ivFFW = aFFW;
        this.ivFCW = aFCW;
        this.ivCol = aCol;
        this.ivRow = aRow;
        this.ivInputLen = aLen;
        this.ivLength = aLen;
        this.ivAttr = aAttr;
        if (this.isSignedNumeric()) {
            --this.ivInputLen;
        }
    }

    protected void removeNotify() {
    }

    public synchronized void addFieldListener(XI5250FieldListener l) {
        this.ivFieldListener = (XI5250FieldListener)Multicaster.add(this.ivFieldListener, l);
    }

    public synchronized void removeFieldListener(XI5250FieldListener l) {
        this.ivFieldListener = (XI5250FieldListener)Multicaster.remove(this.ivFieldListener, l);
    }

    protected void processFieldEvent(XI5250FieldEvent e) {
        if (this.ivFieldListener == null) {
            return;
        }
        switch (e.getID()) {
            case 0: {
                this.ivFieldListener.activated(e);
                break;
            }
            case 1: {
                this.ivFieldListener.deactivated(e);
                break;
            }
            case 2: {
                this.ivFieldListener.valueChanged(e);
                break;
            }
            case 3: {
                this.ivFieldListener.enabledStateChanged(e);
                break;
            }
            case 4: {
                this.ivFieldListener.keyEvent(e);
            }
        }
    }

    public synchronized void addFieldPaintListener(XI5250FieldPaintListener l) {
        this.ivFieldPaintListener = (XI5250FieldPaintListener)Multicaster.add(this.ivFieldPaintListener, l);
    }

    public synchronized void removeFieldPaintListener(XI5250FieldPaintListener l) {
        this.ivFieldPaintListener = (XI5250FieldPaintListener)Multicaster.remove(this.ivFieldPaintListener, l);
    }

    protected void processFieldPaintEvent(XI5250FieldPaintEvent e) {
        if (this.ivFieldPaintListener == null) {
            return;
        }
        switch (e.getID()) {
            case 0: {
                this.ivFieldPaintListener.fieldPaint(e);
                break;
            }
            case 1: {
                this.ivFieldPaintListener.rowPaint(e);
            }
        }
    }

    public int getAttr() {
        return this.ivAttr;
    }

    public final XI5250Crt getCrt() {
        return this.ivCrt;
    }

    public byte[] getFFW() {
        return this.ivFFW;
    }

    public byte[] getFCW() {
        return this.ivFCW;
    }

    @Override
    public void init() {
        this.updateStr();
        int newAttr = this.ivCrt.getAttr(this.ivCrt.toColPos(this.ivFldPos - 1), this.ivCrt.toRowPos(this.ivFldPos - 1));
        if (newAttr != this.ivAttr) {
            this.ivAttr = newAttr;
            String str = this.getString();
            int from = 0;
            while (true) {
                int idx;
                if ((idx = str.indexOf(1, from)) < 0) {
                    this.ivCrt.drawString(str.substring(from), this.ivCrt.toColPos(this.ivFldPos + from), this.ivCrt.toRowPos(this.ivFldPos + from), newAttr);
                    break;
                }
                this.ivCrt.drawString(str.substring(from, idx), this.ivCrt.toColPos(this.ivFldPos + from), this.ivCrt.toRowPos(this.ivFldPos + from), newAttr);
                newAttr = this.ivCrt.getAttr(this.ivCrt.toColPos(this.ivFldPos + idx), this.ivCrt.toRowPos(this.ivFldPos + idx));
                this.ivCrt.drawString(String.valueOf('\u0001'), this.ivCrt.toColPos(this.ivFldPos + idx), this.ivCrt.toRowPos(this.ivFldPos + idx), newAttr);
                from = idx + 1;
            }
        }
    }

    @Override
    public void saveTo(XI5250FieldSaver aSaver) throws IOException {
        aSaver.write(this, this.getString());
    }

    public void clear() {
        char[] chs = new char[this.ivLength];
        for (int i = 0; i < chs.length; ++i) {
            chs[i] = '\u0000';
        }
        this.ivCrt.drawString(new String(chs), this.ivCol, this.ivRow, 0);
    }

    public void setString(String aStr) {
        if (aStr.equals(this.getTrimmedString())) {
            return;
        }
        int s = this.ivCrt.toLinearPos(this.ivCol, this.ivRow);
        for (int i = 0; i < aStr.length() && i < this.ivInputLen; ++i) {
            char ch = aStr.charAt(i);
            int col = this.ivCrt.toColPos(s + i);
            int row = this.ivCrt.toRowPos(s + i);
            this.insertChar(ch, col, row, false, false);
        }
    }

    public String getString() {
        return this.ivCrt.getString(this.ivCol, this.ivRow, this.ivLength);
    }

    public String getTrimmedString() {
        int i;
        String str = this.getString();
        for (i = str.length() - 1; i >= 0 && (str.charAt(i) == '\u0000' || str.charAt(i) == ' '); --i) {
        }
        return i < 0 ? "" : str.substring(0, i + 1);
    }

    public byte getFFW(int i) {
        return this.ivFFW[i];
    }

    public byte getFCW(int i) {
        return this.ivFCW[i];
    }

    public int getCol() {
        return this.ivCol;
    }

    public int getRow() {
        return this.ivRow;
    }

    public int getLength() {
        return this.ivLength;
    }

    protected void setMDTOn() {
        this.ivFFW[0] = (byte)(this.ivFFW[0] | 8);
        this.processFieldEvent(new XI5250FieldEvent(2, this));
    }

    public void resetMDT() {
        this.ivFFW[0] = (byte)(this.ivFFW[0] & 0xFFFFFFF7);
    }

    public boolean isOrgBypassField() {
        return (this.ivFFW[0] & 0x20) != 0;
    }

    public boolean isBypassField() {
        return this.isOrgBypassField() || !this.isEnabled();
    }

    public boolean isDupEnabled() {
        return (this.ivFFW[0] & 0x10) != 0;
    }

    public boolean isMDTOn() {
        return (this.ivFFW[0] & 8) != 0;
    }

    public boolean isAlphabeticShift() {
        return (this.ivFFW[0] & 7) == 0;
    }

    public boolean isAlphabeticOnly() {
        return (this.ivFFW[0] & 7) == 1;
    }

    public boolean isNumericShift() {
        return (this.ivFFW[0] & 7) == 2;
    }

    public boolean isNumericOnly() {
        return (this.ivFFW[0] & 7) == 3;
    }

    public boolean isDigitsOnly() {
        return (this.ivFFW[0] & 7) == 5;
    }

    public boolean isIOOnly() {
        return (this.ivFFW[0] & 7) == 6;
    }

    public boolean isSignedNumeric() {
        return (this.ivFFW[0] & 7) == 7;
    }

    public boolean isAutoEnter() {
        return (this.ivFFW[1] & 0x80) != 0;
    }

    public boolean isExitRequired() {
        return (this.ivFFW[1] & 0x40) != 0;
    }

    public boolean isMonocase() {
        return (this.ivFFW[1] & 0x20) != 0;
    }

    public boolean isMandatoryEnter() {
        return (this.ivFFW[1] & 8) != 0;
    }

    public boolean isRightAdjustZeroFill() {
        return (this.ivFFW[1] & 7) == 5;
    }

    public boolean isRightAdjustBlankFill() {
        return (this.ivFFW[1] & 7) == 6;
    }

    public boolean isMandatoryFill() {
        return (this.ivFFW[1] & 7) == 7;
    }

    protected int getSortKey() {
        return this.ivCrt.toLinearPos(this.ivCol, this.ivRow);
    }

    private void updateStr() {
        this.ivStr = this.ivCrt.getString(this.ivCol, this.ivRow, this.ivInputLen);
        this.ivFldPos = this.ivCrt.toLinearPos(this.ivCol, this.ivRow);
        this.ivCurPos = this.ivCrt.toLinearPos(this.ivCrt.getCursorCol(), this.ivCrt.getCursorRow());
        this.ivPos = this.ivCurPos - this.ivFldPos;
    }

    protected void processKeyEvent(KeyEvent e) {
        this.processFieldEvent(new XI5250FieldEvent(4, this, e));
        if (e.isConsumed()) {
            return;
        }
        switch (e.getID()) {
            case 400: {
                if (!XI5250Crt.isCharKey(e) || !this.processKeyChar(e.getKeyChar())) break;
                e.consume();
                break;
            }
            case 401: {
                if (!this.processOtherKey(e)) break;
                e.consume();
                break;
            }
            case 402: {
                this.ivCrt.ivDropKeyChar = false;
            }
        }
    }

    protected int insertChar(char aCh, int col, int row, boolean insert, boolean fromKeyboard) {
        if (this.isIOOnly() && fromKeyboard) {
            return 4;
        }
        if (this.isDigitsOnly() && (aCh < '0' || aCh > '9')) {
            return 10;
        }
        if (this.isSignedNumeric() && (aCh < '0' || aCh > '9') || this.isNumericOnly() && (aCh < '0' || aCh > '9') && aCh != ' ' && aCh != '+' && aCh != '-' && aCh != '.' && aCh != ',') {
            return 9;
        }
        if (this.isMonocase()) {
            aCh = Character.toUpperCase(aCh);
        }
        this.updateStr();
        this.ivCurPos = this.ivCrt.toLinearPos(col, row);
        this.ivPos = this.ivCurPos - this.ivFldPos;
        if (this.ivPos < 0 || this.ivPos >= this.ivLength) {
            throw new IllegalStateException("");
        }
        StringBuilder strBuf = new StringBuilder(this.ivStr);
        if (!insert) {
            strBuf.setCharAt(this.ivPos, aCh);
            this.ivCrt.drawString(new String(strBuf).substring(this.ivPos, this.ivPos + 1), col, row, this.ivAttr);
        } else {
            if (strBuf.charAt(this.ivInputLen - 1) != '\u0000' && strBuf.charAt(this.ivInputLen - 1) != ' ') {
                return 12;
            }
            strBuf.insert(this.ivPos, aCh);
            this.ivCrt.drawString(new String(strBuf).substring(this.ivPos, this.ivInputLen), col, row, this.ivAttr);
        }
        this.setMDTOn();
        return 0;
    }

    protected boolean processKeyChar(char aCh) {
        if (this.ivCrt.ivDropKeyChar) {
            this.ivCrt.ivDropKeyChar = false;
            return true;
        }
        int error = this.insertChar(aCh, this.ivCrt.getCursorCol(), this.ivCrt.getCursorRow(), this.ivCrt.isInsertState(), true);
        if (error > 0) {
            this.ivCrt.userError(error);
            return true;
        }
        if (this.ivPos < this.ivInputLen - 1) {
            this.ivCrt.moveCursor(1, 0);
        } else if (this.isAutoEnter()) {
            this.ivCrt.doProcessKeyEvent(new KeyEvent(this.ivCrt, 401, 0L, -1, 10, '\n'));
        } else if (!this.isExitRequired()) {
            this.ivCrt.doProcessKeyEvent(new KeyEvent(this.ivCrt, 401, 0L, 0, 9, '\t'));
        }
        return true;
    }

    protected boolean processOtherKey(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 8: {
                return this.processBackSpace(e.getModifiers());
            }
            case 127: {
                return this.processDelete(e.getModifiers());
            }
            case 107: {
                this.ivCrt.ivDropKeyChar = true;
                this.doFieldExit(false);
                return true;
            }
            case 109: {
                this.ivCrt.ivDropKeyChar = true;
                if (this.isNumericOnly() || this.isSignedNumeric()) {
                    this.doFieldExit(true);
                    return true;
                }
                this.ivCrt.userError(16);
                return true;
            }
            case 10: {
                return this.processEnter(e.getModifiers());
            }
            case 35: {
                return this.processEnd(e.getModifiers());
            }
        }
        return false;
    }

    protected boolean processBackSpace(int aModifier) {
        switch (aModifier) {
            case 0: {
                this.updateStr();
                if (this.ivPos == 0) {
                    this.ivCrt.doProcessKeyEvent(new KeyEvent(this.ivCrt, 401, 0L, 1, 9, '\t'));
                } else {
                    this.ivCrt.moveCursor(-1, 0);
                }
                return true;
            }
            case 1: {
                this.updateStr();
                if (this.ivPos != 0) {
                    this.ivCrt.moveCursor(-1, 0);
                    this.updateStr();
                    StringBuilder strBuf = new StringBuilder(this.ivStr);
                    for (int i = this.ivPos + 1; i < this.ivStr.length(); ++i) {
                        strBuf.setCharAt(i - 1, strBuf.charAt(i));
                    }
                    strBuf.setCharAt(this.ivStr.length() - 1, '\u0000');
                    this.ivCrt.drawString(new String(strBuf).substring(this.ivPos), this.ivCrt.getCursorCol(), this.ivCrt.getCursorRow(), this.ivAttr);
                    this.setMDTOn();
                }
                return true;
            }
        }
        return false;
    }

    protected boolean processDelete(int aModifier) {
        switch (aModifier) {
            case 0: {
                this.updateStr();
                StringBuilder strBuf = new StringBuilder(this.ivStr);
                for (int i = this.ivPos + 1; i < this.ivStr.length(); ++i) {
                    strBuf.setCharAt(i - 1, strBuf.charAt(i));
                }
                strBuf.setCharAt(this.ivStr.length() - 1, '\u0000');
                this.ivCrt.drawString(new String(strBuf).substring(this.ivPos), this.ivCrt.getCursorCol(), this.ivCrt.getCursorRow(), this.ivAttr);
                this.setMDTOn();
                return true;
            }
        }
        return false;
    }

    protected boolean processEnter(int aModifier) {
        switch (aModifier) {
            case 1: {
                this.doFieldExit(false);
                return true;
            }
        }
        return false;
    }

    private void doFieldExit(boolean isMinus) {
        int i;
        XIEbcdicTranslator translator = this.getCrt().getTranslator();
        this.updateStr();
        StringBuilder strBuf = new StringBuilder(this.ivStr);
        for (i = this.ivPos; i < this.ivStr.length(); ++i) {
            strBuf.setCharAt(i, '\u0000');
        }
        while (this.ivPos > 0 && strBuf.charAt(this.ivPos - 1) == '\u0000') {
            --this.ivPos;
        }
        if (this.isNumericOnly() && isMinus && this.ivPos > 0) {
            char ch = strBuf.charAt(this.ivPos - 1);
            if (ch != '+' && ch != '-' && ch != '.' && ch != ',' && ch != ' ') {
                byte xx = translator.toEBCDIC(strBuf.charAt(this.ivPos - 1));
                xx = (byte)(xx & 0xF);
                xx = (byte)(xx | 0xD0);
                strBuf.setCharAt(this.ivPos - 1, translator.toChar(xx));
            } else {
                this.ivCrt.userError(26);
                return;
            }
        }
        if (this.isRightAdjustZeroFill() || this.isRightAdjustBlankFill() || this.isSignedNumeric()) {
            for (i = 0; i < this.ivPos; ++i) {
                strBuf.setCharAt(this.ivStr.length() - i - 1, strBuf.charAt(this.ivPos - i - 1));
            }
            for (i = this.ivStr.length() - this.ivPos - 1; i >= 0; --i) {
                strBuf.setCharAt(i, this.isRightAdjustZeroFill() ? (char)'0' : ' ');
            }
            String str = new String(strBuf);
            if (this.isSignedNumeric()) {
                str = str + (isMinus ? (char)'-' : '\u0000');
            }
            this.ivCrt.drawString(str, this.ivCol, this.ivRow, this.ivAttr);
        } else {
            this.ivCrt.drawString(new String(strBuf).substring(this.ivPos), this.ivCrt.getCursorCol(), this.ivCrt.getCursorRow(), this.ivAttr);
        }
        this.setMDTOn();
        this.ivCrt.doProcessKeyEvent(new KeyEvent(this.ivCrt, 401, 0L, 0, 9, '\t'));
    }

    protected boolean processEnd(int aModifier) {
        switch (aModifier) {
            case 0: {
                int i;
                this.updateStr();
                for (i = this.ivStr.length() - 1; i >= 0 && this.ivStr.charAt(i) <= ' '; --i) {
                }
                int xx = this.ivCrt.toLinearPos(this.ivCol, this.ivRow) + Math.min(i + 1, this.ivInputLen - 1);
                this.ivCrt.setCursorPos(this.ivCrt.toColPos(xx), this.ivCrt.toRowPos(xx));
                return true;
            }
            case 1: {
                this.updateStr();
                StringBuilder strBuf = new StringBuilder(this.ivStr);
                for (int j = this.ivPos; j < this.ivStr.length(); ++j) {
                    strBuf.setCharAt(j, '\u0000');
                }
                this.ivCrt.drawString(new String(strBuf).substring(this.ivPos), this.ivCrt.getCursorCol(), this.ivCrt.getCursorRow(), this.ivAttr);
                this.setMDTOn();
                return true;
            }
        }
        return false;
    }

    public int getNRows() {
        return (this.ivCol + this.ivLength - 1) / this.ivCrt.getCrtSize().width + 1;
    }

    public Rectangle getBoundingRect() {
        Dimension charSize = this.ivCrt.getCharSize();
        int rows = this.getNRows();
        if (rows <= 1) {
            return new Rectangle(this.ivCol * charSize.width, this.ivRow * charSize.height, this.ivLength * charSize.width, rows * charSize.height);
        }
        return new Rectangle(0 * charSize.width, this.ivRow * charSize.height, this.ivCrt.getCrtBufferSize().width, rows * charSize.height);
    }

    public Rectangle[] getRows() {
        int rows = this.getNRows();
        Rectangle[] rcts = new Rectangle[rows];
        int len = this.ivLength;
        int x = this.ivCol;
        int y = this.ivRow;
        int i = 0;
        while (len > 0) {
            int dx = Math.min(this.ivCrt.getCrtSize().width - x, len);
            rcts[i++] = new Rectangle(x, y, dx, 1);
            len -= dx;
            x = 0;
            ++y;
        }
        return rcts;
    }

    public Rectangle[] getRowsRects() {
        Rectangle[] rcts = this.getRows();
        for (int i = 0; i < rcts.length; ++i) {
            rcts[i] = this.ivCrt.toPoints(rcts[i].x, rcts[i].y, rcts[i].width, rcts[i].height);
        }
        return rcts;
    }

    public void repaint() {
        Rectangle rt = this.getBoundingRect();
        this.ivCrt.repaint(rt.x, rt.y, rt.width, rt.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics g) {
        this.processFieldPaintEvent(new XI5250FieldPaintEvent(1, this, g));
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            return;
        }
        Rectangle[] rowsRects = this.getRowsRects();
        for (int j = 0; j < rowsRects.length; ++j) {
            Rectangle fr = new Rectangle(rowsRects[j]);
            fr.translate(-this.getBoundingRect().x, -this.getBoundingRect().y);
            if (!clip.intersects(fr)) continue;
            Graphics fg = g.create();
            fg.clipRect(fr.x, fr.y, fr.width, fr.height);
            try {
                this.rowPaint(fg);
                continue;
            }
            finally {
                fg.dispose();
            }
        }
        if (!this.isOrgBypassField()) {
            this.drawBorder(g);
        }
    }

    protected void drawBorder(Graphics g) {
        Color cl2;
        Color cl1;
        int borderStyle = this.getUsedBorderStyle();
        if (borderStyle <= 1) {
            return;
        }
        Rectangle[] rowsRects = this.getRowsRects();
        for (int i = 0; i < rowsRects.length; ++i) {
            rowsRects[i].translate(-this.getBoundingRect().x, -this.getBoundingRect().y);
        }
        Color bg = this.getCrt().getDefBackground();
        if (this.isCurrentField()) {
            cl1 = borderStyle == 2 ? bg.darker().darker().darker() : bg.darker();
            cl2 = borderStyle == 2 ? bg.darker() : bg.darker().darker().darker();
        } else {
            cl1 = borderStyle == 2 ? bg.darker() : bg;
            cl2 = borderStyle == 2 ? bg : bg.darker();
        }
        switch (rowsRects.length) {
            case 0: {
                break;
            }
            case 1: {
                g.setColor(cl1);
                g.drawLine(rowsRects[0].x, rowsRects[0].y, rowsRects[0].x, rowsRects[0].y + rowsRects[0].height - 1);
                g.drawLine(rowsRects[0].x, rowsRects[0].y, rowsRects[0].x + rowsRects[0].width - 1, rowsRects[0].y);
                g.setColor(cl2);
                g.drawLine(rowsRects[0].x + rowsRects[0].width - 1, rowsRects[0].y, rowsRects[0].x + rowsRects[0].width - 1, rowsRects[0].y + rowsRects[0].height - 1);
                g.drawLine(rowsRects[0].x, rowsRects[0].y + rowsRects[0].height - 1, rowsRects[0].x + rowsRects[0].width - 1, rowsRects[0].y + rowsRects[0].height - 1);
                break;
            }
            case 2: {
                int dx = Math.max(0, rowsRects[1].x + rowsRects[1].width - 1 - rowsRects[0].x);
                g.setColor(cl1);
                g.drawLine(rowsRects[0].x, rowsRects[0].y, rowsRects[0].x, rowsRects[0].y + rowsRects[0].height - 1);
                g.drawLine(rowsRects[0].x, rowsRects[0].y, rowsRects[0].x + rowsRects[0].width - 1, rowsRects[0].y);
                g.drawLine(rowsRects[1].x, rowsRects[1].y, rowsRects[1].x + rowsRects[1].width - 1 - dx, rowsRects[1].y);
                g.setColor(cl2);
                g.drawLine(rowsRects[1].x + rowsRects[1].width - 1, rowsRects[1].y, rowsRects[1].x + rowsRects[1].width - 1, rowsRects[1].y + rowsRects[1].height - 1);
                g.drawLine(rowsRects[1].x, rowsRects[1].y + rowsRects[1].height - 1, rowsRects[1].x + rowsRects[1].width - 1, rowsRects[1].y + rowsRects[1].height - 1);
                g.drawLine(rowsRects[0].x + dx, rowsRects[0].y + rowsRects[0].height - 1, rowsRects[0].x + rowsRects[0].width - 1, rowsRects[0].y + rowsRects[0].height - 1);
                break;
            }
            default: {
                int l = rowsRects.length - 1;
                g.setColor(cl1);
                g.drawLine(rowsRects[0].x, rowsRects[0].y, rowsRects[0].x, rowsRects[0].y + rowsRects[0].height - 1);
                g.drawLine(rowsRects[0].x, rowsRects[0].y, rowsRects[0].x + rowsRects[0].width - 1, rowsRects[0].y);
                g.drawLine(rowsRects[1].x, rowsRects[0].y + rowsRects[0].height - 1, rowsRects[0].x, rowsRects[0].y + rowsRects[0].height - 1);
                g.setColor(cl2);
                g.drawLine(rowsRects[l].x + rowsRects[l].width - 1, rowsRects[l].y, rowsRects[l].x + rowsRects[l].width - 1, rowsRects[l].y + rowsRects[l].height - 1);
                g.drawLine(rowsRects[l].x, rowsRects[l].y + rowsRects[l].height - 1, rowsRects[l].x + rowsRects[l].width - 1, rowsRects[l].y + rowsRects[l].height - 1);
                g.drawLine(rowsRects[l].x + rowsRects[l].width - 1, rowsRects[l - 1].y + rowsRects[l - 1].height - 1, rowsRects[l - 1].x + rowsRects[l - 1].width - 1, rowsRects[l - 1].y + rowsRects[l - 1].height - 1);
            }
        }
    }

    protected void rowPaint(Graphics g) {
        this.processFieldPaintEvent(new XI5250FieldPaintEvent(1, this, g));
        if (!this.ivEnabled) {
            Rectangle rt = this.getBoundingRect();
            g.setColor(Color.white);
            int hh = rt.height;
            for (int x = -hh; x < rt.width; x += 8) {
                g.drawLine(x, hh, x + hh, 0);
            }
        }
    }

    protected void resized() {
    }

    protected void activated(boolean activated) {
        this.repaint();
        this.processFieldEvent(new XI5250FieldEvent(activated ? 0 : 1, this));
    }

    public final boolean isCurrentField() {
        return this.ivCrt.getCurrentField() == this;
    }

    public void setEnabled(boolean flag) {
        if (flag == this.ivEnabled) {
            return;
        }
        this.ivEnabled = flag;
        this.repaint();
        this.processFieldEvent(new XI5250FieldEvent(3, this));
    }

    public boolean isEnabled() {
        return this.ivEnabled;
    }

    public void setBorderStyle(int aStyle) {
        if (aStyle == this.ivBorderStyle) {
            return;
        }
        if (aStyle < 0 || aStyle > 3) {
            throw new IllegalArgumentException("Wrong border style argument");
        }
        this.ivBorderStyle = aStyle;
        this.repaint();
    }

    public int getBorderStyle() {
        return this.ivBorderStyle;
    }

    public int getUsedBorderStyle() {
        int style = this.getBorderStyle();
        return style != 0 ? style : this.ivCrt.getDefFieldsBorderStyle();
    }

    public String toString() {
        return super.toString() + " [FFW=[" + XITelnet.toHex(this.ivFFW[0]) + "," + XITelnet.toHex(this.ivFFW[1]) + "],FCW=[" + XITelnet.toHex(this.ivFCW[0]) + "," + XITelnet.toHex(this.ivFCW[1]) + "],Attr=" + XITelnet.toHex((byte)this.ivAttr) + ",(" + this.ivCol + "," + this.ivRow + ")Len=" + this.ivLength + "]";
    }

    private static class Multicaster
    extends AWTEventMulticaster
    implements XI5250FieldListener,
    XI5250FieldPaintListener {
        protected Multicaster(EventListener a, EventListener b) {
            super(a, b);
        }

        @Override
        protected EventListener remove(EventListener oldl) {
            if (oldl == this.a) {
                return this.b;
            }
            if (oldl == this.b) {
                return this.a;
            }
            EventListener a2 = Multicaster.removeInternal(this.a, oldl);
            EventListener b2 = Multicaster.removeInternal(this.b, oldl);
            if (a2 == this.a && b2 == this.b) {
                return this;
            }
            return Multicaster.add(a2, b2);
        }

        public static EventListener add(EventListener a, EventListener b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return new Multicaster(a, b);
        }

        public static EventListener remove(EventListener a, EventListener b) {
            return Multicaster.removeInternal(a, b);
        }

        @Override
        public void activated(XI5250FieldEvent e) {
            ((XI5250FieldListener)this.a).activated(e);
            ((XI5250FieldListener)this.b).activated(e);
        }

        @Override
        public void deactivated(XI5250FieldEvent e) {
            ((XI5250FieldListener)this.a).deactivated(e);
            ((XI5250FieldListener)this.b).deactivated(e);
        }

        @Override
        public void valueChanged(XI5250FieldEvent e) {
            ((XI5250FieldListener)this.a).valueChanged(e);
            ((XI5250FieldListener)this.b).valueChanged(e);
        }

        @Override
        public void enabledStateChanged(XI5250FieldEvent e) {
            ((XI5250FieldListener)this.a).enabledStateChanged(e);
            ((XI5250FieldListener)this.b).enabledStateChanged(e);
        }

        @Override
        public void keyEvent(XI5250FieldEvent e) {
            ((XI5250FieldListener)this.a).keyEvent(e);
            ((XI5250FieldListener)this.b).keyEvent(e);
        }

        @Override
        public void fieldPaint(XI5250FieldPaintEvent e) {
            ((XI5250FieldPaintListener)this.a).fieldPaint(e);
            ((XI5250FieldPaintListener)this.b).fieldPaint(e);
        }

        @Override
        public void rowPaint(XI5250FieldPaintEvent e) {
            ((XI5250FieldPaintListener)this.a).rowPaint(e);
            ((XI5250FieldPaintListener)this.b).rowPaint(e);
        }
    }
}

