/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.crt5250;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import net.infordata.em.crt.XICrtBuffer;
import net.infordata.em.crt5250.XI5250Crt;
import net.infordata.em.crt5250.XI5250Field;

public class XI5250CrtBuffer
extends XICrtBuffer
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int GRAY_INTENSITY = XI5250CrtBuffer.colorAsIntensity(Color.gray);
    private ColorWrapper ivBackColor = new ColorWrapper(Color.black);
    private static final Color blue = new Color(128, 128, 255);
    private final Color[][] DK_FORE_COLORS_MAP = new Color[][]{{Color.green, this.ivBackColor, Color.white, this.ivBackColor, Color.green, this.ivBackColor, Color.white, this.ivBackColor, Color.red, this.ivBackColor, Color.red.brighter(), this.ivBackColor, Color.red, this.ivBackColor, Color.red.brighter(), this.ivBackColor, Color.cyan, this.ivBackColor, Color.yellow, this.ivBackColor, Color.cyan, this.ivBackColor, Color.yellow, this.ivBackColor, Color.pink, this.ivBackColor, blue, this.ivBackColor, Color.pink, this.ivBackColor, blue, this.ivBackColor}};
    private final Color[][] DK_BACK_COLORS_MAP = new Color[][]{{this.ivBackColor, Color.green, this.ivBackColor, Color.white, this.ivBackColor, Color.green, this.ivBackColor, this.ivBackColor, this.ivBackColor, Color.red, this.ivBackColor, Color.red.brighter(), this.ivBackColor, Color.red, this.ivBackColor, this.ivBackColor, this.ivBackColor, Color.cyan, this.ivBackColor, Color.yellow, this.ivBackColor, Color.cyan, this.ivBackColor, this.ivBackColor, this.ivBackColor, Color.pink, this.ivBackColor, blue, this.ivBackColor, Color.pink, this.ivBackColor, this.ivBackColor}};
    private final Color[][] LT_FORE_COLORS_MAP = new Color[][]{{Color.green.darker().darker(), this.ivBackColor, Color.darkGray, this.ivBackColor, Color.green.darker().darker(), this.ivBackColor, Color.darkGray, this.ivBackColor, Color.red, this.ivBackColor, Color.red.brighter(), this.ivBackColor, Color.red, this.ivBackColor, Color.red.brighter(), this.ivBackColor, Color.blue, this.ivBackColor, Color.yellow.darker(), this.ivBackColor, Color.blue, this.ivBackColor, Color.yellow.darker(), this.ivBackColor, Color.pink.darker(), this.ivBackColor, blue.darker(), this.ivBackColor, Color.pink.darker(), this.ivBackColor, blue.darker(), this.ivBackColor}, {Color.green.darker().darker(), Color.white, Color.darkGray, Color.white, Color.green.darker().darker(), Color.white, Color.darkGray, Color.white, Color.red, Color.white, Color.red.brighter(), Color.white, Color.red, Color.white, Color.red.brighter(), Color.white, Color.blue, Color.white, Color.yellow.darker(), Color.white, Color.blue, Color.white, Color.yellow.darker(), this.ivBackColor, Color.pink.darker(), Color.white, blue.darker(), Color.white, Color.pink.darker(), Color.white, blue.darker(), this.ivBackColor}};
    private final Color[][] LT_BACK_COLORS_MAP = new Color[][]{{this.ivBackColor, Color.green.darker().darker(), this.ivBackColor, Color.darkGray, this.ivBackColor, Color.green.darker().darker(), this.ivBackColor, this.ivBackColor, this.ivBackColor, Color.red, this.ivBackColor, Color.red.brighter(), this.ivBackColor, Color.red, this.ivBackColor, this.ivBackColor, this.ivBackColor, Color.blue, this.ivBackColor, Color.yellow.darker(), this.ivBackColor, Color.blue, this.ivBackColor, this.ivBackColor, this.ivBackColor, Color.pink.darker(), this.ivBackColor, blue.darker(), this.ivBackColor, Color.pink.darker(), this.ivBackColor, this.ivBackColor}, {Color.white, Color.green.darker().darker(), Color.white, Color.darkGray, Color.white, Color.green.darker().darker(), Color.white, Color.white, Color.white, Color.red, Color.white, Color.red.brighter(), Color.white, Color.red, Color.white, Color.white, Color.white, Color.blue, Color.white, Color.yellow.darker(), Color.white, Color.blue, Color.white, Color.white, Color.white, Color.pink.darker(), Color.white, blue.darker(), Color.white, Color.pink.darker(), Color.white, Color.white}};
    private Color[][] ivForegroundColorsMap = this.DK_FORE_COLORS_MAP;
    private Color[][] ivBackgroundColorsMap = this.DK_BACK_COLORS_MAP;
    static final int UNDERSCORE = 1;
    static final int COLUMN_SEPARATOR = 2;
    static final int[] EXTRA_ATTR_MAP = new int[]{0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 2, 2, 2, 2, 3, 3, 3, 0, 0, 0, 0, 0, 1, 1, 1, 0};

    public XI5250CrtBuffer(int nCols, int nRows) {
        super(nCols, nRows);
        this.setDefAttr(32);
        this.clear();
    }

    public XI5250CrtBuffer(XI5250CrtBuffer from, int aC, int aR, int aW, int aH) {
        super(from, aC, aR, aW, aH);
        this.setDefBackground(from.getDefBackground());
    }

    @Override
    public Object clone() {
        return new XI5250CrtBuffer(this, 0, 0, this.getCrtSize().width, this.getCrtSize().height);
    }

    @Override
    public synchronized void drawString(String aStr, int col, int row, int aAttr) {
        int lPos = this.toLinearPos(col, row);
        col = this.toColPos(lPos);
        row = this.toRowPos(lPos);
        if (aAttr == 0) {
            aAttr = this.getAttr(col, row);
        }
        int len = aStr.length();
        int x = col;
        int y = row;
        int i = 0;
        int maxW = this.getCrtSize().width;
        while (len > 0) {
            int dx = Math.min(maxW - x, len);
            super.drawString(aStr.substring(i, i + dx), x, y, aAttr);
            i += dx;
            len -= dx;
            x = 0;
            ++y;
        }
    }

    protected void _drawAttributePlaceHolder(Graphics gr, int col, int row, int aAttr) {
        int lPos = this.toLinearPos(col, row);
        col = this.toColPos(lPos);
        row = this.toRowPos(lPos);
        int charW = this.getCharSize().width;
        int charH = this.getCharSize().height;
        gr.setColor(this.getBackground(32));
        gr.fillRect(col * charW, row * charH, charW, charH);
    }

    protected void _drawExtraAttribute(Graphics gr, int col, int row, int len, int aAttr) {
        int extra = this.getExtraCharAttribute(aAttr);
        int dy = 2;
        int charW = this.getCharSize().width;
        int charH = this.getCharSize().height;
        gr.setColor(this.getForeground(aAttr));
        if ((extra & 1) != 0) {
            gr.drawLine(col * charW, (row + 1) * charH - dy - 1, (col + len) * charW - 1, (row + 1) * charH - dy - 1);
        }
        if ((extra & 2) != 0) {
            gr.setColor(this.getForeground(34));
            for (int i = 0; i < len; ++i) {
                gr.drawLine((col + i) * charW, (row + 1) * charH - dy, (col + i) * charW, (row + 1) * charH - dy);
                gr.drawLine((col + i + 1) * charW - 1, (row + 1) * charH - dy, (col + i + 1) * charW - 1, (row + 1) * charH - dy);
            }
        }
    }

    @Override
    protected void _drawString(Graphics gr, String aStr, int col, int row, int aAttr) {
        if (aStr.length() <= 0) {
            return;
        }
        int pos = -1;
        for (int i = 0; i < aStr.length(); ++i) {
            if (aStr.charAt(i) != '\u0001') continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            super._drawString(gr, aStr, col, row, aAttr);
            this._drawExtraAttribute(gr, col, row, aStr.length(), aAttr);
        } else {
            if (pos > 0) {
                super._drawString(gr, aStr, col, row, aAttr);
                this._drawExtraAttribute(gr, col, row, aStr.length(), aAttr);
            }
            this._drawAttributePlaceHolder(gr, col + pos, row, aAttr);
            if (pos < aStr.length() - 1) {
                this._drawString(gr, aStr.substring(pos + 1), col + pos + 1, row, aAttr);
            }
        }
    }

    @Override
    public String getString(int col, int row, int nChars) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < nChars; ++i) {
            int j = this.toLinearPos(col + i, row);
            str.append(this.getChar(this.toColPos(j), this.toRowPos(j)));
        }
        return new String(str);
    }

    @Override
    protected Color getBackground(int aAttribute) {
        int mapIdx = Math.min(this.ivBackgroundColorsMap.length - 1, this.getColorMapIdx(aAttribute));
        return this.ivBackgroundColorsMap[mapIdx][this.getColorAttributeIdx(aAttribute) - 32];
    }

    @Override
    protected Color getForeground(int aAttribute) {
        int mapIdx = Math.min(this.ivForegroundColorsMap.length - 1, this.getColorMapIdx(aAttribute));
        return this.ivForegroundColorsMap[mapIdx][this.getColorAttributeIdx(aAttribute) - 32];
    }

    protected int getExtraCharAttribute(int aAttribute) {
        return EXTRA_ATTR_MAP[this.getColorAttributeIdx(aAttribute) - 32];
    }

    protected final byte getColorMapIdx(int aAttribute) {
        return (byte)(aAttribute >> 24 & 0xFF);
    }

    protected final int getColorAttributeIdx(int aAttribute) {
        return aAttribute & 0xFFFFFF;
    }

    @Override
    public int getAttr(int col, int row) {
        XI5250Field field;
        int attr = super.getAttr(col, row);
        XI5250Crt crt = (XI5250Crt)this.getCrt();
        if (crt != null && (field = crt.getFieldFromPos(col, row)) != null && !field.isOrgBypassField()) {
            attr |= 0x1000000;
        }
        return attr;
    }

    public final int toLinearPos(int aCol, int aRow) {
        return aRow * this.getCrtSize().width + aCol;
    }

    public final int toColPos(int aPos) {
        return aPos % this.getCrtSize().width;
    }

    public final int toRowPos(int aPos) {
        return aPos / this.getCrtSize().width;
    }

    public static final int colorAsIntensity(Color aColor) {
        float[] hsb = Color.RGBtoHSB(aColor.getRed(), aColor.getGreen(), aColor.getBlue(), null);
        return (int)(hsb[2] * 1000.0f);
    }

    public void setDefBackground(Color aColor) {
        if (this.ivBackColor.equals(aColor)) {
            return;
        }
        if (XI5250CrtBuffer.colorAsIntensity(this.ivBackColor) >= GRAY_INTENSITY != XI5250CrtBuffer.colorAsIntensity(aColor) >= GRAY_INTENSITY) {
            boolean dark = XI5250CrtBuffer.colorAsIntensity(aColor) < GRAY_INTENSITY;
            this.ivBackgroundColorsMap = dark ? this.DK_BACK_COLORS_MAP : this.LT_BACK_COLORS_MAP;
            this.ivForegroundColorsMap = dark ? this.DK_FORE_COLORS_MAP : this.LT_FORE_COLORS_MAP;
        }
        this.ivBackColor.setColor(aColor);
    }

    public Color getDefBackground() {
        return this.ivBackColor.getColor();
    }

    private static class ColorWrapper
    extends Color
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Color ivColor;

        public ColorWrapper(Color aColor) {
            super(0);
            this.ivColor = aColor;
        }

        public void setColor(Color aColor) {
            this.ivColor = aColor;
        }

        public Color getColor() {
            return this.ivColor;
        }

        @Override
        public int getRed() {
            return this.ivColor.getRed();
        }

        @Override
        public int getGreen() {
            return this.ivColor.getGreen();
        }

        @Override
        public int getBlue() {
            return this.ivColor.getBlue();
        }

        @Override
        public int getRGB() {
            return this.ivColor.getRGB();
        }

        @Override
        public Color brighter() {
            return this.ivColor.brighter();
        }

        @Override
        public Color darker() {
            return this.ivColor.darker();
        }

        @Override
        public int hashCode() {
            return this.ivColor.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.ivColor.equals(obj);
        }

        @Override
        public String toString() {
            return this.ivColor.toString();
        }
    }
}

