/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.crt5250;

import java.awt.AWTEventMulticaster;
import java.awt.AWTKeyStroke;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.infordata.em.crt.XICrt;
import net.infordata.em.crt.XICrtBuffer;
import net.infordata.em.crt5250.XI5250CrtBuffer;
import net.infordata.em.crt5250.XI5250CrtEvent;
import net.infordata.em.crt5250.XI5250CrtFrame;
import net.infordata.em.crt5250.XI5250CrtListener;
import net.infordata.em.crt5250.XI5250Field;
import net.infordata.em.crt5250.XI5250FieldsList;
import net.infordata.em.crt5250.XIEbcdicTranslator;

public class XI5250Crt
extends XICrt
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final int DEBUG = 0;
    public static final char ATTRIBUTE_PLACE_HOLDER = '\u0001';
    public static final int USE_PRESENT_ATTRIBUTE = 0;
    private transient int ivSBA;
    protected transient XI5250FieldsList ivFields = new XI5250FieldsList(this);
    private transient XI5250Field ivCurrentField;
    private boolean ivInsertState;
    private transient XI5250CrtListener ivCrtListener;
    transient boolean ivDropKeyChar;
    private int ivDefFieldsBorderStyle = 1;
    private transient XI5250Field ivFieldUnderMouse;
    private boolean ivRefCursor;
    private transient boolean ivDragging;
    private transient boolean ivMousePressed;
    private transient Point ivStartDragging;
    private transient Rectangle ivSelectedArea;
    private transient XI5250Field ivHighLightedField;
    public static final String INSERT_STATE = "insertState";
    public static final String REFERENCE_CURSOR = "referenceCursor";
    public static final String SELECTED_AREA = "selectedArea";
    public static final String DEF_FIELDS_BORDER_STYLE = "defFieldsBorderStyle";
    private static final XICrt.CursorShape cvInsertCursorShape = new InsertCursorShape();
    private static final XICrt.CursorShape cvNormalCursorShape = new NormalCursorShape();
    private final transient XICrt.CursorShape ivFixedCursorShape = new FixedCursorShape();
    public static final String CODE_PAGE = "codePage";
    public static final String DEFAULT_CODE_PAGE = "CP1144";
    private String ivCodePage = "CP1144";
    private transient XIEbcdicTranslator ivTranslator = XIEbcdicTranslator.getTranslator("CP1144");

    public XI5250Crt() {
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.enableEvents(8L);
        this.enableEvents(4L);
        this.setBackground(this.getDefBackground());
        Set<AWTKeyStroke> fks = this.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newFks = new HashSet<AWTKeyStroke>();
        for (AWTKeyStroke keyStroke : fks) {
            if (keyStroke.getKeyCode() == 9 && keyStroke.getModifiers() == 0) continue;
            newFks.add(keyStroke);
        }
        this.setFocusTraversalKeys(0, newFks);
        fks = this.getFocusTraversalKeys(1);
        newFks = new HashSet();
        for (AWTKeyStroke keyStroke : fks) {
            if (keyStroke.getKeyCode() == 9) continue;
            newFks.add(keyStroke);
        }
        this.setFocusTraversalKeys(1, newFks);
    }

    public XI5250Crt getStaticClone() {
        return this.getStaticClone(0, 0, this.getCrtSize().width, this.getCrtSize().height);
    }

    public synchronized XI5250Crt getStaticClone(int col, int row, int width, int height) {
        XI5250Crt crt = new XI5250Crt();
        crt.setCrtBuffer(new XI5250CrtBuffer((XI5250CrtBuffer)this.getCrtBuffer(), col, row, width, height));
        crt.setFont(this.getFont());
        crt.setBackground(this.getDefBackground());
        return crt;
    }

    @Override
    protected XICrtBuffer createCrtBuffer(int nCols, int nRows) {
        return new XI5250CrtBuffer(nCols, nRows);
    }

    @Override
    public synchronized void setCrtSize(int nCols, int nRows) {
        XI5250CrtBuffer oldCrt = (XI5250CrtBuffer)this.getCrtBuffer();
        super.setCrtSize(nCols, nRows);
        XI5250CrtBuffer newCrt = (XI5250CrtBuffer)this.getCrtBuffer();
        if (oldCrt != newCrt) {
            newCrt.setDefBackground(oldCrt.getDefBackground());
        }
    }

    @Override
    protected XICrt.CursorShape getCursorShape() {
        return this.ivInsertState ? cvInsertCursorShape : cvNormalCursorShape;
    }

    @Override
    protected XICrt.CursorShape getFixedCursorShape() {
        return this.ivRefCursor ? this.ivFixedCursorShape : null;
    }

    public synchronized void addCrtListener(XI5250CrtListener l) {
        this.ivCrtListener = Multicaster.add(this.ivCrtListener, l);
    }

    public synchronized void removeCrtListener(XI5250CrtListener l) {
        this.ivCrtListener = Multicaster.remove(this.ivCrtListener, l);
    }

    protected void processCrtEvent(XI5250CrtEvent e) {
        if (this.ivCrtListener == null) {
            return;
        }
        switch (e.getID()) {
            case 0: {
                this.ivCrtListener.fieldActivated(e);
                break;
            }
            case 1: {
                this.ivCrtListener.fieldDeactivated(e);
                break;
            }
            case 2: {
                this.ivCrtListener.sizeChanged(e);
                break;
            }
            case 3: {
                this.ivCrtListener.keyEvent(e);
                break;
            }
            case 4: {
                this.ivCrtListener.mouseEntersField(e);
                break;
            }
            case 5: {
                this.ivCrtListener.mouseExitsField(e);
            }
        }
    }

    public void initAllFields() {
        this.ivFields.init();
        this.setCursorPos(this.getCursorCol(), this.getCursorRow());
    }

    public void addField(XI5250Field aField) {
        this.ivFields.addField(aField);
    }

    public void removeFields() {
        try {
            this.setCurrentField(null);
            this.setFieldUnderMouse(null);
            this.setHighLightedField(null);
            this.ivFields.removeNotify();
        }
        finally {
            this.ivFields = new XI5250FieldsList(this);
        }
    }

    public List<XI5250Field> getFields() {
        return this.ivFields.getFields();
    }

    public XI5250Field getField(int idx) {
        return this.ivFields.getField(idx);
    }

    public XI5250Field getFieldFromPos(int aCol, int aRow) {
        return this.ivFields.fieldFromPos(aCol, aRow);
    }

    public XI5250Field getNextFieldFromPos(int aCol, int aRow) {
        return this.ivFields.nextFieldFromPos(aCol, aRow);
    }

    public XI5250Field getPrevFieldFromPos(int aCol, int aRow) {
        return this.ivFields.prevFieldFromPos(aCol, aRow);
    }

    public int getLabelLinearPos(String aLabel) {
        String str = this.getString();
        int pos = str.indexOf(aLabel);
        while (pos >= 0) {
            if (this.ivFields.fieldFromPos(this.toColPos(pos), this.toRowPos(pos)) == null) {
                return pos;
            }
            pos = str.indexOf(aLabel, pos + 1);
        }
        return -1;
    }

    public XI5250Field getFieldNextTo(String aLabel) {
        int pos = this.getLabelLinearPos(aLabel);
        if (pos < 0) {
            return null;
        }
        return this.getNextFieldFromPos(this.toColPos(pos), this.toRowPos(pos));
    }

    protected void userError(int aError) {
        Toolkit.getDefaultToolkit().beep();
    }

    public void setSBA(int col, int row) {
        this.setSBA(this.toLinearPos(col, row));
    }

    public void setSBA(int aLPos) {
        this.ivSBA = aLPos;
    }

    public int getSBA() {
        return this.ivSBA;
    }

    public int getSBACol() {
        return this.toColPos(this.ivSBA);
    }

    public int getSBARow() {
        return this.toRowPos(this.ivSBA);
    }

    public void setCodePage(String cp) {
        if (cp == null) {
            cp = DEFAULT_CODE_PAGE;
        }
        if (cp.equals(this.ivCodePage)) {
            return;
        }
        String old = this.ivCodePage;
        this.ivTranslator = XIEbcdicTranslator.getTranslator(cp);
        this.ivCodePage = cp;
        this.firePropertyChange(CODE_PAGE, old, this.ivCodePage);
    }

    public String getCodePage() {
        return this.ivCodePage;
    }

    public final XIEbcdicTranslator getTranslator() {
        if (this.ivTranslator != null) {
            return this.ivTranslator;
        }
        this.ivTranslator = XIEbcdicTranslator.getTranslator(this.ivCodePage);
        return this.ivTranslator;
    }

    public void setInsertState(boolean aInsertState) {
        if (aInsertState == this.ivInsertState) {
            return;
        }
        boolean wasCursorVisible = this.isCursorVisible();
        this.setCursorVisible(false);
        boolean oldInsertState = this.ivInsertState;
        this.ivInsertState = aInsertState;
        this.setCursorVisible(wasCursorVisible);
        this.firePropertyChange(INSERT_STATE, oldInsertState, this.ivInsertState);
    }

    public boolean isInsertState() {
        return this.ivInsertState;
    }

    public void setReferenceCursor(boolean aFlag) {
        if (aFlag == this.ivRefCursor) {
            return;
        }
        boolean wasCursorVisible = this.isCursorVisible();
        this.setCursorVisible(false);
        boolean oldRefCursor = this.ivRefCursor;
        this.ivRefCursor = aFlag;
        this.setCursorVisible(wasCursorVisible);
        this.firePropertyChange(REFERENCE_CURSOR, oldRefCursor, this.ivRefCursor);
    }

    public boolean isReferenceCursor() {
        return this.ivRefCursor;
    }

    @Override
    public void setCursorPos(int aCol, int aRow) {
        super.setCursorPos(aCol, aRow);
        XI5250Field field = this.ivFields.fieldFromPos(this.getCursorCol(), this.getCursorRow());
        this.setCurrentField(field);
    }

    public void moveCursor(int col, int row) {
        int xx = this.toLinearPos(col += this.getCursorCol(), row += this.getCursorRow());
        if (xx == -1) {
            xx = this.toLinearPos(this.getCrtSize().width - 1, this.getCrtSize().height - 1);
        } else if (xx < 0) {
            xx = this.toLinearPos(col, this.getCrtSize().height - 1);
        }
        col = this.toColPos(xx);
        row = this.toRowPos(xx);
        if (col < 0) {
            col = this.getCrtSize().width - 1;
        }
        if (row < 0) {
            row = this.getCrtSize().height - 1;
        }
        this.setCursorPos(col % this.getCrtSize().width, row % this.getCrtSize().height);
    }

    public void cursorOnNextField() {
        XI5250Field field;
        XI5250Field startField = field = this.ivFields.nextFieldFromPos(this.getCursorCol(), this.getCursorRow());
        if (field != null) {
            while (field.isBypassField() && (field = this.ivFields.nextFieldFromPos(field.getCol(), field.getRow())) != startField) {
            }
        }
        if (field != null && !field.isBypassField()) {
            this.setCursorPos(field.getCol(), field.getRow());
        }
    }

    public void cursorOnPrevField() {
        XI5250Field field;
        XI5250Field startField = field = this.ivFields.prevFieldFromPos(this.getCursorCol(), this.getCursorRow());
        if (field != null) {
            while (field.isBypassField() && (field = this.ivFields.prevFieldFromPos(field.getCol(), field.getRow())) != startField) {
            }
        }
        if (field != null && !field.isBypassField()) {
            this.setCursorPos(field.getCol(), field.getRow());
        }
    }

    public void cursorOnFirstField() {
        XI5250Field field;
        XI5250Field startField = field = this.ivFields.getField(0);
        if (field != null) {
            while (field.isBypassField() && (field = this.ivFields.nextFieldFromPos(field.getCol(), field.getRow())) != startField) {
            }
        }
        if (field != null && !field.isBypassField()) {
            this.setCursorPos(field.getCol(), field.getRow());
        }
    }

    protected void setCurrentField(XI5250Field field) {
        if (field == this.ivCurrentField) {
            return;
        }
        if (this.ivCurrentField != null) {
            this.ivCurrentField.activated(false);
            this.processCrtEvent(new XI5250CrtEvent(1, this, this.ivCurrentField));
        }
        this.ivCurrentField = field;
        if (this.ivCurrentField != null) {
            this.ivCurrentField.activated(true);
            this.processCrtEvent(new XI5250CrtEvent(0, this, this.ivCurrentField));
        }
    }

    public XI5250Field getCurrentField() {
        return this.ivCurrentField;
    }

    public void setHighLightedField(XI5250Field field) {
        Rectangle rt;
        if (field == this.ivHighLightedField) {
            return;
        }
        if (field != null && (this.ivFields == null || this.ivFields.fromFieldToIdx(field) < 0)) {
            throw new IllegalArgumentException("The given field isn' t actually present");
        }
        if (this.ivHighLightedField != null) {
            rt = this.ivHighLightedField.getBoundingRect();
            rt.grow(4, 4);
            this.repaint(rt.x, rt.y, rt.width, rt.height);
        }
        this.ivHighLightedField = field;
        if (this.ivHighLightedField != null) {
            rt = this.ivHighLightedField.getBoundingRect();
            rt.grow(4, 4);
            this.repaint(rt.x, rt.y, rt.width, rt.height);
        }
    }

    public XI5250Field getHighLightedField() {
        return this.ivHighLightedField;
    }

    protected void setFieldUnderMouse(XI5250Field aField) {
        if (aField == this.ivFieldUnderMouse) {
            return;
        }
        if (this.ivFieldUnderMouse != null) {
            this.processCrtEvent(new XI5250CrtEvent(5, this, this.ivFieldUnderMouse));
        }
        this.ivFieldUnderMouse = aField;
        if (this.ivFieldUnderMouse != null) {
            this.processCrtEvent(new XI5250CrtEvent(4, this, this.ivFieldUnderMouse));
        }
    }

    public XI5250Field getFieldUnderMouse() {
        return this.ivFieldUnderMouse;
    }

    private void checkFieldUnderMouse(MouseEvent e) {
        switch (e.getID()) {
            case 505: {
                this.setFieldUnderMouse(null);
                break;
            }
            default: {
                int col = e.getX() / this.getCharSize().width;
                int row = e.getY() / this.getCharSize().height;
                XI5250Field fld = this.getFieldFromPos(col, row);
                this.setFieldUnderMouse(fld);
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                this.requestFocus();
                if (this.ivMousePressed || e.getModifiers() != 16) break;
                this.ivMousePressed = true;
                this.setIvStartDragging(e);
                break;
            }
            case 502: {
                if (!this.ivMousePressed) break;
                this.ivMousePressed = false;
                if (!this.ivDragging) {
                    this.setSelectedArea(null);
                    if (new Rectangle(this.getCrtBufferSize()).contains(e.getPoint())) {
                        this.setCursorPos(e.getX() / this.getCharSize().width, e.getY() / this.getCharSize().height);
                    }
                } else {
                    this.setSelectedArea(this.ivStartDragging, new Point(this.assureColIn(e.getX() / this.getCharSize().width), this.assureRowIn(e.getY() / this.getCharSize().height)));
                }
                this.ivDragging = false;
            }
        }
        super.processMouseEvent(e);
        this.checkFieldUnderMouse(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        switch (e.getID()) {
            case 506: {
                if (!this.ivMousePressed) break;
                this.ivDragging = true;
                this.setSelectedArea(this.ivStartDragging, new Point(this.assureColIn(e.getX() / this.getCharSize().width), this.assureRowIn(e.getY() / this.getCharSize().height)));
            }
        }
        super.processMouseMotionEvent(e);
        this.checkFieldUnderMouse(e);
    }

    public void setIvMousePressed(boolean pressed) {
        this.ivMousePressed = pressed;
    }

    public void setIvStartDragging(MouseEvent e) {
        this.ivStartDragging = new Point(this.assureColIn(e.getX() / this.getCharSize().width), this.assureRowIn(e.getY() / this.getCharSize().height));
    }

    private void setSelectedArea(Point p1, Point p2) {
        this.setSelectedArea(new Rectangle(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p1.x - p2.x) + 1, Math.abs(p1.y - p2.y) + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedArea(Rectangle ivRect) {
        Rectangle oldSelectedArea;
        XI5250Crt xI5250Crt = this;
        synchronized (xI5250Crt) {
            if (this.ivSelectedArea != null && this.ivSelectedArea.equals(ivRect)) {
                return;
            }
            if (this.ivSelectedArea != null) {
                this.repaint(this.ivSelectedArea.x * this.getCharSize().width, this.ivSelectedArea.y * this.getCharSize().height, this.ivSelectedArea.width * this.getCharSize().width, this.ivSelectedArea.height * this.getCharSize().height);
            }
            oldSelectedArea = this.ivSelectedArea;
            Rectangle rectangle = this.ivSelectedArea = ivRect == null ? null : new Rectangle(ivRect);
            if (this.ivSelectedArea != null) {
                this.repaint(this.ivSelectedArea.x * this.getCharSize().width, this.ivSelectedArea.y * this.getCharSize().height, this.ivSelectedArea.width * this.getCharSize().width, this.ivSelectedArea.height * this.getCharSize().height);
            }
        }
        this.firePropertyChange(SELECTED_AREA, oldSelectedArea, this.ivSelectedArea);
    }

    public Rectangle getSelectedArea() {
        return this.ivSelectedArea == null ? null : new Rectangle(this.ivSelectedArea);
    }

    public String getStringSelectedArea() {
        if (this.ivSelectedArea == null) {
            return null;
        }
        StringBuilder strBuf = new StringBuilder();
        for (int r = this.ivSelectedArea.y; r < this.ivSelectedArea.y + this.ivSelectedArea.height; ++r) {
            strBuf.append("\n");
            strBuf.append(this.getString(this.ivSelectedArea.x, r, this.ivSelectedArea.width));
        }
        for (int i = 0; i < strBuf.length(); ++i) {
            if (strBuf.charAt(i) >= ' ' || strBuf.charAt(i) == '\n') continue;
            strBuf.setCharAt(i, ' ');
        }
        return strBuf.substring(1);
    }

    public void clearSelectedArea() {
        this.setSelectedArea(null);
    }

    private static void drawHorzLine(int inc, Graphics gc, int x, int y, int dx) {
        Graphics2D g2 = (Graphics2D)gc;
        float[] dash = new float[]{6.0f};
        BasicStroke b = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
        g2.setStroke(b);
        g2.drawLine(x, y, x + dx, y);
    }

    private static void drawVertLine(int inc, Graphics gc, int x, int y, int dy) {
        Graphics2D g2 = (Graphics2D)gc;
        float[] dash = new float[]{6.0f};
        BasicStroke b = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
        g2.setStroke(b);
        g2.drawLine(x, y, x, y + dy);
    }

    private void drawSelectedArea(Graphics aGc) {
        Rectangle rt = new Rectangle(this.ivSelectedArea.x * this.getCharSize().width, this.ivSelectedArea.y * this.getCharSize().height, this.ivSelectedArea.width * this.getCharSize().width, this.ivSelectedArea.height * this.getCharSize().height);
        Graphics gg = aGc.create();
        gg.setColor(Color.yellow);
        gg.setXORMode(Color.black);
        gg.clipRect(rt.x, rt.y, rt.width, rt.height);
        XI5250Crt.drawVertLine(5, gg, rt.x + 1, rt.y + 1, rt.height);
        XI5250Crt.drawHorzLine(5, gg, rt.x + 1, rt.y + 1, rt.width);
        XI5250Crt.drawVertLine(5, gg, rt.x + rt.width - 1, rt.y + 1, rt.height);
        XI5250Crt.drawHorzLine(5, gg, rt.x + 1, rt.y + rt.height - 1, rt.width);
        gg.dispose();
    }

    public static boolean isCharKey(KeyEvent e) {
        boolean res = e.getKeyChar() != '\uffff' && e.getKeyChar() >= ' ' && e.getKeyChar() != '\uffff' && e.getKeyCode() != 127 && e.getKeyChar() != '\u007f' && e.getKeyCode() != 107;
        return res;
    }

    @Override
    protected synchronized void processKeyEvent(KeyEvent e) {
        this.processRawKeyEvent(this.translateKeyEvent(e));
        if (!e.isConsumed()) {
            super.processKeyEvent(e);
        }
    }

    protected KeyEvent translateKeyEvent(KeyEvent e) {
        return e;
    }

    public synchronized void processRawKeyEvent(KeyEvent e) {
        this.doProcessKeyEvent(e);
    }

    protected synchronized void doProcessKeyEvent(KeyEvent e) {
        XI5250Field field = this.ivFields.fieldFromPos(this.getCursorCol(), this.getCursorRow());
        if (field != null && !field.isBypassField()) {
            field.processKeyEvent(e);
        }
        if (e.isConsumed()) {
            return;
        }
        this.processCrtEvent(new XI5250CrtEvent(3, this, this.ivCurrentField, e));
        if (e.isConsumed()) {
            return;
        }
        boolean res = false;
        switch (e.getID()) {
            case 401: {
                switch (e.getKeyCode()) {
                    case 38: {
                        res = this.processKeyUp(e.getModifiers());
                        break;
                    }
                    case 40: {
                        res = this.processKeyDown(e.getModifiers());
                        break;
                    }
                    case 37: {
                        res = this.processKeyLeft(e.getModifiers());
                        break;
                    }
                    case 39: {
                        res = this.processKeyRight(e.getModifiers());
                        break;
                    }
                    case 9: {
                        res = this.processKeyTab(e.getModifiers());
                        break;
                    }
                    case 155: {
                        res = this.processKeyIns(e.getModifiers());
                        break;
                    }
                    case 36: {
                        res = this.processKeyHome(e.getModifiers());
                    }
                }
                if (!res) break;
                e.consume();
            }
        }
    }

    protected boolean processKeyUp(int aModifier) {
        switch (aModifier) {
            case 0: {
                this.moveCursor(0, -1);
                return true;
            }
        }
        return false;
    }

    protected boolean processKeyDown(int aModifier) {
        switch (aModifier) {
            case 0: {
                this.moveCursor(0, 1);
                return true;
            }
        }
        return false;
    }

    protected boolean processKeyLeft(int aModifier) {
        switch (aModifier) {
            case 0: {
                this.moveCursor(-1, 0);
                return true;
            }
        }
        return false;
    }

    protected boolean processKeyRight(int aModifier) {
        switch (aModifier) {
            case 0: {
                this.moveCursor(1, 0);
                return true;
            }
        }
        return false;
    }

    protected boolean processKeyTab(int aModifier) {
        switch (aModifier) {
            case 0: {
                this.cursorOnNextField();
                return true;
            }
            case 1: {
                this.cursorOnPrevField();
                return true;
            }
        }
        return false;
    }

    protected boolean processKeyIns(int aModifier) {
        switch (aModifier) {
            case 0: {
                this.setInsertState(!this.ivInsertState);
                return true;
            }
            case 2: {
                this.doCopy();
                return true;
            }
            case 1: {
                this.doPaste();
                return true;
            }
        }
        return false;
    }

    protected boolean processKeyHome(int aModifier) {
        switch (aModifier) {
            case 0: {
                this.cursorOnFirstField();
                return true;
            }
            case 1: {
                this.setReferenceCursor(!this.isReferenceCursor());
                return true;
            }
            case 2: {
                break;
            }
        }
        return false;
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        switch (e.getID()) {
            case 1004: {
                this.setCursorVisible(true);
                break;
            }
            case 1005: {
                this.setCursorVisible(false);
            }
        }
        super.processFocusEvent(e);
    }

    @Override
    public void drawString(String str, int col, int row, int aAttr) {
        int lines = (col + str.length()) / this.getCrtSize().width + 1;
        if (lines <= 1) {
            super.drawString(str, col, row, aAttr);
        } else {
            XICrtBuffer crtBuffer = this.getCrtBuffer();
            crtBuffer.drawString(str, col, row, aAttr);
            this.repaint(0 * crtBuffer.getCharSize().width, row * crtBuffer.getCharSize().height, crtBuffer.getSize().width, lines * crtBuffer.getCharSize().height);
        }
    }

    public final int toLinearPos(int aCol, int aRow) {
        return ((XI5250CrtBuffer)this.getCrtBuffer()).toLinearPos(aCol, aRow);
    }

    public final int toColPos(int aPos) {
        return ((XI5250CrtBuffer)this.getCrtBuffer()).toColPos(aPos);
    }

    public final int toRowPos(int aPos) {
        return ((XI5250CrtBuffer)this.getCrtBuffer()).toRowPos(aPos);
    }

    @Override
    public void setFont(Font aFont) {
        Font oldFont = this.getFont();
        super.setFont(aFont);
        if (oldFont != this.getFont()) {
            this.processCrtEvent(new XI5250CrtEvent(2, this, this.ivCurrentField));
            if (this.ivFields != null) {
                this.ivFields.resized();
            }
        }
    }

    @Override
    protected void foregroundPaint(Graphics g) {
        this.ivFields.paint(g);
        super.foregroundPaint(g);
        if (this.ivHighLightedField != null) {
            Rectangle rt = this.ivHighLightedField.getBoundingRect();
            g.setColor(Color.red.brighter().brighter());
            rt.grow(1, 1);
            g.drawRoundRect(rt.x, rt.y, rt.width, rt.height, 4, 4);
            rt.grow(1, 1);
            g.drawRoundRect(rt.x, rt.y, rt.width, rt.height, 4, 4);
        }
        if (this.ivSelectedArea != null) {
            this.drawSelectedArea(g);
        }
    }

    public void setDefFieldsBorderStyle(int aStyle) {
        if (aStyle == this.ivDefFieldsBorderStyle) {
            return;
        }
        if (aStyle <= 0 || aStyle > 3) {
            throw new IllegalArgumentException("Wrong border style argument");
        }
        int oldDefFieldsBorderStyle = this.ivDefFieldsBorderStyle;
        this.ivDefFieldsBorderStyle = aStyle;
        this.repaint();
        this.firePropertyChange(DEF_FIELDS_BORDER_STYLE, oldDefFieldsBorderStyle, this.ivDefFieldsBorderStyle);
    }

    public int getDefFieldsBorderStyle() {
        return this.ivDefFieldsBorderStyle;
    }

    public synchronized void setDefBackground(Color aColor) {
        XI5250CrtBuffer ivBuf = (XI5250CrtBuffer)this.getCrtBuffer();
        if (ivBuf.getDefBackground().equals(aColor)) {
            return;
        }
        ivBuf.setDefBackground(aColor);
        this.setBackground(ivBuf.getDefBackground());
        ivBuf.copyFrom(ivBuf);
        this.repaint();
    }

    public Color getDefBackground() {
        return ((XI5250CrtBuffer)this.getCrtBuffer()).getDefBackground();
    }

    protected synchronized void doCopy() {
        String str = this.getStringSelectedArea();
        if (str == null) {
            return;
        }
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(str);
        clipboard.setContents(contents, contents);
        this.clearSelectedArea();
    }

    public boolean isPasteable() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this);
        return content != null && content.isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    protected synchronized void doPaste() {
        if (!this.isPasteable()) {
            return;
        }
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this);
        try {
            String str = (String)content.getTransferData(DataFlavor.stringFlavor);
            int col = this.getCursorCol();
            int row = this.getCursorRow();
            boolean error = false;
            for (int i = 0; i < str.length(); ++i) {
                XI5250Field field;
                char ch = str.charAt(i);
                if (ch == '\n') {
                    col = this.getCursorCol();
                    ++row;
                    continue;
                }
                if (ch < ' ') {
                    error = true;
                    ++col;
                    continue;
                }
                if (col >= 0 && col < this.getCrtSize().width && row >= 0 && row < this.getCrtSize().height && (field = this.getFieldFromPos(col, row)) != null) {
                    if (field.insertChar(ch, col, row, false, true) != 0) {
                        error = true;
                    }
                } else {
                    error = true;
                }
                ++col;
            }
            if (error) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] argv) {
        XI5250Crt crt = new XI5250Crt();
        XI5250CrtFrame frm = new XI5250CrtFrame("TEST", crt);
        frm.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                System.out.println("END.");
                System.exit(0);
            }
        });
        crt.setCursorPos(1, 2);
        crt.drawString("eccoci", 1, 2);
        crt.addField(new XI5250Field(crt, new byte[2], new byte[2], 1, 2, 6, -1));
        crt.drawString("green", 2, 0, 32);
        crt.drawString("green", 10, 0, 33);
        crt.drawString("redred", 20, 0, 40);
        crt.drawString("redred", 30, 0, 41);
        crt.drawString("redred", 40, 0, 42);
        crt.drawString("redred", 50, 0, 43);
        crt.drawString("blue", 0, 1, 58);
        crt.drawString("blue", 10, 1, 59);
        crt.drawString("turquoise", 20, 1, 48);
        crt.drawString("turquoise", 30, 1, 49);
        crt.drawString("yellow", 40, 1, 54);
        crt.drawString("yellow", 50, 1, 51);
        crt.drawString("pink", 60, 1, 56);
        crt.drawString("pink", 70, 1, 57);
        crt.drawString("XYZ", 79, 22, 52);
        crt.drawString("X", 79, 23);
        System.out.println(crt.getString(79, 22, 3));
        crt.addField(new XI5250Field(crt, new byte[2], new byte[2], 1, 6, 10, -1));
        crt.drawString("eccociABCD", 1, 6);
        XI5250Field fld = new XI5250Field(crt, new byte[2], new byte[2], 21, 3, 170, -1);
        fld.setBorderStyle(3);
        crt.addField(fld);
        crt.setHighLightedField(fld);
        crt.drawString("\u0001eccoci 0 1 2 3 4 5 6 7 8 9 0", 20, 3, 52);
        crt.drawString("FINE", 1, 5);
        byte[] FFW = new byte[]{7, 0};
        XI5250Field fld2 = new XI5250Field(crt, FFW, new byte[2], 1, 7, 6, -1);
        crt.addField(fld2);
        crt.drawString("\u0001", 0, 7, 52);
        FFW = new byte[]{3, 6};
        crt.addField(new XI5250Field(crt, FFW, new byte[2], 1, 8, 6, -1));
        crt.drawString("\u0001", 0, 8, 52);
        crt.initAllFields();
        crt.setDefFieldsBorderStyle(3);
        crt.setDefBackground(UIManager.getColor("control"));
        frm.setBounds(0, 0, 728, 512);
        frm.centerOnScreen();
        frm.setVisible(true);
        crt.setReferenceCursor(true);
        crt.setBlinkingCursor(true);
        try {
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException ex) {
            return;
        }
    }

    public static class SupportPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private XI5250Crt ivCrt;

        public SupportPanel(XI5250Crt crt) {
            super(null);
            if (crt == null) {
                throw new IllegalArgumentException();
            }
            this.ivCrt = crt;
            this.add(crt);
        }

        @Override
        protected void addImpl(Component comp, Object constraints, int index) {
            if (this.getComponentCount() > 0) {
                throw new IllegalStateException("This panel doesn't support components");
            }
            super.addImpl(comp, constraints, index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doLayout() {
            Object object = this.getTreeLock();
            synchronized (object) {
                Insets insets = this.getInsets();
                Dimension size = this.getSize();
                size.width -= insets.left + insets.right;
                size.height -= insets.top + insets.bottom;
                this.ivCrt.setSize(size);
                this.ivCrt.invalidate();
                Dimension pSize = this.ivCrt.getPreferredSize();
                this.ivCrt.setBounds(Math.max(insets.left, (size.width - pSize.width) / 2), Math.max(insets.top, (size.height - pSize.height) / 2), pSize.width, pSize.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            Dimension pSize = this.ivCrt.getPreferredSize();
            pSize.width += insets.left + insets.right;
            pSize.height += insets.top + insets.bottom;
            return pSize;
        }
    }

    private static class InsertCursorShape
    implements XICrt.CursorShape {
        private InsertCursorShape() {
        }

        @Override
        public void drawCursorShape(Graphics gc, Rectangle aRt) {
            Rectangle rt = new Rectangle(aRt);
            rt.grow(-1, -1);
            gc.setColor(Color.white);
            gc.setXORMode(Color.black);
            int dy = rt.height / 10;
            gc.fillRect(rt.x, rt.y + rt.height - dy * 5, rt.width, dy * 5);
            gc.setPaintMode();
        }
    }

    private static class NormalCursorShape
    implements XICrt.CursorShape {
        private NormalCursorShape() {
        }

        @Override
        public void drawCursorShape(Graphics gc, Rectangle aRt) {
            Rectangle rt = new Rectangle(aRt);
            rt.grow(-1, -1);
            gc.setColor(Color.white);
            gc.setXORMode(Color.black);
            int dy = rt.height / 10;
            gc.fillRect(rt.x, rt.y + rt.height - dy * 3, rt.width, dy * 3);
            gc.setPaintMode();
        }
    }

    private class FixedCursorShape
    implements XICrt.CursorShape {
        private FixedCursorShape() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drawCursorShape(Graphics gc, Rectangle aRt) {
            Dimension dim = XI5250Crt.this.getCrtBufferSize();
            Graphics gg = gc.create(0, 0, dim.width, dim.height);
            try {
                Rectangle rt = new Rectangle(aRt);
                rt.grow(-1, -1);
                gg.setColor(Color.white);
                gg.setXORMode(Color.black);
                XI5250Crt.drawVertLine(9, gg, rt.x, 0, dim.height);
                XI5250Crt.drawHorzLine(9, gg, 0, rt.y + rt.height - 1, dim.width);
            }
            finally {
                gg.dispose();
            }
        }
    }

    private static class Multicaster
    extends AWTEventMulticaster
    implements XI5250CrtListener {
        protected Multicaster(EventListener a, EventListener b) {
            super(a, b);
        }

        @Override
        protected EventListener remove(EventListener oldl) {
            if (oldl == this.a) {
                return this.b;
            }
            if (oldl == this.b) {
                return this.a;
            }
            EventListener a2 = Multicaster.removeInternal(this.a, oldl);
            EventListener b2 = Multicaster.removeInternal(this.b, oldl);
            if (a2 == this.a && b2 == this.b) {
                return this;
            }
            return Multicaster.add((XI5250CrtListener)a2, (XI5250CrtListener)b2);
        }

        public static XI5250CrtListener add(XI5250CrtListener a, XI5250CrtListener b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return new Multicaster(a, b);
        }

        public static XI5250CrtListener remove(XI5250CrtListener a, XI5250CrtListener b) {
            return (XI5250CrtListener)Multicaster.removeInternal(a, b);
        }

        @Override
        public void fieldActivated(XI5250CrtEvent e) {
            ((XI5250CrtListener)this.a).fieldActivated(e);
            ((XI5250CrtListener)this.b).fieldActivated(e);
        }

        @Override
        public void fieldDeactivated(XI5250CrtEvent e) {
            ((XI5250CrtListener)this.a).fieldDeactivated(e);
            ((XI5250CrtListener)this.b).fieldDeactivated(e);
        }

        @Override
        public void sizeChanged(XI5250CrtEvent e) {
            ((XI5250CrtListener)this.a).sizeChanged(e);
            ((XI5250CrtListener)this.b).sizeChanged(e);
        }

        @Override
        public void keyEvent(XI5250CrtEvent e) {
            ((XI5250CrtListener)this.a).keyEvent(e);
            ((XI5250CrtListener)this.b).keyEvent(e);
        }

        @Override
        public void mouseEntersField(XI5250CrtEvent e) {
            ((XI5250CrtListener)this.a).mouseEntersField(e);
            ((XI5250CrtListener)this.b).mouseEntersField(e);
        }

        @Override
        public void mouseExitsField(XI5250CrtEvent e) {
            ((XI5250CrtListener)this.a).mouseExitsField(e);
            ((XI5250CrtListener)this.b).mouseExitsField(e);
        }
    }
}

