/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.crt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.infordata.em.crt.XICrt;

public class XICrtBuffer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int ivNCols;
    private int ivNRows;
    private transient Graphics ivGr;
    private transient int ivCharW;
    private transient int ivCharH;
    private transient int ivCharD;
    private transient int ivGrW;
    private transient int ivGrH;
    private int ivDefAttr;
    private char[][] ivCharBuffer;
    private int[][] ivAttrBuffer;
    private transient List<Rectangle> ivDirtyAreas = new ArrayList<Rectangle>(20);
    private transient XICrt ivCrt;

    public XICrtBuffer(int nCols, int nRows) {
        this.ivNCols = nCols;
        this.ivNRows = nRows;
        this.ivCharBuffer = new char[this.ivNRows][this.ivNCols];
        this.ivAttrBuffer = new int[this.ivNRows][this.ivNCols];
        this.clear();
    }

    public XICrtBuffer(XICrtBuffer from, int aC, int aR, int aW, int aH) {
        this(aW, aH);
        this.copyFrom(0, 0, from, aC, aR, aW, aH);
        this.setDefAttr(from.getDefAttr());
    }

    public Object clone() {
        return new XICrtBuffer(this, 0, 0, this.ivNCols, this.ivNRows);
    }

    final void setCrt(XICrt crt) {
        this.ivCrt = crt;
    }

    public final XICrt getCrt() {
        return this.ivCrt;
    }

    public synchronized void setGraphics(Graphics gr) {
        this.ivGr = gr;
        if (this.ivGr != null) {
            FontMetrics fontMetrics = this.ivGr.getFontMetrics();
            this.ivCharW = fontMetrics.charWidth('W');
            this.ivCharH = fontMetrics.getHeight();
            this.ivCharD = fontMetrics.getDescent();
            this.ivGrW = this.ivNCols * this.ivCharW;
            this.ivGrH = this.ivNRows * this.ivCharH;
            this.copyFrom(this);
        } else {
            this.ivCharW = 1;
            this.ivCharH = 1;
            this.ivCharD = 1;
            this.ivGrW = this.ivNCols * this.ivCharW;
            this.ivGrH = this.ivNRows * this.ivCharH;
        }
    }

    public void dumpBuffer(PrintStream out) {
        int c;
        int r;
        out.println("BUFFER DUMP");
        for (r = 0; r < this.ivNRows; ++r) {
            for (c = 0; c < this.ivNCols; ++c) {
                out.print(this.ivCharBuffer[r][c]);
            }
            out.println();
        }
        for (r = 0; r < this.ivNRows; ++r) {
            for (c = 0; c < this.ivNCols; ++c) {
                out.print(Integer.toHexString(this.ivAttrBuffer[r][c]) + " ");
            }
            out.println();
        }
        out.println("END BUFFER DUMP");
    }

    public void copyFrom(XICrtBuffer from) {
        this.copyFrom(0, 0, from, 0, 0, from.ivNCols, from.ivNRows);
    }

    public synchronized void copyFrom(int col, int row, XICrtBuffer from, int aC, int aR, int aW, int aH) {
        aW = Math.min(aW, from.ivNCols - aC);
        aH = Math.min(aH, from.ivNRows - aR);
        int nCols = Math.min(this.ivNCols - col, aW);
        int nRows = Math.min(this.ivNRows - row, aH);
        for (int r = 0; r < nRows; ++r) {
            int c = 0;
            while (c < nCols) {
                int lastCol = col + c;
                int lastRow = row + r;
                int lastAttr = from.getAttrInternal(aC + c, aR + r);
                StringBuilder str = new StringBuilder();
                while (c < nCols && lastAttr == from.getAttrInternal(aC + c, aR + r)) {
                    str.append(from.getChar(aC + c, aR + r));
                    ++c;
                }
                this.drawString(new String(str), lastCol, lastRow, lastAttr);
            }
        }
    }

    public synchronized void invalidateAll() {
        this.addDirtyArea(new Rectangle(0, 0, this.ivNCols, this.ivNRows));
    }

    public synchronized void clear() {
        for (int c = 0; c < this.ivNCols; ++c) {
            for (int r = 0; r < this.ivNRows; ++r) {
                this.ivCharBuffer[r][c] = '\u0000';
                this.ivAttrBuffer[r][c] = this.ivDefAttr;
            }
        }
        this.ivDirtyAreas.clear();
        if (this.ivGr != null) {
            Graphics gr = this.ivGr.create();
            try {
                gr.setColor(this.getBackground(this.ivDefAttr));
                gr.fillRect(0, 0, this.ivGrW, this.ivGrH);
            }
            finally {
                gr.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scrollDown(int r1, int r2, int nRows) {
        int c;
        int r;
        if (r1 >= r2 || nRows == 0) {
            throw new IllegalArgumentException("ScrollDown()");
        }
        this.sync();
        nRows = Math.max(nRows, r2 - r1);
        for (r = r2; r > r1 + nRows; --r) {
            for (c = 0; c < this.ivNCols; ++c) {
                this.ivCharBuffer[r][c] = this.ivCharBuffer[r - nRows][c];
                this.ivAttrBuffer[r][c] = this.ivAttrBuffer[r - nRows][c];
            }
        }
        for (r = r1; r <= r1 + nRows; ++r) {
            for (c = 0; c < this.ivNCols; ++c) {
                this.ivCharBuffer[r][c] = '\u0000';
                this.ivAttrBuffer[r][c] = this.ivDefAttr;
            }
        }
        if (this.ivGr != null) {
            Graphics gr = this.ivGr.create();
            try {
                gr.copyArea(0, r1 * this.ivCharH, this.ivNCols * this.ivCharW, (r2 - r1) * this.ivCharH, 0, this.ivCharH * nRows);
                gr.setColor(this.getBackground(this.ivDefAttr));
                gr.fillRect(0, r1 * this.ivCharH, this.ivNCols * this.ivCharW, this.ivCharH * nRows);
            }
            finally {
                gr.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scrollUp(int r1, int r2, int nRows) {
        int c;
        int r;
        if (r1 >= r2 || nRows == 0) {
            throw new IllegalArgumentException("ScrollUp()");
        }
        this.sync();
        nRows = Math.max(nRows, r2 - r1);
        for (r = r1; r < r2 - nRows; ++r) {
            for (c = 0; c < this.ivNCols; ++c) {
                this.ivCharBuffer[r][c] = this.ivCharBuffer[r + nRows][c];
                this.ivAttrBuffer[r][c] = this.ivAttrBuffer[r + nRows][c];
            }
        }
        for (r = r2; r >= r2 - nRows; --r) {
            for (c = 0; c < this.ivNCols; ++c) {
                this.ivCharBuffer[r][c] = '\u0000';
                this.ivAttrBuffer[r][c] = this.ivDefAttr;
            }
        }
        if (this.ivGr != null) {
            Graphics gr = this.ivGr.create();
            try {
                gr.copyArea(0, (r1 + 1) * this.ivCharH, this.ivNCols * this.ivCharW, (r2 - r1) * this.ivCharH, 0, -this.ivCharH * nRows);
                gr.setColor(this.getBackground(this.ivDefAttr));
                gr.fillRect(0, (r2 - nRows + 1) * this.ivCharH, this.ivNCols * this.ivCharW, this.ivCharH * nRows);
            }
            finally {
                gr.dispose();
            }
        }
    }

    public Dimension getCrtSize() {
        return new Dimension(this.ivNCols, this.ivNRows);
    }

    public Dimension getSize() {
        return new Dimension(this.ivGrW, this.ivGrH);
    }

    public Dimension getCharSize() {
        return new Dimension(this.ivCharW, this.ivCharH);
    }

    public Point toPoint(int col, int row) {
        return new Point(col * this.ivCharW, (row + 1) * this.ivCharH);
    }

    public void drawString(String str, int col, int row) {
        this.drawString(str, col, row, this.ivDefAttr);
    }

    public synchronized void drawString(String aStr, int col, int row, int aAttr) {
        col = Math.max(0, Math.min(this.ivNCols - 1, col));
        row = Math.max(0, Math.min(this.ivNRows - 1, row));
        int len = Math.min(aStr.length(), this.ivNCols - col);
        if (len <= 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.ivCharBuffer[row][col + i] = aStr.charAt(i);
            this.ivAttrBuffer[row][col + i] = aAttr;
        }
        this.addDirtyArea(new Rectangle(col, row, len, 1));
    }

    private void addDirtyArea(Rectangle newRt) {
        Rectangle res = new Rectangle(newRt);
        int count = 0;
        Iterator<Rectangle> e = this.ivDirtyAreas.iterator();
        while (e.hasNext()) {
            Rectangle rt = e.next();
            Rectangle rtG = new Rectangle(rt);
            rtG.grow(1, 0);
            if (!rtG.intersects(newRt)) continue;
            e.remove();
            res = res.union(rt);
            if (++count < 2) continue;
        }
        this.ivDirtyAreas.add(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sync() {
        if (this.ivGr == null || this.ivDirtyAreas.isEmpty()) {
            return;
        }
        Graphics gr = this.ivGr.create();
        try {
            for (Rectangle rt : this.ivDirtyAreas) {
                for (int r = 0; r < rt.height; ++r) {
                    int c = 0;
                    while (c < rt.width) {
                        int lastCol = rt.x + c;
                        int lastRow = rt.y + r;
                        int lastAttr = this.getAttr(rt.x + c, rt.y + r);
                        StringBuilder str = new StringBuilder();
                        while (c < rt.width && lastAttr == this.getAttr(rt.x + c, rt.y + r)) {
                            str.append(this.getChar(rt.x + c, rt.y + r));
                            ++c;
                        }
                        this._drawString(gr, new String(str), lastCol, lastRow, lastAttr);
                    }
                }
            }
            this.ivDirtyAreas.clear();
        }
        finally {
            gr.dispose();
        }
    }

    protected void _drawString(Graphics gr, String aStr, int col, int row, int aAttr) {
        int len = aStr.length();
        gr.setColor(this.getBackground(aAttr));
        gr.fillRect(col * this.ivCharW, row * this.ivCharH, this.ivCharW * len, this.ivCharH);
        StringBuilder strBuf = new StringBuilder(aStr);
        for (int i = 0; i < strBuf.length(); ++i) {
            if (strBuf.charAt(i) >= ' ') continue;
            strBuf.setCharAt(i, ' ');
        }
        String str = new String(strBuf);
        gr.setColor(this.getForeground(aAttr));
        gr.drawString(str.substring(0, len), col * this.ivCharW, (row + 1) * this.ivCharH - this.ivCharD);
    }

    public String getString(int col, int row, int nChars) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < nChars; ++i) {
            str.append(this.getChar(col + i, row));
        }
        return new String(str);
    }

    public String getString() {
        char[] buf = new char[this.ivNRows * this.ivNCols];
        for (int i = 0; i < this.ivNRows; ++i) {
            System.arraycopy(this.ivCharBuffer[i], 0, buf, i * this.ivNCols, this.ivNCols);
        }
        return new String(buf);
    }

    protected Color getBackground(int aAttribute) {
        return Color.black;
    }

    protected Color getForeground(int aAttribute) {
        return Color.green;
    }

    public final int getAttrInternal(int col, int row) {
        col = Math.max(0, Math.min(this.ivNCols - 1, col));
        row = Math.max(0, Math.min(this.ivNRows - 1, row));
        return this.ivAttrBuffer[row][col];
    }

    public int getAttr(int col, int row) {
        return this.getAttrInternal(col, row);
    }

    public final char getChar(int col, int row) {
        col = Math.max(0, Math.min(this.ivNCols - 1, col));
        row = Math.max(0, Math.min(this.ivNRows - 1, row));
        return this.ivCharBuffer[row][col];
    }

    public void setDefAttr(int aAttr) {
        this.ivDefAttr = aAttr;
    }

    public final int getDefAttr() {
        return this.ivDefAttr;
    }

    public Point toPoints(int aCol, int aRow) {
        return new Point(aCol * this.ivCharW, aRow * this.ivCharH);
    }

    public Rectangle toPoints(int aCol, int aRow, int aNCols, int aNRows) {
        return new Rectangle(aCol * this.ivCharW, aRow * this.ivCharH, aNCols * this.ivCharW, aNRows * this.ivCharH);
    }

    void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }
}

