/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.telnet;

import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.streams.TelnetState;
import com.bytezone.dm3270.telnet.TelnetSubcommand;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;

public class TerminalTypeSubcommand
extends TelnetSubcommand {
    private static final byte OPTION_IS = 0;
    private static final byte OPTION_SEND = 1;

    public TerminalTypeSubcommand(byte[] buffer, int offset, int length, TelnetState telnetState) {
        super(buffer, offset, length, telnetState);
        if (buffer[3] == 0) {
            this.type = TelnetSubcommand.SubcommandType.IS;
            this.value = new String(buffer, 4, length - 6);
        } else if (buffer[3] == 1) {
            this.type = TelnetSubcommand.SubcommandType.SEND;
            this.value = "";
        } else {
            throw new InvalidParameterException(String.format("Unknown subcommand type: %02X%n", buffer[3]));
        }
    }

    @Override
    public void process(Screen screen) {
        if (this.type == TelnetSubcommand.SubcommandType.SEND) {
            byte[] header = new byte[]{-1, -6, 24, 0};
            byte[] terminal = this.getTerminalString().getBytes(StandardCharsets.US_ASCII);
            byte[] reply = new byte[header.length + terminal.length + 2];
            System.arraycopy(header, 0, reply, 0, header.length);
            System.arraycopy(terminal, 0, reply, header.length, terminal.length);
            reply[reply.length - 2] = -1;
            reply[reply.length - 1] = -16;
            this.telnetState.setTerminal(this.getTerminalString());
            this.setReply(new TerminalTypeSubcommand(reply, 0, reply.length, this.telnetState));
        }
    }

    private String getTerminalString() {
        return this.telnetState.doDeviceType() + (this.telnetState.do3270Extended() ? "-E" : "");
    }

    @Override
    public String toString() {
        switch (this.type) {
            case SEND: {
                return (Object)((Object)this.type) + " TerminalType";
            }
            case IS: {
                return (Object)((Object)this.type) + " TerminalType " + this.getTerminalString();
            }
        }
        return "SUB: Unknown";
    }
}

