/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.telnet;

import com.bytezone.dm3270.buffers.AbstractTelnetCommand;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.streams.TelnetState;
import java.security.InvalidParameterException;

public class TelnetCommand
extends AbstractTelnetCommand {
    public static final byte IAC = -1;
    public static final byte SB = -6;
    public static final byte SE = -16;
    private static final byte IP = -12;
    private static final byte NOP = -15;
    private static final byte DONT = -2;
    private static final byte DO = -3;
    private static final byte WONT = -4;
    private static final byte WILL = -5;
    private final CommandName commandName;
    private final CommandType commandType;

    private TelnetCommand(TelnetState state, byte[] buffer) {
        this(state, buffer, buffer.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TelnetCommand(TelnetState state, byte[] buffer, int length) {
        super(buffer, 0, length, state);
        byte command = buffer[1];
        if (length == 2) {
            if (command == -15) {
                this.commandName = CommandName.NO_OP;
            } else {
                if (command != -12) throw new InvalidParameterException(String.format("Unknown telnet command: %02X%n", command));
                this.commandName = CommandName.INTERRUPT_PROCESS;
            }
            this.commandType = null;
            return;
        } else {
            if (length != 3) throw new InvalidParameterException("Buffer incorrect length");
            byte type = buffer[2];
            if (command == -3) {
                this.commandName = CommandName.DO;
            } else if (command == -2) {
                this.commandName = CommandName.DONT;
            } else if (command == -5) {
                this.commandName = CommandName.WILL;
            } else {
                if (command != -4) throw new InvalidParameterException(String.format("Unknown telnet command: %02X %02X%n", command, type));
                this.commandName = CommandName.WONT;
            }
            if (type == 24) {
                this.commandType = CommandType.TERMINAL_TYPE;
                return;
            } else if (type == 25) {
                this.commandType = CommandType.EOR;
                return;
            } else if (type == 0) {
                this.commandType = CommandType.BINARY;
                return;
            } else if (type == 40) {
                this.commandType = CommandType.TN3270_EXTENDED;
                return;
            } else {
                if (type != 46) throw new InvalidParameterException(String.format("Unknown telnet command type: %02X %02X%n", command, type));
                this.commandType = CommandType.START_TLS;
            }
        }
    }

    @Override
    public void process(Screen screen) {
        if (this.commandName == CommandName.DO) {
            byte[] reply = new byte[]{-1, -4, this.data[2]};
            if (this.commandType == CommandType.TN3270_EXTENDED) {
                boolean preference = this.telnetState.do3270Extended();
                reply[1] = preference ? -5 : -4;
                this.telnetState.setDoes3270Extended(preference);
            } else if (this.commandType == CommandType.TERMINAL_TYPE) {
                boolean preference = this.telnetState.doTerminalType();
                reply[1] = preference ? -5 : -4;
                this.telnetState.setDoesTerminalType(preference);
            } else if (this.commandType == CommandType.EOR) {
                boolean preference = this.telnetState.doEOR();
                reply[1] = preference ? -5 : -4;
                this.telnetState.setDoesEOR(preference);
            } else if (this.commandType == CommandType.BINARY) {
                boolean preference = this.telnetState.doBinary();
                reply[1] = preference ? -5 : -4;
                this.telnetState.setDoesBinary(preference);
            }
            this.setReply(new TelnetCommand(this.telnetState, reply));
        } else if (this.commandName == CommandName.WILL) {
            byte[] reply = new byte[3];
            reply[0] = -1;
            if (this.commandType == CommandType.TN3270_EXTENDED) {
                reply[1] = this.telnetState.does3270Extended() ? -3 : -2;
                this.telnetState.setDoes3270Extended(true);
            }
            if (this.commandType == CommandType.TERMINAL_TYPE) {
                reply[1] = this.telnetState.doesTerminalType() ? -3 : -2;
                this.telnetState.setDoesTerminalType(true);
            }
            if (this.commandType == CommandType.EOR) {
                reply[1] = this.telnetState.doesEOR() ? -3 : -2;
                this.telnetState.setDoesEOR(true);
            }
            if (this.commandType == CommandType.BINARY) {
                reply[1] = this.telnetState.doesBinary() ? -3 : -2;
                this.telnetState.setDoesBinary(true);
            }
            reply[2] = this.data[2];
            this.setReply(new TelnetCommand(this.telnetState, reply));
        } else if (this.commandName == CommandName.DONT || this.commandName == CommandName.WONT) {
            if (this.commandType == CommandType.BINARY) {
                this.telnetState.setDoesBinary(false);
            }
            if (this.commandType == CommandType.TERMINAL_TYPE) {
                this.telnetState.setDoesTerminalType(false);
            }
            if (this.commandType == CommandType.TN3270_EXTENDED) {
                this.telnetState.setDoes3270Extended(false);
            }
            if (this.commandType == CommandType.EOR) {
                this.telnetState.setDoesEOR(false);
            }
        }
    }

    public String getName() {
        if (this.commandName == CommandName.NO_OP) {
            return "NoOp";
        }
        return this.toString();
    }

    public String toString() {
        return String.format("%s %s", new Object[]{this.commandName, this.commandType == null ? "" : this.commandType});
    }

    private static enum CommandType {
        TERMINAL_TYPE,
        EOR,
        BINARY,
        TN3270_EXTENDED,
        START_TLS;

    }

    private static enum CommandName {
        DO,
        DONT,
        WILL,
        WONT,
        NO_OP,
        INTERRUPT_PROCESS;

    }
}

