/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.structuredfields;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.attributes.Attribute;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.structuredfields.StructuredField;

public class SetReplyModeSF
extends StructuredField {
    public static final byte RM_FIELD = 0;
    public static final byte RM_CHARACTER = 2;
    private static final String[] MODES = new String[]{"Field", "Extended field", "Character"};
    private final byte partition;
    private final byte replyMode;
    private final byte[] types;

    public SetReplyModeSF(byte[] buffer, int offset, int length, Charset charset) {
        super(buffer, offset, length, charset);
        assert (this.data[0] == 9);
        int ptr = offset + 1;
        this.partition = buffer[ptr++];
        this.replyMode = buffer[ptr++];
        int totalTypes = length - 3;
        this.types = new byte[totalTypes];
        System.arraycopy(buffer, ptr, this.types, 0, this.types.length);
    }

    @Override
    public void process(Screen screen) {
        screen.setReplyMode(this.replyMode, this.types);
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder("Struct Field : 09 Set Reply Mode\n");
        text.append(String.format("   partition : %02X%n", this.partition));
        text.append(String.format("   mode      : %02X %s mode", this.replyMode, MODES[this.replyMode]));
        for (byte type : this.types) {
            String typeName = Attribute.getTypeName(type);
            text.append(String.format("%n   type      : %02X %s", type, typeName));
        }
        return text.toString();
    }
}

