/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.structuredfields;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.buffers.Buffer;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.commands.ReadPartitionQuery;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.structuredfields.StructuredField;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadPartitionSF
extends StructuredField {
    private static final Logger LOG = LoggerFactory.getLogger(ReadPartitionSF.class);
    private final byte partitionID;
    private final Command command;

    public ReadPartitionSF(byte[] buffer, int offset, int length, Charset charset) {
        super(buffer, offset, length, charset);
        assert (this.data[0] == 1);
        this.partitionID = this.data[1];
        if (this.partitionID == -1) {
            switch (this.data[2]) {
                case 2: 
                case 3: {
                    this.command = new ReadPartitionQuery(buffer, offset, length, charset);
                    break;
                }
                default: {
                    this.command = null;
                    break;
                }
            }
        } else {
            assert ((this.partitionID & 0xFFFFFF80) == 0);
            this.command = Command.getCommand(buffer, offset + 2, length - 2, charset);
            LOG.debug("RB/RM/RMA: {}", (Object)this.command);
        }
    }

    @Override
    public void process(Screen screen) {
        if (this.getReply().isPresent()) {
            return;
        }
        if (this.partitionID == -1) {
            this.command.process(screen);
            Optional<Buffer> opt = this.command.getReply();
            if (opt.isPresent()) {
                this.setReply(opt.get());
            } else {
                this.setReply(null);
            }
        } else {
            this.command.process(screen);
            Optional<Buffer> opt = this.command.getReply();
            if (opt.isPresent()) {
                this.setReply(opt.get());
            } else {
                this.setReply(null);
            }
            LOG.debug("testing read command reply");
        }
    }

    @Override
    public String toString() {
        return "Struct Field : 01 Read Partition\n" + String.format("   partition : %02X%n", this.partitionID) + this.command;
    }
}

