/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.streams;

import com.bytezone.dm3270.ConnectionListener;
import com.bytezone.dm3270.streams.BufferListener;
import com.bytezone.dm3270.streams.TelnetSocket;
import com.bytezone.dm3270.streams.TelnetState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.LocalDateTime;
import javax.net.SocketFactory;

public class TerminalServer
implements Runnable {
    private final String serverURL;
    private final int serverPort;
    private final SocketFactory socketFactory;
    private int connectionTimeoutMillis;
    private Socket serverSocket;
    private OutputStream serverOut;
    private final byte[] buffer = new byte[4096];
    private volatile boolean running;
    private final BufferListener telnetListener;
    private ConnectionListener connectionListener;

    public TerminalServer(String serverURL, int serverPort, SocketFactory socketFactory, BufferListener listener) {
        this.serverPort = serverPort;
        this.serverURL = serverURL;
        this.socketFactory = socketFactory;
        this.telnetListener = listener;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    @Override
    public void run() {
        block7: {
            try {
                try {
                    this.serverSocket = this.socketFactory.createSocket();
                    this.serverSocket.connect(new InetSocketAddress(this.serverURL, this.serverPort), this.connectionTimeoutMillis);
                    this.connectionListener.onConnection();
                }
                catch (IOException ex) {
                    this.handleException(ex);
                    return;
                }
                InputStream serverIn = this.serverSocket.getInputStream();
                this.serverOut = this.serverSocket.getOutputStream();
                this.running = true;
                while (this.running) {
                    int bytesRead = serverIn.read(this.buffer);
                    if (bytesRead < 0) {
                        this.close();
                        if (this.connectionListener != null) {
                            this.connectionListener.onConnectionClosed();
                        }
                        break;
                    }
                    byte[] message = new byte[bytesRead];
                    System.arraycopy(this.buffer, 0, message, 0, bytesRead);
                    this.telnetListener.listen(TelnetSocket.Source.SERVER, message, LocalDateTime.now(), true);
                }
            }
            catch (IOException e) {
                if (!this.running) break block7;
                this.close();
                this.handleException(e);
            }
        }
    }

    private void handleException(IOException ex) {
        if (this.connectionListener != null) {
            this.connectionListener.onException(ex);
        } else {
            ex.printStackTrace();
        }
    }

    public synchronized void write(byte[] buffer) {
        if (!this.running && buffer == TelnetState.NO_OP) {
            return;
        }
        try {
            this.serverOut.write(buffer);
            this.serverOut.flush();
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void close() {
        try {
            this.running = false;
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
            if (this.telnetListener != null) {
                this.telnetListener.close();
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public String toString() {
        return String.format("TerminalSocket listening to %s : %d", this.serverURL, this.serverPort);
    }
}

