/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.streams;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.buffers.AbstractReplyBuffer;
import com.bytezone.dm3270.buffers.Buffer;
import com.bytezone.dm3270.buffers.ReplyBuffer;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.extended.BindCommand;
import com.bytezone.dm3270.extended.CommandHeader;
import com.bytezone.dm3270.extended.ResponseCommand;
import com.bytezone.dm3270.extended.SscpLuDataCommand;
import com.bytezone.dm3270.extended.TN3270ExtendedCommand;
import com.bytezone.dm3270.extended.UnbindCommand;
import com.bytezone.dm3270.session.SessionRecord;
import com.bytezone.dm3270.streams.BufferListener;
import com.bytezone.dm3270.streams.TelnetSocket;
import com.bytezone.dm3270.streams.TelnetState;
import com.bytezone.dm3270.telnet.TN3270ExtendedSubcommand;
import com.bytezone.dm3270.telnet.TelnetCommand;
import com.bytezone.dm3270.telnet.TelnetCommandProcessor;
import com.bytezone.dm3270.telnet.TelnetProcessor;
import com.bytezone.dm3270.telnet.TelnetSubcommand;
import com.bytezone.dm3270.telnet.TerminalTypeSubcommand;
import java.time.LocalDateTime;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetListener
implements BufferListener,
TelnetCommandProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TelnetListener.class);
    private final TelnetSocket.Source source;
    private final Charset charset;
    private final TelnetState telnetState;
    private final Screen screen;
    private final TelnetProcessor telnetProcessor = new TelnetProcessor(this);

    public TelnetListener(Screen screen, TelnetState telnetState) {
        this.screen = screen;
        this.charset = screen.getCharset();
        this.telnetState = telnetState;
        this.source = TelnetSocket.Source.SERVER;
    }

    @Override
    public synchronized void listen(TelnetSocket.Source source, byte[] buffer, LocalDateTime dateTime, boolean genuine) {
        assert (source == this.source) : "Incorrect source: " + (Object)((Object)source) + ", expecting: " + (Object)((Object)this.source);
        this.telnetProcessor.listen(buffer);
        this.telnetState.setLastAccess();
    }

    @Override
    public void close() {
    }

    @Override
    public void processData(byte[] buffer, int length) {
        LOG.warn("Unknown telnet data received: {}", (Object)Buffer.toHex(buffer, 0, length));
    }

    @Override
    public void processRecord(byte[] data, int dataPtr) {
        CommandHeader.DataType dataType;
        CommandHeader currentCommandHeader;
        int length;
        int offset;
        if (this.telnetState.does3270Extended()) {
            offset = 5;
            length = dataPtr - 7;
            currentCommandHeader = new CommandHeader(data, 0, 5, this.charset);
            dataType = currentCommandHeader.getDataType();
        } else {
            offset = 0;
            length = dataPtr - 2;
            currentCommandHeader = null;
            dataType = CommandHeader.DataType.TN3270_DATA;
        }
        switch (dataType) {
            case TN3270_DATA: {
                AbstractReplyBuffer command;
                if (length <= 0) {
                    command = currentCommandHeader;
                } else {
                    command = this.source == TelnetSocket.Source.SERVER ? Command.getCommand(data, offset, length, this.screen.getCharset()) : Command.getReply(data, offset, length, this.screen.getCharset());
                    if (currentCommandHeader != null) {
                        command = new TN3270ExtendedCommand(currentCommandHeader, (Command)command, this.telnetState, this.charset);
                    }
                }
                this.addDataRecord(command, SessionRecord.SessionRecordType.TN3270);
                break;
            }
            case BIND_IMAGE: {
                BindCommand bindCommand = new BindCommand(currentCommandHeader, data, offset, length, this.screen.getCharset());
                this.addDataRecord(bindCommand, SessionRecord.SessionRecordType.TN3270E);
                break;
            }
            case UNBIND: {
                UnbindCommand unbindCommand = new UnbindCommand(currentCommandHeader, data, offset, length);
                this.addDataRecord(unbindCommand, SessionRecord.SessionRecordType.TN3270E);
                break;
            }
            case RESPONSE: {
                ResponseCommand responseCommand = new ResponseCommand(currentCommandHeader, data, offset, length, this.charset);
                this.addDataRecord(responseCommand, SessionRecord.SessionRecordType.TN3270E);
                break;
            }
            case SSCP_LU_DATA: {
                TN3270ExtendedCommand extCommand = new TN3270ExtendedCommand(currentCommandHeader, new SscpLuDataCommand(data, offset, length, this.screen.getCharset()), this.telnetState, this.charset);
                this.addDataRecord(extCommand, SessionRecord.SessionRecordType.TN3270E);
                break;
            }
            case BID: {
                this.addDataRecord(currentCommandHeader, SessionRecord.SessionRecordType.TN3270E);
                break;
            }
            default: {
                LOG.warn("Data type not written: {}, {}", (Object)dataType, (Object)this.charset.toHex(data, offset, length));
            }
        }
    }

    @Override
    public void processTelnetCommand(byte[] data, int dataPtr) {
        TelnetCommand telnetCommand = new TelnetCommand(this.telnetState, data, dataPtr);
        this.addDataRecord(telnetCommand, SessionRecord.SessionRecordType.TELNET);
        telnetCommand.process(this.screen);
    }

    @Override
    public void processTelnetSubcommand(byte[] data, int dataPtr) {
        TelnetSubcommand subcommand = null;
        if (data[2] == 24) {
            subcommand = new TerminalTypeSubcommand(data, 0, dataPtr, this.telnetState);
        } else if (data[2] == 40) {
            subcommand = new TN3270ExtendedSubcommand(data, 0, dataPtr, this.telnetState);
        } else {
            LOG.warn("Unknown command type : {}", (Object)Buffer.toHex(data, 2, 1));
        }
        this.addDataRecord(subcommand, SessionRecord.SessionRecordType.TELNET);
    }

    private void addDataRecord(ReplyBuffer message, SessionRecord.SessionRecordType sessionRecordType) {
        if (sessionRecordType == SessionRecord.SessionRecordType.TELNET) {
            this.processMessage(message);
        } else {
            this.processMessage(message);
        }
    }

    private void processMessage(ReplyBuffer message) {
        message.process(this.screen);
        Optional<Buffer> reply = message.getReply();
        reply.ifPresent(buffer -> this.telnetState.write(buffer.getTelnetData()));
    }
}

