/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.session;

import com.bytezone.dm3270.buffers.ReplyBuffer;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.extended.TN3270ExtendedCommand;
import com.bytezone.dm3270.streams.TelnetSocket;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class SessionRecord {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("dd MMM uuuu HH:mm:ss.S");
    private final ReplyBuffer message;
    private final TelnetSocket.Source source;
    private final LocalDateTime dateTime;

    public SessionRecord(ReplyBuffer message, TelnetSocket.Source source, LocalDateTime dateTime) {
        this.message = message;
        this.source = source;
        this.dateTime = dateTime;
    }

    public boolean isCommand() {
        return this.message instanceof Command || this.message instanceof TN3270ExtendedCommand;
    }

    public Command getCommand() {
        if (this.message instanceof Command) {
            return (Command)this.message;
        }
        if (this.message instanceof TN3270ExtendedCommand) {
            return ((TN3270ExtendedCommand)this.message).getCommand();
        }
        return null;
    }

    public byte[] getBuffer() {
        return this.message.getData();
    }

    public int size() {
        return this.message.size();
    }

    public String toString() {
        return String.format("%s : %s", new Object[]{this.source, FORMATTER.format(this.dateTime)});
    }

    public static enum SessionRecordType {
        TELNET,
        TN3270,
        TN3270E;

    }
}

