/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.replyfield;

import com.bytezone.dm3270.replyfield.QueryReplyField;

public class Highlight
extends QueryReplyField {
    private static final byte HIGHLIGHT_DEFAULT = 0;
    private static final byte HIGHLIGHT_NORMAL = -16;
    private static final byte HIGHLIGHT_BLINK = -15;
    private static final byte HIGHLIGHT_REVERSE = -14;
    private static final byte HIGHLIGHT_UNDERSCORE = -12;
    private static final byte HIGHLIGHT_INTENSIFY = -8;
    private static final String[] VALUES = new String[]{"Normal", "Blink", "Reverse video", "", "Underscore", "", "", "", "Intensity"};
    private int pairs;
    private byte[] attributeValue;
    private byte[] action;

    public Highlight() {
        super((byte)-121);
        int ptr = this.createReply(11);
        this.reply[ptr++] = 5;
        this.reply[ptr++] = 0;
        this.reply[ptr++] = -16;
        this.reply[ptr++] = -15;
        this.reply[ptr++] = -15;
        this.reply[ptr++] = -14;
        this.reply[ptr++] = -14;
        this.reply[ptr++] = -12;
        this.reply[ptr++] = -12;
        this.reply[ptr++] = -8;
        this.reply[ptr++] = -8;
        this.checkDataLength(ptr);
    }

    public Highlight(byte[] buffer) {
        super(buffer);
        assert (this.data[1] == -121);
        this.pairs = this.data[2] & 0xFF;
        this.attributeValue = new byte[this.pairs];
        this.action = new byte[this.pairs];
        for (int i = 0; i < this.pairs; ++i) {
            this.attributeValue[i] = this.data[i * 2 + 3];
            this.action[i] = this.data[i * 2 + 4];
        }
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder(super.toString());
        text.append(String.format("%n  pairs      : %d", this.pairs));
        for (int i = 0; i < this.pairs; ++i) {
            byte av = this.attributeValue[i];
            String attrText = av == 0 ? "Default" : VALUES[av & 0xF];
            String actionText = VALUES[this.action[i] & 0xF];
            String out = attrText.equals(actionText) ? attrText : attrText + " -> " + actionText;
            text.append(String.format("%n  val/actn   : %02X/%02X - %s", this.attributeValue[i], this.action[i], out));
        }
        return text.toString();
    }
}

