/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.replyfield;

import com.bytezone.dm3270.replyfield.QueryReplyField;
import java.nio.ByteBuffer;

public class DistributedDataManagement
extends QueryReplyField {
    private final short flags;
    private final short maximumInboundBytes;
    private final short maximumOutboundBytes;
    private final byte supportedSubsetsCount;
    private final byte ddmSubsetId;

    public DistributedDataManagement(byte[] buffer) {
        super(buffer);
        ByteBuffer dataBuffer = ByteBuffer.wrap(buffer);
        dataBuffer.get();
        assert (dataBuffer.get() == -107);
        this.flags = dataBuffer.getShort();
        this.maximumInboundBytes = dataBuffer.getShort();
        this.maximumOutboundBytes = dataBuffer.getShort();
        this.supportedSubsetsCount = dataBuffer.get();
        this.ddmSubsetId = dataBuffer.get();
    }

    public DistributedDataManagement() {
        super((byte)-107);
        this.flags = 0;
        this.maximumInboundBytes = (short)8192;
        this.maximumOutboundBytes = (short)8192;
        this.supportedSubsetsCount = 1;
        this.ddmSubsetId = 1;
        ByteBuffer buffer = this.createReplyBuffer(8);
        buffer.putShort(this.flags);
        buffer.putShort(this.maximumInboundBytes);
        buffer.putShort(this.maximumOutboundBytes);
        buffer.put(this.supportedSubsetsCount);
        buffer.put(this.ddmSubsetId);
    }

    @Override
    public String toString() {
        return super.toString() + String.format("%n  flags      : %04X", this.flags) + String.format("%n  limit in   : %d", this.maximumInboundBytes) + String.format("%n  limit out  : %d", this.maximumOutboundBytes) + String.format("%n  subsets    : %d", this.supportedSubsetsCount) + String.format("%n  DDMSS      : %d", this.ddmSubsetId);
    }
}

