/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.replyfield;

import com.bytezone.dm3270.attributes.ColorAttribute;
import com.bytezone.dm3270.replyfield.QueryReplyField;
import java.nio.ByteBuffer;

public class Color
extends QueryReplyField {
    private static final byte[] COLORS_ARRAY = new byte[]{0, -12, -15, -15, -14, -14, -13, -13, -12, -12, -11, -11, -10, -10, -9, -9, -8, -8, -7, -7, -6, -6, -5, -5, -4, -4, -3, -3, -2, -2, -1, -1};
    private final byte flags;
    private final byte[] colors;

    public Color() {
        super((byte)-122);
        this.flags = 0;
        this.colors = COLORS_ARRAY;
        ByteBuffer buffer = this.createReplyBuffer(this.colors.length + 1 + 1);
        buffer.put(this.flags);
        buffer.put((byte)(this.colors.length / 2));
        buffer.put(this.colors, 0, this.colors.length);
    }

    public Color(byte[] buffer) {
        super(buffer);
        ByteBuffer dataBuffer = ByteBuffer.wrap(buffer);
        dataBuffer.get();
        assert (dataBuffer.get() == -122);
        this.flags = dataBuffer.get();
        byte colorsCount = dataBuffer.get();
        this.colors = new byte[colorsCount * 2];
        dataBuffer.get(this.colors, 0, this.colors.length);
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder(super.toString());
        text.append(String.format("%n  flags      : %02X", this.flags));
        text.append(String.format("%n  pairs      : %d", this.colors.length / 2));
        for (int i = 0; i < this.colors.length; i += 2) {
            text.append(String.format("%n  val/actn   : %02X/%02X - %s", this.colors[i], this.colors[i + 1], ColorAttribute.colorName(this.colors[i])));
            if (this.colors[i] == this.colors[i + 1]) continue;
            text.append("/").append(ColorAttribute.colorName(this.colors[i + 1]));
        }
        return text.toString();
    }
}

