/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.replyfield;

import com.bytezone.dm3270.buffers.Buffer;
import com.bytezone.dm3270.replyfield.QueryReplyField;

public class AlphanumericPartitions
extends QueryReplyField {
    private int maxPartitions;
    private int totalAvailableStorage;
    private byte flags;
    private boolean vertWin;
    private boolean horWin;
    private boolean allPointsAddressability;
    private boolean partitionProtection;
    private boolean localCopy;
    private boolean modifyPartition;

    public AlphanumericPartitions(byte[] buffer) {
        super(buffer);
        assert (this.data[1] == -124);
        this.maxPartitions = this.data[2] & 0xFF;
        this.totalAvailableStorage = Buffer.unsignedShort(this.data, 3);
        this.flags = this.data[5];
        this.vertWin = (this.flags & 0x80) != 0;
        this.horWin = (this.flags & 0x40) != 0;
        this.allPointsAddressability = (this.flags & 0x10) != 0;
        this.partitionProtection = (this.flags & 8) != 0;
        this.localCopy = (this.flags & 4) != 0;
        this.modifyPartition = (this.flags & 2) != 0;
    }

    @Override
    public String toString() {
        return super.toString() + String.format("%n  max        : %d", this.maxPartitions) + String.format("%n  storage    : %d", this.totalAvailableStorage) + String.format("%n  flags      : %02X", this.flags) + String.format("%n  vert win   : %s", this.vertWin) + String.format("%n  hor win    : %s", this.horWin) + String.format("%n  APA        : %s", this.allPointsAddressability) + String.format("%n  protect    : %s", this.partitionProtection) + String.format("%n  lcopy      : %s", this.localCopy) + String.format("%n  modpart    : %s", this.modifyPartition);
    }
}

