/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.orders;

import com.bytezone.dm3270.attributes.Attribute;
import com.bytezone.dm3270.attributes.StartFieldAttribute;
import com.bytezone.dm3270.display.DisplayScreen;
import com.bytezone.dm3270.display.Pen;
import com.bytezone.dm3270.orders.Order;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class StartFieldExtendedOrder
extends Order {
    private StartFieldAttribute startFieldAttribute;
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private int location = -1;

    public StartFieldExtendedOrder(byte[] buffer, int offset) {
        assert (buffer[offset] == 41);
        int totalAttributePairs = buffer[offset + 1] & 0xFF;
        this.buffer = new byte[totalAttributePairs * 2 + 2];
        this.buffer[0] = buffer[offset];
        this.buffer[1] = buffer[offset + 1];
        int bptr = 2;
        int ptr = offset + 2;
        while (totalAttributePairs-- > 0) {
            Optional<Attribute> opt = Attribute.getAttribute(buffer[ptr], buffer[ptr + 1]);
            this.buffer[bptr++] = buffer[ptr++];
            this.buffer[bptr++] = buffer[ptr++];
            if (!opt.isPresent()) continue;
            Attribute attribute = opt.get();
            if (attribute.getAttributeType() == Attribute.AttributeType.START_FIELD) {
                this.startFieldAttribute = (StartFieldAttribute)attribute;
                continue;
            }
            this.attributes.add(attribute);
        }
        if (this.startFieldAttribute != null) {
            this.startFieldAttribute.setExtended();
        }
    }

    @Override
    public void process(DisplayScreen screen) {
        Pen pen = screen.getPen();
        this.location = pen.getPosition();
        if (this.startFieldAttribute != null) {
            pen.startField(this.startFieldAttribute);
        } else {
            pen.startField(new StartFieldAttribute(0));
        }
        for (Attribute attribute : this.attributes) {
            pen.addAttribute(attribute);
        }
        pen.moveRight();
    }

    public String toString() {
        String locationText;
        StringBuilder text = new StringBuilder();
        String string = locationText = this.location >= 0 ? String.format("(%04d)", this.location) : "";
        if (this.startFieldAttribute != null) {
            text.append(String.format("SFE : %s %s", this.startFieldAttribute, locationText));
        }
        for (Attribute attr : this.attributes) {
            text.append(String.format("\n      %-34s", attr));
        }
        return text.toString();
    }
}

