/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.orders;

import com.bytezone.dm3270.display.DisplayScreen;
import com.bytezone.dm3270.display.Pen;
import com.bytezone.dm3270.orders.BufferAddress;
import com.bytezone.dm3270.orders.BufferAddressSource;
import com.bytezone.dm3270.orders.Order;

public class SetBufferAddressOrder
extends Order
implements BufferAddressSource {
    private final BufferAddress bufferAddress;

    public SetBufferAddressOrder(byte[] buffer, int offset) {
        assert (buffer[offset] == 17);
        this.bufferAddress = new BufferAddress(buffer[offset + 1], buffer[offset + 2]);
        this.buffer = new byte[3];
        System.arraycopy(buffer, offset, this.buffer, 0, 3);
    }

    @Override
    public BufferAddress getBufferAddress() {
        return this.bufferAddress;
    }

    @Override
    public void process(DisplayScreen screen) {
        Pen pen = screen.getPen();
        pen.moveTo(this.bufferAddress.getLocation());
    }

    public String toString() {
        return String.format("SBA : %s", this.bufferAddress);
    }
}

