/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.orders;

import com.bytezone.dm3270.display.DisplayScreen;
import com.bytezone.dm3270.display.Pen;
import com.bytezone.dm3270.orders.Order;

public class GraphicsEscapeOrder
extends Order {
    private final byte code;

    public GraphicsEscapeOrder(byte[] buffer, int offset) {
        assert (buffer[offset] == 8);
        this.code = buffer[offset + 1];
        this.buffer = new byte[2];
        this.buffer[0] = buffer[offset];
        this.buffer[1] = buffer[offset + 1];
    }

    @Override
    public void process(DisplayScreen screen) {
        Pen pen = screen.getPen();
        int max = this.duplicates;
        while (max-- >= 0) {
            pen.writeGraphics(this.code);
        }
    }

    @Override
    public boolean matchesPreviousOrder(Order order) {
        return order instanceof GraphicsEscapeOrder && this.code == ((GraphicsEscapeOrder)order).code;
    }

    public String toString() {
        String duplicateText = this.duplicates == 0 ? "" : "x " + (this.duplicates + 1);
        return String.format("GE  : %02X %s", this.code, duplicateText);
    }
}

