/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.orders;

import com.bytezone.dm3270.display.DisplayScreen;
import com.bytezone.dm3270.display.Pen;
import com.bytezone.dm3270.orders.Order;

public class FormatControlOrder
extends Order {
    private static byte[] orderValues = new byte[]{0, 63, 28, 30, 12, 13, 21, 25, -1};
    private static String[] orderNames = new String[]{"Null", "Substitute", "Duplicate", "Field Mark", "Form Feed", "Return", "Newline", "EOM", "8 ones"};

    public FormatControlOrder(byte[] buffer, int offset) {
        this.buffer = new byte[1];
        this.buffer[0] = buffer[offset];
    }

    @Override
    public void process(DisplayScreen screen) {
        Pen pen = screen.getPen();
        int max = this.duplicates;
        while (max-- >= 0) {
            pen.write((byte)64);
        }
    }

    @Override
    public boolean matchesPreviousOrder(Order order) {
        return order instanceof FormatControlOrder && this.buffer[0] == ((FormatControlOrder)order).buffer[0];
    }

    public String toString() {
        byte value = this.buffer[0];
        String text = "????";
        for (int i = 0; i < orderValues.length; ++i) {
            if (value != orderValues[i]) continue;
            text = orderNames[i];
            break;
        }
        String duplicateText = this.duplicates == 0 ? "" : "x " + (this.duplicates + 1);
        return String.format("FCO : %-12s : %02X %s", text, this.buffer[0], duplicateText);
    }
}

