/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.orders;

public class BufferAddress {
    public static final byte[] ADDRESS = new byte[64];
    private static int columns = 80;
    private int location;
    private final byte b1;
    private final byte b2;

    public BufferAddress(byte b1, byte b2) {
        this.b1 = b1;
        this.b2 = b2;
        int flag = b1 & 0xC0;
        if (flag == 0) {
            this.location = (b1 & 0x3F) << 8;
            this.location |= b2 & 0xFF;
        } else {
            this.location = (b1 & 0x3F) << 6;
            this.location |= b2 & 0x3F;
        }
    }

    public BufferAddress(int location) {
        this.location = location;
        this.b1 = ADDRESS[location >> 6];
        this.b2 = ADDRESS[location & 0x3F];
    }

    public static void setScreenWidth(int width) {
        columns = width;
    }

    public int getLocation() {
        return this.location;
    }

    public int packAddress(byte[] buffer, int offset) {
        buffer[offset++] = ADDRESS[this.location >> 6];
        buffer[offset++] = ADDRESS[this.location & 0x3F];
        return offset;
    }

    public String toString() {
        return String.format("%04d %03d/%03d : %02X %02X", this.location, this.location / columns, this.location % columns, this.b1, this.b2);
    }

    static {
        int value = 64;
        int ptr = 0;
        for (int i = 0; i < 4; ++i) {
            int j;
            BufferAddress.ADDRESS[ptr++] = (byte)value++;
            for (j = 0; j < 9; ++j) {
                BufferAddress.ADDRESS[ptr++] = (byte)(value++ | 0x80);
            }
            for (j = 0; j < 6; ++j) {
                BufferAddress.ADDRESS[ptr++] = (byte)value++;
            }
        }
        ADDRESS[33] = (byte)(ADDRESS[33] & 0x7F);
        ADDRESS[48] = (byte)(ADDRESS[48] | 0xFFFFFF80);
    }
}

