/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.extended;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.orders.InsertCursorOrder;
import com.bytezone.dm3270.orders.Order;
import com.bytezone.dm3270.orders.TextOrder;
import java.util.ArrayList;
import java.util.List;

public class SscpLuDataCommand
extends Command {
    private final List<Order> orders = new ArrayList<Order>();

    public SscpLuDataCommand(byte[] buffer, int offset, int length, Charset charset) {
        super(buffer, offset, length);
        Order order;
        Order previousOrder = null;
        int max = offset + length;
        for (int ptr = offset; ptr < max; ptr += order.size()) {
            order = Order.getOrder(buffer, ptr, max, charset);
            if (order.matchesPreviousOrder(previousOrder)) {
                previousOrder.incrementDuplicates();
                continue;
            }
            this.orders.add(order);
            previousOrder = order;
        }
        byte[] insertCursorBuffer = new byte[]{19};
        this.orders.add(new InsertCursorOrder(insertCursorBuffer, 0));
    }

    @Override
    public void process(Screen screen) {
        screen.setCurrentScreen(Screen.ScreenOption.DEFAULT);
        screen.lockKeyboard("Erase Write");
        screen.clearScreen(Screen.ScreenOption.DEFAULT);
        screen.setSscpLuData();
        if (this.orders.size() > 0) {
            for (Order order : this.orders) {
                order.process(screen);
            }
            screen.buildFields();
            screen.resetInsertMode();
            screen.restoreKeyboard();
            screen.draw();
        }
    }

    @Override
    public String getName() {
        return "SSCP_LU_DATA";
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(this.getName());
        if (this.orders.size() > 0 && this.orders.get(0) instanceof TextOrder) {
            text.append(String.format("%40s", ""));
        }
        for (Order order : this.orders) {
            String fmt = order.isText() ? "%s" : "%n%-40s";
            text.append(String.format(fmt, order));
        }
        return text.toString();
    }
}

