/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.extended;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.buffers.AbstractReplyBuffer;
import com.bytezone.dm3270.buffers.Buffer;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.extended.ResponseCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandHeader
extends AbstractReplyBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(CommandHeader.class);
    private static DataType[] dataTypes = new DataType[]{DataType.TN3270_DATA, DataType.SCS_DATA, DataType.RESPONSE, DataType.BIND_IMAGE, DataType.UNBIND, DataType.NVT_DATA, DataType.REQUEST, DataType.SSCP_LU_DATA, DataType.PRINT_EOJ, DataType.BID};
    private static final byte ERR_COND_CLEARED = 0;
    private static final byte RQ_NO_RESPONSE = 0;
    private static final byte RQ_ERROR_RESPONSE = 1;
    private static final byte RQ_ALWAYS_RESPONSE = 2;
    private static final byte POSITIVE_RESPONSE = 0;
    private static final byte NEGATIVE_RESPONSE = 1;
    private final DataType dataType;
    private final Charset charset;
    private ResponseType responseType;
    private RequestType requestType;
    private final int commandSeq;

    public CommandHeader(byte[] buffer, Charset charset) {
        this(buffer, 0, buffer.length, charset);
        assert (buffer.length == 5);
    }

    public CommandHeader(byte[] buffer, int offset, int length, Charset charset) {
        super(buffer, offset, length);
        this.charset = charset;
        this.dataType = dataTypes[this.data[0]];
        block0 : switch (this.dataType) {
            case TN3270_DATA: 
            case SCS_DATA: 
            case BID: {
                switch (this.data[2]) {
                    case 0: {
                        this.responseType = ResponseType.NO_RESPONSE;
                        break block0;
                    }
                    case 1: {
                        this.responseType = ResponseType.ERROR_RESPONSE;
                        break block0;
                    }
                    case 2: {
                        this.responseType = ResponseType.ALWAYS_RESPONSE;
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("Unsupported response type " + this.data[2]);
            }
            case RESPONSE: {
                switch (this.data[2]) {
                    case 0: {
                        this.responseType = ResponseType.POSITIVE_RESPONSE;
                        break block0;
                    }
                    case 1: {
                        this.responseType = ResponseType.NEGATIVE_RESPONSE;
                        break block0;
                    }
                }
                throw new UnsupportedOperationException("Unsupported response type " + this.data[2]);
            }
            case REQUEST: {
                if (this.data[2] == 0) {
                    this.requestType = RequestType.ERR_COND_CLEARED;
                    break;
                }
                LOG.warn("Unknown request data: {}", (Object)String.format("%02X", this.data[2]));
                break;
            }
            case BIND_IMAGE: 
            case UNBIND: 
            case SSCP_LU_DATA: 
            case PRINT_EOJ: 
            case NVT_DATA: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type " + (Object)((Object)this.dataType));
            }
        }
        this.commandSeq = Buffer.unsignedShort(this.data, 3);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public void process(Screen screen) {
        if (this.responseType == ResponseType.ALWAYS_RESPONSE) {
            byte[] header = new byte[5];
            header[0] = 2;
            Buffer.packUnsignedShort(this.commandSeq, header, 3);
            CommandHeader commandHeader = new CommandHeader(header, this.charset);
            byte[] value = new byte[]{0};
            this.setReply(new ResponseCommand(commandHeader, value, 0, value.length, this.charset));
        }
    }

    @Override
    public byte[] getTelnetData() {
        int length = this.data.length + this.countFF(this.data);
        if (length == this.data.length) {
            return this.data;
        }
        byte[] returnBuffer = new byte[length];
        this.copyAndExpand(this.data, returnBuffer);
        return returnBuffer;
    }

    public String toString() {
        String requestText = this.requestType == null ? "" : this.requestType.toString();
        String responseText = this.responseType == null ? "" : this.responseType.toString();
        return String.format("HDR: %04d, %-12s, %s, %s", new Object[]{this.commandSeq, this.dataType, requestText, responseText});
    }

    private static enum ResponseType {
        NO_RESPONSE,
        ERROR_RESPONSE,
        ALWAYS_RESPONSE,
        POSITIVE_RESPONSE,
        NEGATIVE_RESPONSE;

    }

    private static enum RequestType {
        ERR_COND_CLEARED;

    }

    public static enum DataType {
        TN3270_DATA,
        SCS_DATA,
        RESPONSE,
        BIND_IMAGE,
        UNBIND,
        NVT_DATA,
        REQUEST,
        SSCP_LU_DATA,
        PRINT_EOJ,
        BID;

    }
}

