/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.extended;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.extended.AbstractExtendedCommand;
import com.bytezone.dm3270.extended.CommandHeader;
import com.bytezone.dm3270.extended.LogicalUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindCommand
extends AbstractExtendedCommand {
    private static final Logger LOG = LoggerFactory.getLogger(BindCommand.class);
    private static final String[] PRESENTATION_TEXT = new String[]{"Undefined", "12 x 40", "24 x 80", "default 24 x 80, alternate in Query Reply", "fixed size as defined by default values", "both default and alternate as specifed"};
    private static final String[] COMPRESSION_TYPES = new String[]{"No compression", "Compression bid", "Reserved", "Compression required"};
    private final Charset charset;
    private final int format;
    private final int type;
    private final int psProfile;
    private final int fmProfile;
    private final int tsProfile;
    private final LogicalUnit primaryLuProtocols;
    private final LogicalUnit secondaryLuProtocols;
    private final int wholeBIUs;
    private final int fmHeaderUsage;
    private final int bracketsUsage;
    private final int bracketsTermination;
    private final int altCodeSet;
    private final int seqAvailability;
    private final int bisSent;
    private final int bindQueuingIndicator;
    private final int privateOptions;
    private final int sessionOptions;
    private final int sessionOptionsLength;
    private final int nsOffset;
    private final int userDataOffset;
    private byte flags;
    private boolean querySupported;
    private int primaryRows;
    private int primaryColumns;
    private int alternateRows;
    private int alternateColumns;
    private int presentationSpace;
    private int compression;
    private String compressionText;
    private int primaryLuNameLength;
    private String primaryLuName;
    private int userDataLength;
    private int extraBytes;

    public BindCommand(CommandHeader commandHeader, byte[] buffer, int offset, int length, Charset charset) {
        super(commandHeader, buffer, offset, length);
        this.charset = charset;
        assert (this.data[0] == 49);
        LOG.debug(charset.toHex(this.data, 0, this.data.length));
        this.format = (this.data[1] & 0xF0) >> 4;
        this.type = this.data[1] & 0xF;
        this.fmProfile = this.data[2] & 0xFF;
        this.tsProfile = this.data[3] & 0xFF;
        this.psProfile = this.data[14] & 0xFF;
        if (this.fmProfile != 3 || this.tsProfile != 3 || this.psProfile != 2) {
            LOG.debug(String.format("FM:%02X, TS:%02X, PS:%02X", this.fmProfile, this.tsProfile, this.psProfile));
        }
        this.primaryLuProtocols = new LogicalUnit(this.data[4]);
        this.secondaryLuProtocols = new LogicalUnit(this.data[5]);
        this.wholeBIUs = (this.data[6] & 0x80) >> 7;
        this.fmHeaderUsage = (this.data[6] & 0x40) >> 6;
        this.bracketsUsage = (this.data[6] & 0x20) >> 5;
        this.bracketsTermination = (this.data[6] & 0x10) >> 4;
        this.altCodeSet = (this.data[6] & 8) >> 3;
        this.seqAvailability = (this.data[6] & 4) >> 2;
        this.bisSent = (this.data[6] & 2) >> 1;
        this.bindQueuingIndicator = this.data[6] & 1;
        if (this.psProfile == 2) {
            this.flags = this.data[15];
            this.querySupported = (this.flags & 0x80) == 128;
            this.primaryRows = this.data[20] & 0xFF;
            this.primaryColumns = this.data[21] & 0xFF;
            this.alternateRows = this.data[22] & 0xFF;
            this.alternateColumns = this.data[23] & 0xFF;
            this.presentationSpace = this.data[24] & 0xFF;
            this.compression = this.data[25] & 0xFF;
            this.compressionText = COMPRESSION_TYPES[this.data[25] & 3];
            byte cryptographicControl = this.data[26];
            this.privateOptions = (this.data[26] & 0xC0) >> 6;
            this.sessionOptions = (this.data[26] & 0x30) >> 4;
            this.sessionOptionsLength = this.data[26] & 0xF;
            this.nsOffset = cryptographicControl == 0 ? 0 : 8;
            this.primaryLuNameLength = this.data[27 + this.nsOffset] & 0xFF;
            this.primaryLuName = charset.getString(this.data, 28 + this.nsOffset, this.primaryLuNameLength);
            this.userDataOffset = 28 + this.nsOffset + this.primaryLuNameLength;
            this.userDataLength = this.data[this.userDataOffset] & 0xFF;
            this.extraBytes = this.data.length - this.userDataOffset - this.userDataLength - 1;
            LOG.debug("Data:{}, ns:{}, pLU:{}, user:{}, extra:{}", new Object[]{this.data.length, this.nsOffset, this.primaryLuNameLength, this.userDataLength, this.extraBytes});
            if (this.extraBytes > 0) {
                int len;
                for (int ptr = this.userDataOffset + this.userDataLength + 1; ptr < this.data.length; ptr += len + 1) {
                    len = this.data[ptr] & 0xFF;
                    String userData = charset.getString(this.sanitise(this.data, ptr + 1, len));
                    LOG.debug("ptr:{}, len:{}, [{}]", new Object[]{ptr, len, userData});
                }
            }
        } else {
            LOG.debug("profile: {}", (Object)this.psProfile);
            this.privateOptions = 0;
            this.sessionOptions = 0;
            this.sessionOptionsLength = 0;
            this.nsOffset = 0;
            this.userDataOffset = 0;
        }
    }

    private byte[] sanitise(byte[] buffer, int offset, int length) {
        if (offset + length > buffer.length) {
            length = buffer.length - offset - 1;
        }
        byte[] cleanBuffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            int b;
            cleanBuffer[i] = (byte)((b = buffer[offset++] & 0xFF) < 64 ? 64 : (byte)b);
        }
        return cleanBuffer;
    }

    @Override
    public void process(Screen screen) {
    }

    @Override
    public String getName() {
        return "Bind";
    }

    public String toString() {
        StringBuilder text = new StringBuilder("BND:\n");
        int offset = this.presentationSpace <= 3 ? 0 : 122;
        String presText = PRESENTATION_TEXT[this.presentationSpace - offset];
        text.append(String.format("Format ............... %02X  %s%n", this.format, "must be zero"));
        text.append(String.format("Type ................. %02X  %s%n", this.type, (this.type == 1 ? "non-" : "") + "negotiable"));
        text.append("\n");
        text.append(String.format("FM profile ........... %02X%n", this.fmProfile));
        text.append(String.format("TS profile ........... %02X%n", this.tsProfile));
        text.append(String.format("PS profile ........... %02X%n", this.psProfile));
        String[] plu = this.primaryLuProtocols.toString().split("\n");
        String[] slu = this.secondaryLuProtocols.toString().split("\n");
        text.append("\n---- Primary LU ---------           ---- Secondary LU -------\n");
        for (int i = 0; i < plu.length; ++i) {
            text.append(String.format("%-35s %-35s%n", plu[i], slu[i]));
        }
        text.append("\n---- Common LU ----------\n");
        text.append(String.format("Whole BIUs ........... %02X%n", this.wholeBIUs));
        text.append(String.format("FM header usage ...... %02X%n", this.fmHeaderUsage));
        text.append(String.format("Brackets usage ....... %02X%n", this.bracketsUsage));
        text.append(String.format("Brackets termination . %02X%n", this.bracketsTermination));
        text.append(String.format("Alt code set ......... %02X%n", this.altCodeSet));
        text.append(String.format("Set availability ..... %02X%n", this.seqAvailability));
        text.append(String.format("BIS sent ............. %02X%n", this.bisSent));
        text.append(String.format("Bind queuing ind ..... %02X%n", this.bindQueuingIndicator));
        text.append("\n---- Cryptography -------\n");
        text.append(String.format("Private options ...... %02X%n", this.privateOptions));
        text.append(String.format("Session options ...... %02X%n", this.sessionOptions));
        text.append(String.format("Session options len .. %02X%n", this.sessionOptionsLength));
        text.append(String.format("NS offset ............ %02X%n", this.nsOffset));
        text.append("\n--- Presentation Space --\n");
        text.append(String.format("Query supported ...... %02X  %s%n", this.flags, this.querySupported));
        text.append(String.format("Presentation space ... %02X  %s%n", this.presentationSpace, presText));
        text.append(String.format("Default rows ......... %02X  %3d%n", this.primaryRows, this.primaryRows));
        text.append(String.format("Default columns ...... %02X  %3d%n", this.primaryColumns, this.primaryColumns));
        text.append(String.format("Alternate Rows ....... %02X  %3d%n", this.alternateRows, this.alternateRows));
        text.append(String.format("Alternate Columns .... %02X  %3d%n", this.alternateColumns, this.alternateColumns));
        text.append("\n");
        text.append(String.format("Compression .......... %02X  %s%n", this.compression, this.compressionText));
        text.append("\n");
        text.append(String.format("Primary LU name len .. %02X%n", this.primaryLuNameLength));
        text.append(String.format("Primary LU name ...... %s%n", this.primaryLuName));
        text.append(String.format("User data offset ..... %02X%n", this.userDataOffset));
        text.append(String.format("User data length ..... %02X%n", this.userDataLength));
        text.append("\n");
        text.append(String.format("Extra bytes .......... %02X%n", this.extraBytes));
        if (this.extraBytes > 0) {
            text.append(this.charset.toHex(this.data, this.userDataOffset + this.userDataLength + 1, this.extraBytes));
        }
        return text.toString();
    }
}

