/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.extended;

import com.bytezone.dm3270.buffers.AbstractReplyBuffer;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.extended.CommandHeader;

public abstract class AbstractExtendedCommand
extends AbstractReplyBuffer {
    protected final CommandHeader commandHeader;

    public AbstractExtendedCommand(CommandHeader commandHeader) {
        this.commandHeader = commandHeader;
    }

    public AbstractExtendedCommand(CommandHeader commandHeader, byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
        this.commandHeader = commandHeader;
    }

    @Override
    public byte[] getData() {
        byte[] buffer = new byte[this.data.length + 5];
        System.arraycopy(this.commandHeader.getData(), 0, buffer, 0, 5);
        System.arraycopy(this.data, 0, buffer, 5, this.data.length);
        return buffer;
    }

    @Override
    public int size() {
        return this.data.length + 5;
    }

    @Override
    public byte[] getTelnetData() {
        byte[] data = this.getData();
        int length = data.length + this.countFF(data) + 2;
        byte[] buffer = new byte[length];
        this.copyAndExpand(data, buffer);
        buffer[--length] = -17;
        buffer[--length] = -1;
        return buffer;
    }

    public abstract String getName();

    @Override
    public void process(Screen screen) {
        this.commandHeader.process(screen);
    }
}

