/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.display;

import com.bytezone.dm3270.attributes.ColorAttribute;
import java.awt.Color;

public class ScreenContext {
    public static final ScreenContext DEFAULT_CONTEXT = new ScreenContext(ColorAttribute.COLORS[0], ColorAttribute.COLORS[8], 0, false, false);
    public final Color foregroundColor;
    public final Color backgroundColor;
    public final byte highlight;
    public final boolean highIntensity;
    public final boolean isGraphic;

    public ScreenContext(Color foregroundColor, Color backgroundColor, byte highlight, boolean highIntensity, boolean isGraphic) {
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.highlight = highlight;
        this.highIntensity = highIntensity;
        this.isGraphic = isGraphic;
    }

    public ScreenContext withBackgroundColor(Color color) {
        return new ScreenContext(this.foregroundColor, color, this.highlight, this.highIntensity, this.isGraphic);
    }

    public ScreenContext withHighlight(byte highlight) {
        return new ScreenContext(this.foregroundColor, this.backgroundColor, highlight, this.highIntensity, this.isGraphic);
    }

    public ScreenContext withForeground(Color color) {
        return new ScreenContext(color, this.backgroundColor, this.highlight, this.highIntensity, this.isGraphic);
    }

    public ScreenContext withGraphic(boolean isGraphic) {
        return new ScreenContext(this.foregroundColor, this.backgroundColor, this.highlight, this.highIntensity, isGraphic);
    }

    public String toString() {
        return String.format("[Fg:%-10s Bg:%-10s In:%s  Hl:%02X]", ColorAttribute.getName(this.foregroundColor), ColorAttribute.getName(this.backgroundColor), Character.valueOf(this.highIntensity ? (char)'x' : ' '), this.highlight);
    }

    public boolean isGraphic() {
        return this.isGraphic;
    }
}

