/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.display;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.attributes.Attribute;
import com.bytezone.dm3270.attributes.StartFieldAttribute;
import com.bytezone.dm3270.display.Pen;
import com.bytezone.dm3270.display.ScreenContext;
import com.bytezone.dm3270.display.ScreenDimensions;
import com.bytezone.dm3270.display.ScreenPosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PenType1
implements Pen {
    private static final Logger LOG = LoggerFactory.getLogger(PenType1.class);
    private final ScreenPosition[] screenPositions;
    private int currentPosition;
    private boolean formattedScreen;
    private ScreenDimensions screenDimensions;
    private final List<Attribute> pendingAttributes = new ArrayList<Attribute>();

    PenType1(ScreenPosition[] screenPositions, ScreenDimensions screenDimensions, Charset charset) {
        this.screenPositions = screenPositions;
        this.screenDimensions = screenDimensions;
        for (int i = 0; i < screenPositions.length; ++i) {
            screenPositions[i] = new ScreenPosition(i, ScreenContext.DEFAULT_CONTEXT, charset);
        }
    }

    @Override
    public void clearScreen() {
        this.currentPosition = 0;
        for (ScreenPosition screenPosition : this.screenPositions) {
            screenPosition.reset();
        }
        this.formattedScreen = false;
    }

    @Override
    public void startField(StartFieldAttribute startFieldAttribute) {
        this.formattedScreen = true;
        ScreenPosition screenPosition = this.screenPositions[this.currentPosition];
        screenPosition.reset();
        screenPosition.setStartField(startFieldAttribute);
        if (this.pendingAttributes.size() > 0) {
            this.pendingAttributes.clear();
        }
    }

    @Override
    public void addAttribute(Attribute attribute) {
        this.pendingAttributes.add(attribute);
    }

    @Override
    public int getPosition() {
        return this.currentPosition;
    }

    @Override
    public void writeGraphics(byte b) {
        ScreenPosition screenPosition = this.screenPositions[this.currentPosition];
        screenPosition.reset();
        screenPosition.setAplGraphicChar(b);
        screenPosition.addAttribute(new com.bytezone.dm3270.attributes.Charset(-15));
        this.moveRight();
    }

    @Override
    public void write(byte b) {
        ScreenPosition screenPosition = this.screenPositions[this.currentPosition];
        screenPosition.reset();
        screenPosition.setChar(b);
        this.moveRight();
    }

    private void applyAttributes(ScreenPosition screenPosition) {
        for (Attribute attribute : this.pendingAttributes) {
            screenPosition.addAttribute(attribute);
        }
        this.pendingAttributes.clear();
    }

    @Override
    public void moveRight() {
        if (this.pendingAttributes.size() > 0) {
            this.applyAttributes(this.screenPositions[this.currentPosition]);
        }
        this.currentPosition = this.validate(this.currentPosition + 1);
    }

    @Override
    public void moveToNextLine() {
        if (this.pendingAttributes.size() > 0) {
            this.applyAttributes(this.screenPositions[this.currentPosition]);
        }
        int currentRow = this.currentPosition / this.screenDimensions.columns;
        this.currentPosition = this.validate((currentRow + 1) * this.screenDimensions.columns);
    }

    @Override
    public void eraseEOF() {
        ScreenPosition screenPosition;
        if (!this.formattedScreen) {
            LOG.debug("No fields to erase");
            return;
        }
        while (!(screenPosition = this.screenPositions[this.currentPosition]).isStartField()) {
            screenPosition.setChar((byte)0);
            this.moveRight();
        }
    }

    @Override
    public void tab() {
        block2: {
            ScreenPosition screenPosition = this.screenPositions[this.currentPosition];
            if (screenPosition.isStartField() && !screenPosition.getStartFieldAttribute().isProtected()) {
                this.currentPosition = this.validate(this.currentPosition + 1);
                return;
            }
            int next = this.currentPosition;
            do {
                if ((next = this.findNextStartPosition(next)) >= this.currentPosition) continue;
                this.currentPosition = 0;
                break block2;
            } while ((screenPosition = this.screenPositions[next]).getStartFieldAttribute().isProtected());
            this.currentPosition = this.validate(next + 1);
        }
    }

    @Override
    public void moveTo(int position) {
        if (this.pendingAttributes.size() > 0) {
            if (LOG.isDebugEnabled()) {
                ArrayList<String> attrs = new ArrayList<String>();
                for (Attribute attribute : this.pendingAttributes) {
                    attrs.add(attribute.toString());
                }
                LOG.debug("Unapplied attributes at {}: {}", (Object)this.currentPosition, attrs);
            }
            this.applyAttributes(this.screenPositions[this.currentPosition]);
        }
        this.currentPosition = this.validate(position);
    }

    private int findNextStartPosition(int position) {
        int pos = position;
        do {
            ScreenPosition screenPosition;
            if (!(screenPosition = this.screenPositions[pos = this.validate(pos + 1)]).isStartField()) continue;
            return pos;
        } while (pos != position);
        LOG.debug("No next start field found: {}", (Object)position);
        return -1;
    }

    @Override
    public int validate(int position) {
        while (position < 0) {
            position += this.screenPositions.length;
        }
        while (position >= this.screenPositions.length) {
            position -= this.screenPositions.length;
        }
        return position;
    }

    @Override
    public void setScreenDimensions(ScreenDimensions screenDimensions) {
        this.screenDimensions = screenDimensions;
    }

    @Override
    public Iterable<ScreenPosition> fromCurrentPosition() {
        return () -> new Iterator<ScreenPosition>(){
            private int pos;
            {
                this.pos = PenType1.this.currentPosition;
            }

            @Override
            public boolean hasNext() {
                return PenType1.this.screenPositions.length > this.pos;
            }

            @Override
            public ScreenPosition next() {
                return PenType1.this.screenPositions[this.pos++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove an element of an array.");
            }
        };
    }

    @Override
    public Iterator<ScreenPosition> iterator() {
        return new Iterator<ScreenPosition>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return PenType1.this.screenPositions.length > this.pos;
            }

            @Override
            public ScreenPosition next() {
                return PenType1.this.screenPositions[this.pos++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove an element of an array.");
            }
        };
    }

    public String toString() {
        return String.format("[Pos:%d, columns:%d, formatted:%s]", this.currentPosition, this.screenDimensions.columns, this.formattedScreen);
    }
}

