/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.display;

import com.bytezone.dm3270.display.CursorMoveListener;
import com.bytezone.dm3270.display.Field;
import com.bytezone.dm3270.display.FieldChangeListener;
import com.bytezone.dm3270.display.Screen;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Cursor {
    private final Screen screen;
    private int currentPosition;
    private Field currentField;
    private boolean visible = false;
    private final Set<FieldChangeListener> fieldChangeListeners = ConcurrentHashMap.newKeySet();
    private final Set<CursorMoveListener> cursorMoveListeners = ConcurrentHashMap.newKeySet();

    public Cursor(Screen screen) {
        this.screen = screen;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (visible) {
            this.setCurrentField();
            this.notifyCursorMove(0, this.currentPosition, this.currentField);
        } else {
            this.resetCurrentField();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Field getCurrentField() {
        if (this.currentField == null) {
            this.setCurrentField();
        }
        return this.currentField;
    }

    public int getLocation() {
        return this.currentPosition;
    }

    public void typeChar(byte value) {
        if (this.currentField != null && this.currentField.isUnprotected() && this.currentField.getCursorOffset() > 0) {
            if (this.screen.isInsertMode()) {
                int start = this.currentField.getCursorOffset();
                int end = this.currentField.getDisplayLength();
                byte lastByte = this.currentField.getByteAt(end);
                if (lastByte != 0 && lastByte != 64) {
                    return;
                }
                this.currentField.push(start, end);
            }
            this.screen.getScreenPosition(this.currentPosition).setChar(value);
            this.currentField.setModified(true);
            int newPosition = this.screen.validate(this.currentPosition + 1);
            if (!this.currentField.contains(newPosition)) {
                newPosition = this.currentField.getNextUnprotectedField().getFirstLocation();
            }
            this.moveTo(newPosition);
        }
    }

    public void moveTo(int newPosition) {
        int oldPosition = this.currentPosition;
        this.currentPosition = this.screen.validate(newPosition);
        if (this.currentPosition != oldPosition) {
            this.notifyCursorMove(oldPosition, this.currentPosition, this.currentField);
            if (this.currentField != null && !this.currentField.contains(this.currentPosition)) {
                this.setCurrentField();
            }
        }
    }

    private void resetCurrentField() {
        Field lastField = this.currentField;
        this.currentField = null;
        if (null != lastField) {
            this.notifyFieldChange(lastField, null);
        }
    }

    private void setCurrentField() {
        Field lastField = this.currentField;
        Optional<Field> field = this.screen.getFieldManager().getFieldAt(this.currentPosition);
        if (field.isPresent()) {
            this.currentField = field.get();
            if (this.currentField != lastField) {
                this.notifyFieldChange(lastField, this.currentField);
            }
        }
    }

    private void notifyFieldChange(Field oldField, Field currentField) {
        this.fieldChangeListeners.forEach(l -> l.fieldChanged(oldField, currentField));
    }

    public void addFieldChangeListener(FieldChangeListener listener) {
        this.fieldChangeListeners.add(listener);
    }

    private void notifyCursorMove(int oldLocation, int currentLocation, Field currentField) {
        this.cursorMoveListeners.forEach(l -> l.cursorMoved(oldLocation, currentLocation, currentField));
    }

    public void addCursorMoveListener(CursorMoveListener listener) {
        this.cursorMoveListeners.add(listener);
    }

    public void removeCursorMoveListener(CursorMoveListener listener) {
        this.cursorMoveListeners.remove(listener);
    }
}

