/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.commands;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.buffers.Buffer;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.display.ScreenDimensions;
import com.bytezone.dm3270.replyfield.CharacterSets;
import com.bytezone.dm3270.replyfield.Color;
import com.bytezone.dm3270.replyfield.Highlight;
import com.bytezone.dm3270.replyfield.ImplicitPartition;
import com.bytezone.dm3270.replyfield.QueryReplyField;
import com.bytezone.dm3270.replyfield.ReplyModes;
import com.bytezone.dm3270.replyfield.Summary;
import com.bytezone.dm3270.replyfield.UsableArea;
import com.bytezone.dm3270.streams.TelnetState;
import com.bytezone.dm3270.structuredfields.DefaultStructuredField;
import com.bytezone.dm3270.structuredfields.QueryReplySF;
import com.bytezone.dm3270.structuredfields.StructuredField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadStructuredFieldCommand
extends Command {
    private static final Logger LOG = LoggerFactory.getLogger(ReadStructuredFieldCommand.class);
    private static final String SEPARATOR = "\n-------------------------------------------------------------------------";
    private final List<StructuredField> structuredFields = new ArrayList<StructuredField>();
    private ScreenDimensions screenDimensions;

    public ReadStructuredFieldCommand(TelnetState telnetState, Charset charset) {
        this(ReadStructuredFieldCommand.buildReply(telnetState), charset);
    }

    public ReadStructuredFieldCommand(List<QueryReplyField.ReplyType> queryList, TelnetState telnetState, Charset charset) {
        this(ReadStructuredFieldCommand.buildReply(queryList, telnetState), charset);
    }

    private ReadStructuredFieldCommand(byte[] buffer, Charset charset) {
        this(buffer, 0, buffer.length, charset);
    }

    public ReadStructuredFieldCommand(byte[] buffer, int offset, int length, Charset charset) {
        super(buffer, offset, length);
        int size;
        assert (this.data[0] == -120);
        int max = this.data.length;
        ArrayList<QueryReplyField> replies = new ArrayList<QueryReplyField>();
        block3: for (int ptr = 1; ptr < max; ptr += size) {
            size = Buffer.unsignedShort(this.data, ptr) - 2;
            switch (this.data[ptr += 2]) {
                case -127: {
                    QueryReplySF queryReply = new QueryReplySF(this.data, ptr, size, charset);
                    this.structuredFields.add(queryReply);
                    replies.add(queryReply.getQueryReplyField());
                    continue block3;
                }
                default: {
                    LOG.warn("Unknown Structured Field: {}", (Object)Buffer.toHex(this.data, ptr, 1));
                    this.structuredFields.add(new DefaultStructuredField(this.data, ptr, size, charset));
                }
            }
        }
        if (replies.size() > 0) {
            for (QueryReplyField reply : replies) {
                reply.addReplyFields(replies);
                if (this.screenDimensions != null || !(reply instanceof UsableArea)) continue;
                this.screenDimensions = ((UsableArea)reply).getScreenDimensions();
            }
        }
    }

    private static byte[] buildReply(TelnetState telnetState) {
        return ReadStructuredFieldCommand.buildReplyBytes(ReadStructuredFieldCommand.buildAvailableReplyFields(telnetState));
    }

    private static byte[] buildReply(List<QueryReplyField.ReplyType> queryList, TelnetState telnetState) {
        Map<QueryReplyField.ReplyType, QueryReplyField> replyFields = ReadStructuredFieldCommand.buildAvailableReplyFields(telnetState).stream().collect(Collectors.toMap(QueryReplyField::getReplyType, r -> r));
        return ReadStructuredFieldCommand.buildReplyBytes(queryList.stream().map(replyFields::get).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static List<QueryReplyField> buildAvailableReplyFields(TelnetState telnetState) {
        ScreenDimensions screenDimensions = telnetState.getSecondary();
        return Arrays.asList(new UsableArea(screenDimensions.rows, screenDimensions.columns), new Color(), new Highlight(), new ImplicitPartition(screenDimensions.rows, screenDimensions.columns), new ReplyModes(), new CharacterSets());
    }

    private static byte[] buildReplyBytes(List<QueryReplyField> replyFields) {
        ArrayList<QueryReplyField> replyFieldsWithSummary = new ArrayList<QueryReplyField>();
        replyFieldsWithSummary.add(new Summary(replyFields));
        replyFieldsWithSummary.addAll(replyFields);
        int replyLength = replyFieldsWithSummary.stream().mapToInt(QueryReplyField::replySize).sum() + 1;
        byte[] buffer = new byte[replyLength];
        int ptr = 0;
        buffer[ptr++] = -120;
        for (QueryReplyField reply : replyFieldsWithSummary) {
            ptr = reply.packReply(buffer, ptr);
        }
        assert (ptr == replyLength);
        return buffer;
    }

    @Override
    public void process(Screen screen) {
    }

    @Override
    public String getName() {
        return "Read SF";
    }

    public String toString() {
        StringBuilder text = new StringBuilder(String.format("RSF (%d):", this.structuredFields.size()));
        for (StructuredField sf : this.structuredFields) {
            text.append(SEPARATOR);
            text.append("\n");
            text.append(sf);
        }
        if (this.structuredFields.size() > 0) {
            text.append(SEPARATOR);
        }
        return text.toString();
    }
}

