/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.buffers;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.buffers.Buffer;
import com.bytezone.dm3270.display.Screen;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiBuffer
implements Buffer {
    private static final Logger LOG = LoggerFactory.getLogger(MultiBuffer.class);
    private final Charset charset;
    private List<Buffer> buffers = new ArrayList<Buffer>();

    public MultiBuffer(Charset charset) {
        this.charset = charset;
    }

    public void addBuffer(Buffer buffer) {
        this.buffers.add(buffer);
    }

    @Override
    public byte[] getData() {
        byte[] data = new byte[this.size()];
        int ptr = 0;
        for (Buffer buffer : this.buffers) {
            LOG.debug(this.charset.toHex(buffer.getData()));
            System.arraycopy(buffer.getData(), 0, data, ptr, buffer.size());
            ptr += buffer.size();
        }
        LOG.debug(this.charset.toHex(data));
        return data;
    }

    @Override
    public byte[] getTelnetData() {
        ArrayList<byte[]> telnets = new ArrayList<byte[]>();
        int size = 0;
        for (Buffer buffer : this.buffers) {
            byte[] telnet = buffer.getTelnetData();
            telnets.add(telnet);
            size += telnet.length;
        }
        byte[] returnBuffer = new byte[size];
        int ptr = 0;
        for (byte[] buffer : telnets) {
            System.arraycopy(buffer, 0, returnBuffer, ptr, buffer.length);
            ptr += buffer.length;
        }
        return returnBuffer;
    }

    @Override
    public int size() {
        int size = 0;
        for (Buffer buffer : this.buffers) {
            size += buffer.size();
        }
        return size;
    }

    @Override
    public void process(Screen screen) {
        for (Buffer buffer : this.buffers) {
            buffer.process(screen);
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        for (Buffer buffer : this.buffers) {
            text.append(buffer.toString());
            text.append("\n\n");
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }
}

