/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.buffers;

import com.bytezone.dm3270.display.Screen;

public interface Buffer {
    public static final int HEX_LINE_SIZE = 16;

    public static int unsignedShort(byte[] buffer, int offset) {
        return (buffer[offset] & 0xFF) * 256 + (buffer[offset + 1] & 0xFF);
    }

    public static int packUnsignedShort(int value, byte[] buffer, int offset) {
        buffer[offset++] = (byte)(value >> 8 & 0xFF);
        buffer[offset++] = (byte)(value & 0xFF);
        return offset;
    }

    public static int unsignedLong(byte[] buffer, int offset) {
        return (buffer[offset] & 0xFF) * 0x1000000 + (buffer[offset + 1] & 0xFF) * 65536 + (buffer[offset + 2] & 0xFF) * 256 + (buffer[offset + 3] & 0xFF);
    }

    public static String toHex(byte[] b, int offset, int length) {
        StringBuilder text = new StringBuilder();
        int max = offset + length;
        for (int ptr = offset; ptr < max; ptr += 16) {
            StringBuilder hexLine = new StringBuilder();
            StringBuilder textLine = new StringBuilder();
            for (int linePtr = 0; linePtr < 16 && ptr + linePtr < max; ++linePtr) {
                int val = b[ptr + linePtr] & 0xFF;
                hexLine.append(String.format("%02X ", val));
                if (val < 32 || val >= 240) {
                    textLine.append('.');
                    continue;
                }
                textLine.append(new String(b, ptr + linePtr, 1));
            }
            text.append(String.format("%04X  %-48s %s%n", ptr, hexLine.toString(), textLine.toString()));
        }
        return text.length() > 0 ? text.substring(0, text.length() - 1) : text.toString();
    }

    public byte[] getData();

    public byte[] getTelnetData();

    public int size();

    public void process(Screen var1);
}

