/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.attributes;

import com.bytezone.dm3270.attributes.Attribute;
import com.bytezone.dm3270.attributes.ColorAttribute;
import com.bytezone.dm3270.display.ScreenContext;
import java.awt.Color;

public class StartFieldAttribute
extends Attribute {
    private static final Color WHITE = ColorAttribute.COLORS[0];
    private static final Color BLUE = ColorAttribute.COLORS[1];
    private static final Color RED = ColorAttribute.COLORS[2];
    private static final Color GREEN = ColorAttribute.COLORS[4];
    private static final Color BLACK = ColorAttribute.COLORS[8];
    private final boolean isProtected;
    private final boolean isNumeric;
    private final boolean isModified;
    private boolean isExtended;
    private boolean userModified;
    private final boolean isHidden;
    private final boolean isHighIntensity;
    private final boolean selectorPenDetectable;

    public StartFieldAttribute(byte b) {
        super(Attribute.AttributeType.START_FIELD, (byte)-64, b);
        this.isProtected = (b & 0x20) > 0;
        this.isNumeric = (b & 0x10) > 0;
        this.isModified = (b & 1) > 0;
        int display = (b & 0xC) >> 2;
        this.selectorPenDetectable = display == 1 || display == 2;
        this.isHidden = display == 3;
        this.isHighIntensity = display == 2;
    }

    public void setExtended() {
        this.isExtended = true;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isVisible() {
        return !this.isHidden;
    }

    public boolean isModified() {
        return this.isModified || this.userModified;
    }

    public void setModified(boolean modified) {
        this.userModified = modified;
    }

    @Override
    public ScreenContext process(ScreenContext unused1, ScreenContext unused2) {
        assert (unused1 == null && unused2 == null);
        Color color = this.isHighIntensity ? (this.isProtected ? WHITE : RED) : (this.isProtected ? BLUE : GREEN);
        return new ScreenContext(color, BLACK, 0, this.isHighIntensity, false);
    }

    private String getColorName() {
        return this.isHighIntensity ? (this.isProtected ? "WH" : "RE") : (this.isProtected ? "BL" : "GR");
    }

    public String getAcronym() {
        return (this.isProtected ? "P" : "p") + (this.isNumeric ? "a" : "A") + (this.isHidden ? "v" : "V") + (this.isHighIntensity ? "I" : "i") + (this.selectorPenDetectable ? "D" : "d") + (this.isModified() ? "M" : "m");
    }

    @Override
    public String toString() {
        return String.format("Attribute %s : %02X %s", this.getColorName(), this.attributeValue, this.getAcronym());
    }
}

