/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.application;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Site {
    private static final Logger LOG = LoggerFactory.getLogger(Site.class);
    public final boolean extended;
    private final String url;
    private int port;

    public Site(String url, int port, boolean extended) {
        this.url = url;
        this.port = port;
        this.extended = extended;
    }

    public String getURL() {
        return this.url;
    }

    public int getPort() {
        if (this.port <= 0) {
            LOG.warn("Invalid port value: {}. Fallback to default value {}", (Object)this.port, (Object)23);
            this.port = 23;
        }
        return this.port;
    }

    public boolean getExtended() {
        return this.extended;
    }

    public String toString() {
        return String.format("Site [url=%s, port=%d]", this.getURL(), this.getPort());
    }
}

