/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.application;

import com.bytezone.dm3270.ConnectionListener;
import com.bytezone.dm3270.application.KeyboardStatusChangedEvent;
import com.bytezone.dm3270.application.KeyboardStatusListener;
import com.bytezone.dm3270.application.Site;
import com.bytezone.dm3270.buffers.Buffer;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.display.CursorMoveListener;
import com.bytezone.dm3270.display.Field;
import com.bytezone.dm3270.display.FieldChangeListener;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.extended.CommandHeader;
import com.bytezone.dm3270.extended.TN3270ExtendedCommand;
import com.bytezone.dm3270.streams.TelnetListener;
import com.bytezone.dm3270.streams.TelnetState;
import com.bytezone.dm3270.streams.TerminalServer;
import javax.net.SocketFactory;

public class ConsolePane
implements FieldChangeListener,
CursorMoveListener,
KeyboardStatusListener {
    private final Screen screen;
    private final TelnetState telnetState;
    private final Site server;
    private final SocketFactory socketFactory;
    private TerminalServer terminalServer;
    private Thread terminalServerThread;
    private int connectionTimeoutMillis;
    private ConnectionListener connectionListener;

    public ConsolePane(Screen screen, Site server, SocketFactory socketFactory) {
        this.screen = screen;
        this.telnetState = screen.getTelnetState();
        this.server = server;
        this.socketFactory = socketFactory;
        screen.setConsolePane(this);
        screen.getScreenCursor().addFieldChangeListener(this);
        screen.getScreenCursor().addCursorMoveListener(this);
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public void sendAID(byte aid, String name) {
        if (this.screen.isInsertMode()) {
            this.screen.toggleInsertMode();
        }
        this.screen.lockKeyboard(name);
        this.screen.setAID(aid);
        Command command = this.screen.readModifiedFields();
        this.sendAID(command);
    }

    private void sendAID(Command command) {
        assert (this.telnetState != null);
        if (this.telnetState.does3270Extended()) {
            byte[] buffer = new byte[5];
            if (this.screen.isSscpLuData()) {
                buffer[0] = 7;
            }
            Buffer.packUnsignedShort(this.telnetState.nextCommandHeaderSeq(), buffer, 3);
            CommandHeader header = new CommandHeader(buffer, this.screen.getCharset());
            TN3270ExtendedCommand extendedCommand = new TN3270ExtendedCommand(header, command, this.telnetState, this.screen.getCharset());
            this.telnetState.write(extendedCommand.getTelnetData());
        } else {
            this.telnetState.write(command.getTelnetData());
        }
    }

    public void connect() {
        if (this.server == null) {
            throw new IllegalArgumentException("Server must not be null");
        }
        this.telnetState.setDo3270Extended(this.server.getExtended());
        this.telnetState.setDoTerminalType(true);
        TelnetListener telnetListener = new TelnetListener(this.screen, this.telnetState);
        this.terminalServer = new TerminalServer(this.server.getURL(), this.server.getPort(), this.socketFactory, telnetListener);
        this.terminalServer.setConnectionTimeoutMillis(this.connectionTimeoutMillis);
        this.terminalServer.setConnectionListener(this.connectionListener);
        this.telnetState.setTerminalServer(this.terminalServer);
        this.terminalServerThread = new Thread(this.terminalServer);
        this.terminalServerThread.start();
    }

    public void disconnect() throws InterruptedException {
        this.telnetState.close();
        if (this.terminalServer != null) {
            this.terminalServer.close();
        }
        if (this.terminalServerThread != null) {
            this.terminalServerThread.interrupt();
            this.terminalServerThread.join();
        }
    }

    @Override
    public void fieldChanged(Field oldField, Field newField) {
    }

    @Override
    public void cursorMoved(int oldLocation, int newLocation, Field currentField) {
        this.fieldChanged(currentField, currentField);
    }

    @Override
    public void keyboardStatusChanged(KeyboardStatusChangedEvent evt) {
    }
}

