/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.ConnectionListener;
import com.bytezone.dm3270.ConnectionListenerBroadcast;
import com.bytezone.dm3270.application.ConsolePane;
import com.bytezone.dm3270.application.KeyboardStatusListener;
import com.bytezone.dm3270.application.Site;
import com.bytezone.dm3270.display.Cursor;
import com.bytezone.dm3270.display.CursorMoveListener;
import com.bytezone.dm3270.display.Field;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.display.ScreenChangeListener;
import com.bytezone.dm3270.display.ScreenDimensions;
import com.bytezone.dm3270.display.ScreenPosition;
import com.bytezone.dm3270.streams.TelnetState;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.net.SocketFactory;

public class TerminalClient {
    private final Screen screen;
    private boolean usesExtended3270;
    private ConsolePane consolePane;
    private SocketFactory socketFactory = SocketFactory.getDefault();
    private int connectionTimeoutMillis;
    private final ConnectionListenerBroadcast connectionListenerBroadcast;

    public TerminalClient(int model, ScreenDimensions alternateScreenDimensions) {
        this(model, alternateScreenDimensions, Charset.CP1047);
    }

    public TerminalClient(int model, ScreenDimensions alternateScreenDimensions, Charset charset) {
        charset.load();
        TelnetState telnetState = new TelnetState();
        telnetState.setDoDeviceType(model);
        this.screen = new Screen(new ScreenDimensions(24, 80), alternateScreenDimensions, telnetState, charset);
        this.connectionListenerBroadcast = new ConnectionListenerBroadcast();
    }

    public void setUsesExtended3270(boolean usesExtended3270) {
        this.usesExtended3270 = usesExtended3270;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListenerBroadcast.add(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListenerBroadcast.remove(connectionListener);
    }

    public void connect(String host, int port) {
        this.screen.lockKeyboard("connect");
        this.consolePane = new ConsolePane(this.screen, new Site(host, port, this.usesExtended3270), this.socketFactory);
        this.consolePane.setConnectionTimeoutMillis(this.connectionTimeoutMillis);
        this.consolePane.setConnectionListener(this.connectionListenerBroadcast);
        this.consolePane.connect();
    }

    public void setFieldTextByCoord(int row, int column, String text) {
        int linearPosition = (row - 1) * this.screen.getScreenDimensions().columns + column - 1;
        if (this.screen.getFieldManager().getFields().isEmpty()) {
            this.setPositionText(text, linearPosition);
        } else {
            Field field = this.screen.getFieldManager().getFieldAt(linearPosition).orElseThrow(() -> new IllegalArgumentException("Invalid field position " + row + "," + column));
            this.setFieldText(field, text);
        }
    }

    private void setPositionText(String text, int fieldPosition) {
        this.screen.setPositionText(fieldPosition, text);
        this.setCursorPosition(fieldPosition + this.findFieldNextPosition(text));
    }

    private int findFieldNextPosition(String text) {
        if (text.isEmpty()) {
            return 1;
        }
        int pos = text.length() - 1;
        while (text.charAt(pos) == '\u0000') {
            --pos;
        }
        return pos + 1;
    }

    private void setFieldText(Field field, String text) {
        field.setText(text);
        int nextPosition = this.findFieldNextPosition(text);
        int cursorPosition = field.getDisplayLength() > nextPosition ? field.getFirstLocation() + nextPosition : field.getNextUnprotectedField().getFirstLocation();
        this.setCursorPosition(cursorPosition);
    }

    public void setFieldTextByLabel(String lbl, String text) {
        if (this.screen.getFieldManager().getFields().isEmpty()) {
            String screenText = this.getScreenText();
            if (!screenText.contains(lbl)) {
                throw this.buildInvalidFieldLabelException(lbl);
            }
            int fieldPosition = this.findLastNonBlankPosition() + 2;
            this.setPositionText(text, fieldPosition);
        } else {
            Field field = this.findFieldByLabel(lbl);
            if (field == null) {
                throw this.buildInvalidFieldLabelException(lbl);
            }
            this.setFieldText(field, text);
        }
    }

    private IllegalArgumentException buildInvalidFieldLabelException(String lbl) {
        return new IllegalArgumentException("Invalid label: " + lbl);
    }

    private int findLastNonBlankPosition() {
        int lastNonBlankPosition;
        String screenText = this.getScreenText();
        for (lastNonBlankPosition = screenText.length() - 1; lastNonBlankPosition >= 0 && (screenText.charAt(lastNonBlankPosition) == '\u0000' || screenText.charAt(lastNonBlankPosition) == '\n') || screenText.charAt(lastNonBlankPosition) == ' '; --lastNonBlankPosition) {
        }
        return lastNonBlankPosition;
    }

    private Field findFieldByLabel(String label) {
        Field labelField = this.findLabelField(label);
        return labelField != null ? labelField.getNextUnprotectedField() : null;
    }

    private Field findLabelField(String label) {
        String screenText = this.getScreenText().replace("\n", "");
        int pos = 0;
        Field fallbackLabelField = null;
        while (pos != -1) {
            if ((pos = screenText.indexOf(label, pos)) == -1) continue;
            Field field = this.screen.getFieldManager().getFieldAt(pos).orElse(null);
            if (field != null) {
                if (field.isProtected()) {
                    return field;
                }
                if (fallbackLabelField == null) {
                    fallbackLabelField = field;
                }
                ++pos;
                continue;
            }
            ++pos;
        }
        return fallbackLabelField;
    }

    public void setTabulatedInput(String text, int offset) throws NoSuchFieldException {
        int row = this.getCursorPosition().get().y;
        int column = this.getCursorPosition().get().x;
        int linearPosition = (row - 1) * this.screen.getScreenDimensions().columns + column - 1;
        if (!this.getFields().isEmpty()) {
            Field finalField = this.screen.getFieldManager().getFieldAt(linearPosition).orElse(null);
            if (finalField == null && offset <= 0) {
                throw new NoSuchElementException("No field found at position (" + row + "," + column + ")");
            }
            if (finalField == null) {
                finalField = this.getNextFieldFromPos(linearPosition);
                --offset;
            }
            for (int i = 0; i < offset; ++i) {
                finalField = finalField.getNextUnprotectedField();
            }
            this.setFieldText(finalField, text);
        } else if (offset == 0) {
            this.setPositionText(text, linearPosition);
        } else {
            throw new NoSuchElementException("No fields on screen to skip, " + offset + "tab/s");
        }
    }

    private Field getNextFieldFromPos(int linealPosition) throws NoSuchFieldException {
        int maxLinealPos = this.getScreenDimensions().size;
        for (int i = linealPosition; i <= maxLinealPos; ++i) {
            int index = linealPosition + i <= maxLinealPos ? linealPosition + i : Math.abs(maxLinealPos - linealPosition - i) - 1;
            Field ret = this.screen.getFieldManager().getFieldAt(index).orElse(null);
            if (ret == null) continue;
            return ret.isUnprotected() ? ret : ret.getNextUnprotectedField();
        }
        throw new NoSuchFieldException("Screen is not constituted by fields");
    }

    public void sendAID(byte aid, String name) {
        this.consolePane.sendAID(aid, name);
    }

    public String getScreenText() {
        StringBuilder text = new StringBuilder();
        int pos = 0;
        boolean visible = true;
        Iterator positionsIterator = this.screen.getPen().iterator();
        ScreenDimensions screenDimensions = this.screen.getScreenDimensions();
        int positionsCount = screenDimensions.columns * screenDimensions.rows;
        while (pos < positionsCount && positionsIterator.hasNext()) {
            ScreenPosition sp = (ScreenPosition)positionsIterator.next();
            if (sp.isStartField()) {
                visible = sp.getStartFieldAttribute().isVisible();
            }
            text.append(visible ? (char)sp.getChar() : (char)' ');
            if (++pos % screenDimensions.columns != 0) continue;
            text.append("\n");
        }
        return text.toString();
    }

    public List<Field> getFields() {
        return this.screen.getFieldManager().getFields();
    }

    public void addScreenChangeListener(ScreenChangeListener listener) {
        this.screen.getFieldManager().addScreenChangeListener(listener);
    }

    public void removeScreenChangeListener(ScreenChangeListener listener) {
        this.screen.getFieldManager().removeScreenChangeListener(listener);
    }

    public boolean isKeyboardLocked() {
        return this.screen.isKeyboardLocked();
    }

    public void addKeyboardStatusListener(KeyboardStatusListener listener) {
        this.screen.addKeyboardStatusChangeListener(listener);
    }

    public void removeKeyboardStatusListener(KeyboardStatusListener listener) {
        this.screen.removeKeyboardStatusChangeListener(listener);
    }

    public boolean isAlarmOn() {
        return this.screen.isAlarmOn();
    }

    public boolean resetAlarm() {
        return this.screen.resetAlarm();
    }

    public ScreenDimensions getScreenDimensions() {
        return this.screen.getScreenDimensions();
    }

    public Optional<Point> getCursorPosition() {
        Cursor cursor = this.screen.getScreenCursor();
        int location = cursor.getLocation();
        int columns = this.screen.getScreenDimensions().columns;
        return cursor.isVisible() ? Optional.of(new Point(location % columns + 1, location / columns + 1)) : Optional.empty();
    }

    public void setCursorPosition(int linearPosition) {
        this.screen.getScreenCursor().moveTo(linearPosition);
    }

    public void addCursorMoveListener(CursorMoveListener listener) {
        this.screen.getScreenCursor().addCursorMoveListener(listener);
    }

    public void removeCursorMoveListener(CursorMoveListener listener) {
        this.screen.getScreenCursor().removeCursorMoveListener(listener);
    }

    public void disconnect() throws InterruptedException {
        this.consolePane.disconnect();
    }
}

