/*
 * Decompiled with CFR 0.152.
 */
package com.tomash.androidcontacts.contactgetter.main.contactsGetter;

import android.content.Context;
import com.tomash.androidcontacts.contactgetter.entity.ContactData;
import com.tomash.androidcontacts.contactgetter.interfaces.BaseFilter;
import com.tomash.androidcontacts.contactgetter.main.FieldType;
import com.tomash.androidcontacts.contactgetter.main.Sorting;
import com.tomash.androidcontacts.contactgetter.main.contactsGetter.ContactsGetter;
import com.tomash.androidcontacts.contactgetter.utils.FilterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ContactsGetterBuilder {
    private Context mCtx;
    private Sorting mSortOrder = Sorting.BY_DISPLAY_NAME_ASC;
    private StringBuilder mSelectionBuilder = new StringBuilder();
    private List<String> mParamsList = new ArrayList<String>(2);
    private List<BaseFilter> mFilterList = new ArrayList<BaseFilter>(8);
    private List<FieldType> mEnabledFields = new ArrayList<FieldType>(8);

    public ContactsGetterBuilder(Context ctx) {
        this.mCtx = ctx;
    }

    public ContactsGetterBuilder setSortOrder(Sorting sortOrder) {
        this.mSortOrder = sortOrder;
        return this;
    }

    public ContactsGetterBuilder onlyWithPhones() {
        if (this.mSelectionBuilder.length() != 0) {
            this.mSelectionBuilder.append(" AND ");
        }
        this.mSelectionBuilder.append("has_phone_number").append(" = 1");
        this.addField(FieldType.PHONE_NUMBERS);
        return this;
    }

    public ContactsGetterBuilder onlyWithPhotos() {
        if (this.mSelectionBuilder.length() != 0) {
            this.mSelectionBuilder.append(" AND ");
        }
        this.mSelectionBuilder.append("photo_uri").append(" IS NOT NULL");
        return this;
    }

    public ContactsGetterBuilder withNameLike(String nameLike) {
        if (this.mSelectionBuilder.length() != 0) {
            this.mSelectionBuilder.append(" AND ");
        }
        this.mSelectionBuilder.append("display_name").append(" LIKE ?");
        this.mParamsList.add("%" + nameLike + "%");
        return this;
    }

    public ContactsGetterBuilder withName(String name) {
        if (this.mSelectionBuilder.length() != 0) {
            this.mSelectionBuilder.append(" AND ");
        }
        this.mSelectionBuilder.append("display_name").append(" = ?");
        this.mParamsList.add(name);
        return this;
    }

    public ContactsGetterBuilder withPhoneLike(String number) {
        this.mFilterList.add(FilterUtils.withPhoneLikeFilter(number));
        return this.onlyWithPhones();
    }

    public ContactsGetterBuilder withPhone(String number) {
        this.mFilterList.add(FilterUtils.withPhoneFilter(number));
        return this.onlyWithPhones();
    }

    public ContactsGetterBuilder withEmail(String email) {
        this.addField(FieldType.EMAILS);
        this.mFilterList.add(FilterUtils.withEmailFilter(email));
        return this;
    }

    public ContactsGetterBuilder withEmailLike(String sequence) {
        this.addField(FieldType.EMAILS);
        this.mFilterList.add(FilterUtils.withEmailLikeFilter(sequence));
        return this;
    }

    public ContactsGetterBuilder withAddress(String number) {
        this.addField(FieldType.ADDRESS);
        this.mFilterList.add(FilterUtils.withAddressFilter(number));
        return this;
    }

    public ContactsGetterBuilder withAddressLike(String sequence) {
        this.addField(FieldType.ADDRESS);
        this.mFilterList.add(FilterUtils.withAddressLikeFilter(sequence));
        return this;
    }

    private <T extends ContactData> List<T> applyFilters(List<T> contactList) {
        for (BaseFilter filter : this.mFilterList) {
            Iterator<T> iterator = contactList.iterator();
            while (iterator.hasNext()) {
                ContactData contact = (ContactData)iterator.next();
                if (filter.passedFilter(contact)) continue;
                iterator.remove();
            }
        }
        return contactList;
    }

    public ContactsGetterBuilder applyCustomFilter(BaseFilter filter) {
        this.mFilterList.add(filter);
        return this;
    }

    public ContactsGetterBuilder allFields() {
        this.addField(FieldType.values());
        return this;
    }

    public ContactsGetterBuilder addField(FieldType ... fieldType) {
        this.mEnabledFields.addAll(Arrays.asList(fieldType));
        return this;
    }

    private ContactsGetter initGetter() {
        ContactsGetter getter = this.mSelectionBuilder.length() == 0 ? new ContactsGetter(this.mCtx, this.mEnabledFields, this.mSortOrder.getSorting(), null, null) : new ContactsGetter(this.mCtx, this.mEnabledFields, this.mSortOrder.getSorting(), this.generateSelectionArgs(), this.generateSelection());
        return getter;
    }

    public <T extends ContactData> List<T> buildList(Class<? extends ContactData> T) {
        return this.applyFilters(this.initGetter().setContactDataClass(T).getContacts());
    }

    public List<ContactData> buildList() {
        return this.applyFilters(this.initGetter().getContacts());
    }

    public ContactData getById(int id) {
        if (this.mSelectionBuilder.length() != 0) {
            this.mSelectionBuilder.append(" AND ");
        }
        this.mSelectionBuilder.append("_id").append(" = ?");
        this.mParamsList.add(String.valueOf(id));
        return this.firstOrNull();
    }

    public <T extends ContactData> T getById(int id, Class<T> T) {
        if (this.mSelectionBuilder.length() != 0) {
            this.mSelectionBuilder.append(" AND ");
        }
        this.mSelectionBuilder.append("_id").append(" = ?");
        this.mParamsList.add(String.valueOf(id));
        return this.firstOrNull(T);
    }

    public ContactData firstOrNull() {
        List<ContactData> contacts = this.buildList();
        if (contacts.isEmpty()) {
            return null;
        }
        return contacts.get(0);
    }

    public <T extends ContactData> T firstOrNull(Class<T> T) {
        List<T> contacts = this.buildList(T);
        if (contacts.isEmpty()) {
            return null;
        }
        return (T)((ContactData)contacts.get(0));
    }

    private String generateSelection() {
        return this.mSelectionBuilder.toString();
    }

    private String[] generateSelectionArgs() {
        return this.mParamsList.toArray(new String[this.mParamsList.size()]);
    }
}

