/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.profitsharing;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Map;
import me.chanjar.weixin.common.annotation.Required;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class ProfitSharingReturnQueryRequest
extends BaseWxPayRequest {
    private static final long serialVersionUID = -8838464614726086009L;
    @XStreamAlias(value="order_id")
    private String orderId;
    @XStreamAlias(value="out_order_no")
    private String outOrderNo;
    @Required
    @XStreamAlias(value="out_return_no")
    private String outReturnNo;

    @Override
    protected void checkConstraints() throws WxPayException {
        if (StringUtils.isBlank((CharSequence)this.orderId) && StringUtils.isBlank((CharSequence)this.outOrderNo)) {
            throw new WxPayException("order_id \u548c outOrderNo \u5fc5\u987b\u6709\u4e00\u4e2a\u5b58\u5728");
        }
        this.setSignType("HMAC-SHA256");
    }

    @Override
    protected boolean ignoreSubAppId() {
        return true;
    }

    @Override
    protected void storeMap(Map<String, String> map) {
        map.put("order_id", this.orderId);
        map.put("out_order_no", this.outOrderNo);
        map.put("out_return_no", this.outReturnNo);
    }

    public static ProfitSharingReturnQueryRequestBuilder newBuilder() {
        return new ProfitSharingReturnQueryRequestBuilder();
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getOutOrderNo() {
        return this.outOrderNo;
    }

    public String getOutReturnNo() {
        return this.outReturnNo;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public void setOutOrderNo(String outOrderNo) {
        this.outOrderNo = outOrderNo;
    }

    public void setOutReturnNo(String outReturnNo) {
        this.outReturnNo = outReturnNo;
    }

    @Override
    public String toString() {
        return "ProfitSharingReturnQueryRequest(orderId=" + this.getOrderId() + ", outOrderNo=" + this.getOutOrderNo() + ", outReturnNo=" + this.getOutReturnNo() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfitSharingReturnQueryRequest)) {
            return false;
        }
        ProfitSharingReturnQueryRequest other = (ProfitSharingReturnQueryRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$orderId = this.getOrderId();
        String other$orderId = other.getOrderId();
        if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
            return false;
        }
        String this$outOrderNo = this.getOutOrderNo();
        String other$outOrderNo = other.getOutOrderNo();
        if (this$outOrderNo == null ? other$outOrderNo != null : !this$outOrderNo.equals(other$outOrderNo)) {
            return false;
        }
        String this$outReturnNo = this.getOutReturnNo();
        String other$outReturnNo = other.getOutReturnNo();
        return !(this$outReturnNo == null ? other$outReturnNo != null : !this$outReturnNo.equals(other$outReturnNo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProfitSharingReturnQueryRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $orderId = this.getOrderId();
        result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
        String $outOrderNo = this.getOutOrderNo();
        result = result * 59 + ($outOrderNo == null ? 43 : $outOrderNo.hashCode());
        String $outReturnNo = this.getOutReturnNo();
        result = result * 59 + ($outReturnNo == null ? 43 : $outReturnNo.hashCode());
        return result;
    }

    public ProfitSharingReturnQueryRequest() {
    }

    public ProfitSharingReturnQueryRequest(String orderId, String outOrderNo, String outReturnNo) {
        this.orderId = orderId;
        this.outOrderNo = outOrderNo;
        this.outReturnNo = outReturnNo;
    }

    public static class ProfitSharingReturnQueryRequestBuilder {
        private String orderId;
        private String outOrderNo;
        private String outReturnNo;

        ProfitSharingReturnQueryRequestBuilder() {
        }

        public ProfitSharingReturnQueryRequestBuilder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public ProfitSharingReturnQueryRequestBuilder outOrderNo(String outOrderNo) {
            this.outOrderNo = outOrderNo;
            return this;
        }

        public ProfitSharingReturnQueryRequestBuilder outReturnNo(String outReturnNo) {
            this.outReturnNo = outReturnNo;
            return this;
        }

        public ProfitSharingReturnQueryRequest build() {
            return new ProfitSharingReturnQueryRequest(this.orderId, this.outOrderNo, this.outReturnNo);
        }

        public String toString() {
            return "ProfitSharingReturnQueryRequest.ProfitSharingReturnQueryRequestBuilder(orderId=" + this.orderId + ", outOrderNo=" + this.outOrderNo + ", outReturnNo=" + this.outReturnNo + ")";
        }
    }
}

