/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.v3;

import com.github.binarywang.wxpay.v3.Credentials;
import com.github.binarywang.wxpay.v3.Validator;
import com.github.binarywang.wxpay.v3.WechatPayUploadHttpPost;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.util.EntityUtils;

public class SignatureExec
implements ClientExecChain {
    final ClientExecChain mainExec;
    final Credentials credentials;
    final Validator validator;

    SignatureExec(Credentials credentials, Validator validator, ClientExecChain mainExec) {
        this.credentials = credentials;
        this.validator = validator;
        this.mainExec = mainExec;
    }

    protected HttpEntity newRepeatableEntity(HttpEntity entity) throws IOException {
        byte[] content = EntityUtils.toByteArray((HttpEntity)entity);
        ByteArrayEntity newEntity = new ByteArrayEntity(content);
        newEntity.setContentEncoding(entity.getContentEncoding());
        newEntity.setContentType(entity.getContentType());
        return newEntity;
    }

    protected void convertToRepeatableResponseEntity(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity != null && !entity.isRepeatable()) {
            response.setEntity(this.newRepeatableEntity(entity));
        }
    }

    protected void convertToRepeatableRequestEntity(HttpRequestWrapper request) throws IOException {
        HttpEntity entity;
        if (request instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null) {
            ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new BufferedHttpEntity(entity));
        }
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        if (request.getURI().getHost().endsWith(".mch.weixin.qq.com")) {
            return this.executeWithSignature(route, request, context, execAware);
        }
        return this.mainExec.execute(route, request, context, execAware);
    }

    private CloseableHttpResponse executeWithSignature(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        if (!(request.getOriginal() instanceof WechatPayUploadHttpPost)) {
            this.convertToRepeatableRequestEntity(request);
        }
        request.addHeader("Authorization", this.credentials.getSchema() + " " + this.credentials.getToken(request));
        CloseableHttpResponse response = this.mainExec.execute(route, request, context, execAware);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() >= 200 && statusLine.getStatusCode() < 300) {
            this.convertToRepeatableResponseEntity(response);
            if (!this.validator.validate(response)) {
                throw new HttpException("\u5e94\u7b54\u7684\u5fae\u4fe1\u652f\u4ed8\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
            }
        }
        return response;
    }
}

