/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.entpay.EntPayBankQueryRequest;
import com.github.binarywang.wxpay.bean.entpay.EntPayBankQueryResult;
import com.github.binarywang.wxpay.bean.entpay.EntPayBankRequest;
import com.github.binarywang.wxpay.bean.entpay.EntPayBankResult;
import com.github.binarywang.wxpay.bean.entpay.EntPayQueryRequest;
import com.github.binarywang.wxpay.bean.entpay.EntPayQueryResult;
import com.github.binarywang.wxpay.bean.entpay.EntPayRedpackQueryRequest;
import com.github.binarywang.wxpay.bean.entpay.EntPayRedpackQueryResult;
import com.github.binarywang.wxpay.bean.entpay.EntPayRedpackRequest;
import com.github.binarywang.wxpay.bean.entpay.EntPayRedpackResult;
import com.github.binarywang.wxpay.bean.entpay.EntPayRequest;
import com.github.binarywang.wxpay.bean.entpay.EntPayResult;
import com.github.binarywang.wxpay.bean.entpay.GetPublicKeyResult;
import com.github.binarywang.wxpay.bean.request.WxPayDefaultRequest;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.EntPayService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.util.SignUtils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class EntPayServiceImpl
implements EntPayService {
    private WxPayService payService;

    public EntPayServiceImpl(WxPayService payService) {
        this.payService = payService;
    }

    @Override
    public EntPayResult entPay(EntPayRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/mmpaymkttransfers/promotion/transfers";
        String responseContent = this.payService.post(url, request.toXML(), true);
        EntPayResult result = BaseWxPayResult.fromXML(responseContent, EntPayResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public EntPayQueryResult queryEntPay(String partnerTradeNo) throws WxPayException {
        EntPayQueryRequest request = new EntPayQueryRequest();
        request.setPartnerTradeNo(partnerTradeNo);
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/mmpaymkttransfers/gettransferinfo";
        String responseContent = this.payService.post(url, request.toXML(), true);
        EntPayQueryResult result = BaseWxPayResult.fromXML(responseContent, EntPayQueryResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public EntPayQueryResult queryEntPay(EntPayQueryRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/mmpaymkttransfers/gettransferinfo";
        String responseContent = this.payService.post(url, request.toXML(), true);
        EntPayQueryResult result = BaseWxPayResult.fromXML(responseContent, EntPayQueryResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public String getPublicKey() throws WxPayException {
        WxPayDefaultRequest request = new WxPayDefaultRequest();
        request.setMchId(this.payService.getConfig().getMchId());
        request.setNonceStr(String.valueOf(System.currentTimeMillis()));
        request.checkAndSign(this.payService.getConfig());
        String url = "https://fraud.mch.weixin.qq.com/risk/getpublickey";
        String responseContent = this.payService.post(url, request.toXML(), true);
        GetPublicKeyResult result = BaseWxPayResult.fromXML(responseContent, GetPublicKeyResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result.getPubKey();
    }

    @Override
    public EntPayBankResult payBank(EntPayBankRequest request) throws WxPayException {
        File publicKeyFile = this.buildPublicKeyFile();
        request.setEncBankNo(this.encryptRSA(publicKeyFile, request.getEncBankNo()));
        request.setEncTrueName(this.encryptRSA(publicKeyFile, request.getEncTrueName()));
        publicKeyFile.deleteOnExit();
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/mmpaysptrans/pay_bank";
        String responseContent = this.payService.post(url, request.toXML(), true);
        EntPayBankResult result = BaseWxPayResult.fromXML(responseContent, EntPayBankResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public EntPayBankQueryResult queryPayBank(String partnerTradeNo) throws WxPayException {
        EntPayBankQueryRequest request = new EntPayBankQueryRequest();
        request.setPartnerTradeNo(partnerTradeNo);
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/mmpaysptrans/query_bank";
        String responseContent = this.payService.post(url, request.toXML(), true);
        EntPayBankQueryResult result = BaseWxPayResult.fromXML(responseContent, EntPayBankQueryResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public EntPayBankQueryResult queryPayBank(EntPayBankQueryRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/mmpaysptrans/query_bank";
        String responseContent = this.payService.post(url, request.toXML(), true);
        EntPayBankQueryResult result = BaseWxPayResult.fromXML(responseContent, EntPayBankQueryResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public EntPayRedpackResult sendEnterpriseRedpack(EntPayRedpackRequest request) throws WxPayException {
        request.setNonceStr(String.valueOf(System.currentTimeMillis()));
        request.setWorkWxSign(SignUtils.createEntSign(request.getActName(), request.getMchBillNo(), request.getMchId(), request.getNonceStr(), request.getReOpenid(), request.getTotalAmount(), request.getWxAppId(), this.payService.getConfig().getEntPayKey(), "MD5"));
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/mmpaymkttransfers/sendworkwxredpack";
        String responseContent = this.payService.post(url, request.toXML(), true);
        EntPayRedpackResult result = BaseWxPayResult.fromXML(responseContent, EntPayRedpackResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    @Override
    public EntPayRedpackQueryResult queryEnterpriseRedpack(EntPayRedpackQueryRequest request) throws WxPayException {
        request.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/mmpaymkttransfers/queryworkwxredpack";
        String responseContent = this.payService.post(url, request.toXML(), true);
        EntPayRedpackQueryResult result = BaseWxPayResult.fromXML(responseContent, EntPayRedpackQueryResult.class);
        result.checkResult(this.payService, request.getSignType(), true);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String encryptRSA(File publicKeyFile, String srcString) throws WxPayException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
            try (PEMParser reader = new PEMParser((Reader)new FileReader(publicKeyFile));){
                PublicKey publicKey = new JcaPEMKeyConverter().setProvider("BC").getPublicKey((SubjectPublicKeyInfo)reader.readObject());
                cipher.init(1, publicKey);
                byte[] encrypt = cipher.doFinal(srcString.getBytes(StandardCharsets.UTF_8));
                String string = Base64.encodeBase64String((byte[])encrypt);
                return string;
            }
        }
        catch (Exception e) {
            throw new WxPayException("\u52a0\u5bc6\u51fa\u9519", e);
        }
    }

    private File buildPublicKeyFile() throws WxPayException {
        try {
            String publicKeyStr = this.getPublicKey();
            Path tmpFile = Files.createTempFile("payToBank", ".pem", new FileAttribute[0]);
            Files.write(tmpFile, publicKeyStr.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return tmpFile.toFile();
        }
        catch (Exception e) {
            throw new WxPayException("\u751f\u6210\u52a0\u5bc6\u516c\u94a5\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
    }
}

