/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaAnalysisService;
import cn.binarywang.wx.miniapp.api.WxMaCloudService;
import cn.binarywang.wx.miniapp.api.WxMaCodeService;
import cn.binarywang.wx.miniapp.api.WxMaDeviceSubscribeService;
import cn.binarywang.wx.miniapp.api.WxMaExpressDeliveryReturnService;
import cn.binarywang.wx.miniapp.api.WxMaExpressService;
import cn.binarywang.wx.miniapp.api.WxMaImmediateDeliveryService;
import cn.binarywang.wx.miniapp.api.WxMaInternetService;
import cn.binarywang.wx.miniapp.api.WxMaIntracityService;
import cn.binarywang.wx.miniapp.api.WxMaJsapiService;
import cn.binarywang.wx.miniapp.api.WxMaLinkService;
import cn.binarywang.wx.miniapp.api.WxMaLiveGoodsService;
import cn.binarywang.wx.miniapp.api.WxMaLiveMemberService;
import cn.binarywang.wx.miniapp.api.WxMaLiveService;
import cn.binarywang.wx.miniapp.api.WxMaMarketingService;
import cn.binarywang.wx.miniapp.api.WxMaMediaService;
import cn.binarywang.wx.miniapp.api.WxMaMsgService;
import cn.binarywang.wx.miniapp.api.WxMaOpenApiService;
import cn.binarywang.wx.miniapp.api.WxMaOrderManagementService;
import cn.binarywang.wx.miniapp.api.WxMaOrderShippingService;
import cn.binarywang.wx.miniapp.api.WxMaPluginService;
import cn.binarywang.wx.miniapp.api.WxMaProductOrderService;
import cn.binarywang.wx.miniapp.api.WxMaProductService;
import cn.binarywang.wx.miniapp.api.WxMaPromotionService;
import cn.binarywang.wx.miniapp.api.WxMaQrcodeService;
import cn.binarywang.wx.miniapp.api.WxMaReimburseInvoiceService;
import cn.binarywang.wx.miniapp.api.WxMaRunService;
import cn.binarywang.wx.miniapp.api.WxMaSchemeService;
import cn.binarywang.wx.miniapp.api.WxMaSecurityService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaSettingService;
import cn.binarywang.wx.miniapp.api.WxMaShareService;
import cn.binarywang.wx.miniapp.api.WxMaShopAccountService;
import cn.binarywang.wx.miniapp.api.WxMaShopAfterSaleService;
import cn.binarywang.wx.miniapp.api.WxMaShopAuditService;
import cn.binarywang.wx.miniapp.api.WxMaShopCatService;
import cn.binarywang.wx.miniapp.api.WxMaShopCouponService;
import cn.binarywang.wx.miniapp.api.WxMaShopDeliveryService;
import cn.binarywang.wx.miniapp.api.WxMaShopImgService;
import cn.binarywang.wx.miniapp.api.WxMaShopOrderService;
import cn.binarywang.wx.miniapp.api.WxMaShopPayService;
import cn.binarywang.wx.miniapp.api.WxMaShopRegisterService;
import cn.binarywang.wx.miniapp.api.WxMaShopSharerService;
import cn.binarywang.wx.miniapp.api.WxMaShopSpuService;
import cn.binarywang.wx.miniapp.api.WxMaSubscribeService;
import cn.binarywang.wx.miniapp.api.WxMaUserService;
import cn.binarywang.wx.miniapp.api.WxMaVodService;
import cn.binarywang.wx.miniapp.api.WxMaXPayService;
import cn.binarywang.wx.miniapp.api.impl.WxMaAnalysisServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaCloudServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaCodeServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaDeviceSubscribeServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaExpressDeliveryReturnServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaExpressServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaImgProcServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaImmediateDeliveryServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaInternetServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaIntracityServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaJsapiServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaLinkServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaLiveGoodsServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaLiveMemberServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaLiveServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaMarketingServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaMediaServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaMsgServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaOcrServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaOpenApiServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaOrderManagementServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaOrderShippingServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaPluginServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaProductOrderServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaProductServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaPromotionServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaQrcodeServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaReimburseInvoiceServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaRunServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaSchemeServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaSecurityServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaSettingServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShareServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShopAccountServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShopAfterSaleServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShopAuditServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShopCatServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShopCouponServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShopDeliveryServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShopImgServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShopOrderServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShopPayServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShopRegisterServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShopSharerServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShopSpuServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaSubscribeServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaUserServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaVodServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaXPayServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaApiResponse;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.executor.ApiSignaturePostRequestExecutor;
import cn.binarywang.wx.miniapp.util.WxMaConfigHolder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import me.chanjar.weixin.common.api.WxConsts;
import me.chanjar.weixin.common.bean.CommonUploadParam;
import me.chanjar.weixin.common.bean.ToJson;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.executor.CommonUploadRequestExecutor;
import me.chanjar.weixin.common.service.WxImgProcService;
import me.chanjar.weixin.common.service.WxOcrService;
import me.chanjar.weixin.common.util.DataUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxMaServiceImpl<H, P>
implements WxMaService,
RequestHttp<H, P> {
    private static final Logger log = LoggerFactory.getLogger(BaseWxMaServiceImpl.class);
    protected static final String[] urlPathSupportApiSignature = new String[]{"cgi-bin/clear_quota", "cgi-bin/openapi/quota/get", "cgi-bin/openapi/rid/get", "wxa/getpluginopenpid", "wxa/business/checkencryptedmsg", "wxa/business/getuserencryptkey", "wxa/business/getuserphonenumber", "wxa/getwxacode", "wxa/getwxacodeunlimit", "cgi-bin/wxaapp/createwxaqrcode", "cgi-bin/message/custom/send", "cgi-bin/message/wxopen/updatablemsg/send", "wxaapi/newtmpl/deltemplate", "cgi-bin/message/subscribe/send", "wxaapi/newtmpl/addtemplate", "wxa/msg_sec_check", "wxa/media_check_async", "wxa/getuserriskrank", "datacube/getweanalysisappidweeklyretaininfo", "datacube/getweanalysisappidmonthlyretaininfo", "datacube/getweanalysisappiddailyretaininfo", "datacube/getweanalysisappidmonthlyvisittrend", "datacube/getweanalysisappiddailyvisittrend", "datacube/getweanalysisappidweeklyvisittrend", "datacube/getweanalysisappiddailysummarytrend", "datacube/getweanalysisappidvisitpage", "datacube/getweanalysisappiduserportrait", "wxa/business/performance/boot", "datacube/getweanalysisappidvisitdistribution", "wxa/getwxadevinfo", "wxaapi/log/get_performance", "wxaapi/log/jserr_detail", "wxaapi/log/jserr_list", "wxa/devplugin", "wxa/plugin", "cgi-bin/express/business/account/getall", "cgi-bin/express/business/delivery/getall", "cgi-bin/express/business/printer/getall", "wxa/servicemarket", "cgi-bin/soter/verify_signature"};
    protected static final Gson GSON = new Gson();
    private final WxMaMsgService kefuService = new WxMaMsgServiceImpl(this);
    private final WxMaMediaService materialService = new WxMaMediaServiceImpl(this);
    private final WxMaUserService userService = new WxMaUserServiceImpl(this);
    private final WxMaQrcodeService qrCodeService = new WxMaQrcodeServiceImpl(this);
    private final WxMaSchemeService schemeService = new WxMaSchemeServiceImpl(this);
    private final WxMaAnalysisService analysisService = new WxMaAnalysisServiceImpl(this);
    private final WxMaCodeService codeService = new WxMaCodeServiceImpl(this);
    private final WxMaInternetService internetService = new WxMaInternetServiceImpl(this);
    private final WxMaSettingService settingService = new WxMaSettingServiceImpl(this);
    private final WxMaJsapiService jsapiService = new WxMaJsapiServiceImpl(this);
    private final WxMaShareService shareService = new WxMaShareServiceImpl(this);
    private final WxMaRunService runService = new WxMaRunServiceImpl(this);
    private final WxMaSecurityService securityService = new WxMaSecurityServiceImpl(this);
    private final WxMaPluginService pluginService = new WxMaPluginServiceImpl(this);
    private final WxMaExpressService expressService = new WxMaExpressServiceImpl(this);
    private final WxMaSubscribeService subscribeService = new WxMaSubscribeServiceImpl(this);
    private final WxMaCloudService cloudService = new WxMaCloudServiceImpl(this);
    private final WxMaLiveService liveService = new WxMaLiveServiceImpl(this);
    private final WxMaLiveGoodsService liveGoodsService = new WxMaLiveGoodsServiceImpl(this);
    private final WxMaLiveMemberService liveMemberService = new WxMaLiveMemberServiceImpl(this);
    private final WxOcrService ocrService = new WxMaOcrServiceImpl(this);
    private final WxImgProcService imgProcService = new WxMaImgProcServiceImpl(this);
    private final WxMaShopSpuService shopSpuService = new WxMaShopSpuServiceImpl(this);
    private final WxMaShopOrderService shopOrderService = new WxMaShopOrderServiceImpl(this);
    private final WxMaShopRegisterService shopRegisterService = new WxMaShopRegisterServiceImpl(this);
    private final WxMaShopAccountService shopAccountService = new WxMaShopAccountServiceImpl(this);
    private final WxMaShopCatService shopCatService = new WxMaShopCatServiceImpl(this);
    private final WxMaShopImgService shopImgService = new WxMaShopImgServiceImpl(this);
    private final WxMaShopAuditService shopAuditService = new WxMaShopAuditServiceImpl(this);
    private final WxMaShopAfterSaleService shopAfterSaleService = new WxMaShopAfterSaleServiceImpl(this);
    private final WxMaShopDeliveryService shopDeliveryService = new WxMaShopDeliveryServiceImpl(this);
    private final WxMaLinkService linkService = new WxMaLinkServiceImpl(this);
    private final WxMaReimburseInvoiceService reimburseInvoiceService = new WxMaReimburseInvoiceServiceImpl(this);
    private final WxMaDeviceSubscribeService deviceSubscribeService = new WxMaDeviceSubscribeServiceImpl(this);
    private final WxMaMarketingService marketingService = new WxMaMarketingServiceImpl(this);
    private final WxMaImmediateDeliveryService immediateDeliveryService = new WxMaImmediateDeliveryServiceImpl(this);
    private final WxMaShopSharerService shopSharerService = new WxMaShopSharerServiceImpl(this);
    private final WxMaProductService productService = new WxMaProductServiceImpl(this);
    private final WxMaProductOrderService productOrderService = new WxMaProductOrderServiceImpl(this);
    private final WxMaShopCouponService wxMaShopCouponService = new WxMaShopCouponServiceImpl(this);
    private final WxMaShopPayService wxMaShopPayService = new WxMaShopPayServiceImpl(this);
    private final WxMaOrderShippingService wxMaOrderShippingService = new WxMaOrderShippingServiceImpl(this);
    private final WxMaOrderManagementService wxMaOrderManagementService = new WxMaOrderManagementServiceImpl(this);
    private final WxMaOpenApiService wxMaOpenApiService = new WxMaOpenApiServiceImpl(this);
    private final WxMaVodService wxMaVodService = new WxMaVodServiceImpl(this);
    private final WxMaXPayService wxMaXPayService = new WxMaXPayServiceImpl(this);
    private final WxMaExpressDeliveryReturnService wxMaExpressDeliveryReturnService = new WxMaExpressDeliveryReturnServiceImpl(this);
    private final WxMaPromotionService wxMaPromotionService = new WxMaPromotionServiceImpl(this);
    private final WxMaIntracityService intracityService = new WxMaIntracityServiceImpl(this);
    private Map<String, WxMaConfig> configMap = new HashMap<String, WxMaConfig>();
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;

    @Override
    public RequestHttp getRequestHttp() {
        return this;
    }

    @Override
    public String getPaidUnionId(String openid, String transactionId, String mchId, String outTradeNo) throws WxErrorException {
        String responseContent;
        WxError error;
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("openid", openid);
        if (StringUtils.isNotEmpty((CharSequence)transactionId)) {
            params.put("transaction_id", transactionId);
        }
        if (StringUtils.isNotEmpty((CharSequence)mchId)) {
            params.put("mch_id", mchId);
        }
        if (StringUtils.isNotEmpty((CharSequence)outTradeNo)) {
            params.put("out_trade_no", outTradeNo);
        }
        if ((error = WxError.fromJson((String)(responseContent = this.get("https://api.weixin.qq.com/wxa/getpaidunionid", Joiner.on((String)"&").withKeyValueSeparator("=").join(params))), (WxType)WxType.MiniApp)).getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return GsonParser.parse((String)responseContent).get("unionid").getAsString();
    }

    @Override
    public WxMaJscode2SessionResult jsCode2SessionInfo(String jsCode) throws WxErrorException {
        WxMaConfig config = this.getWxMaConfig();
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("appid", config.getAppid());
        params.put("secret", config.getSecret());
        params.put("js_code", jsCode);
        params.put("grant_type", "authorization_code");
        String result = this.get("https://api.weixin.qq.com/sns/jscode2session", Joiner.on((String)"&").withKeyValueSeparator("=").join(params));
        return WxMaJscode2SessionResult.fromJson(result);
    }

    @Override
    public void setDynamicData(int lifespan, String type, int scene, String data) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("lifespan", (Number)lifespan);
        jsonObject.addProperty("query", WxGsonBuilder.create().toJson((Object)ImmutableMap.of((Object)"type", (Object)type)));
        jsonObject.addProperty("data", data);
        jsonObject.addProperty("scene", (Number)scene);
        this.post("https://api.weixin.qq.com/wxa/setdynamicdata", jsonObject.toString());
    }

    @Override
    public boolean checkSignature(String timestamp, String nonce, String signature) {
        try {
            return SHA1.gen((String[])new String[]{this.getWxMaConfig().getToken(), timestamp, nonce}).equals(signature);
        }
        catch (Exception e) {
            log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (!forceRefresh && !this.getWxMaConfig().isAccessTokenExpired()) {
            return this.getWxMaConfig().getAccessToken();
        }
        Lock lock = this.getWxMaConfig().getAccessTokenLock();
        boolean locked = false;
        try {
            do {
                locked = lock.tryLock(100L, TimeUnit.MILLISECONDS);
                if (forceRefresh || this.getWxMaConfig().isAccessTokenExpired()) continue;
                String string = this.getWxMaConfig().getAccessToken();
                return string;
            } while (!locked);
            String response = this.getWxMaConfig().isStableAccessToken() ? this.doGetStableAccessTokenRequest(forceRefresh) : this.doGetAccessTokenRequest();
            String string = this.extractAccessToken(response);
            return string;
        }
        catch (IOException | InterruptedException e) {
            throw new WxRuntimeException((Throwable)e);
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    protected abstract String doGetAccessTokenRequest() throws IOException;

    protected abstract String doGetStableAccessTokenRequest(boolean var1) throws IOException;

    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute((RequestExecutor<R, T>)SimpleGetRequestExecutor.create((RequestHttp)this), url, (T)queryParam);
    }

    private boolean isApiSignatureRequired(String url) {
        return this.getWxMaConfig().getApiSignatureAesKey() != null && Arrays.stream(urlPathSupportApiSignature).anyMatch(part -> url.contains((CharSequence)part));
    }

    public String post(String url, String postData) throws WxErrorException {
        if (this.isApiSignatureRequired(url)) {
            log.debug("\u5df2\u7ecf\u914d\u7f6e\u63a5\u53e3\u9700\u8981\u7b7e\u540d\uff0c\u63a5\u53e3{}\u5c06\u8d70\u52a0\u5bc6\u8bbf\u95ee\u8def\u5f84", (Object)url);
            JsonObject jsonObject = (JsonObject)GSON.fromJson(postData == null ? "{}" : postData, JsonObject.class);
            return this.postWithSignature(url, jsonObject);
        }
        return (String)this.execute((RequestExecutor<R, T>)SimplePostRequestExecutor.create((RequestHttp)this), url, (T)postData);
    }

    public String post(String url, Object obj) throws WxErrorException {
        if (this.isApiSignatureRequired(url)) {
            log.debug("\u5df2\u7ecf\u914d\u7f6e\u63a5\u53e3\u9700\u8981\u7b7e\u540d\uff0c\u63a5\u53e3{}\u5c06\u8d70\u52a0\u5bc6\u8bbf\u95ee\u8def\u5f84", (Object)url);
            return this.postWithSignature(url, obj);
        }
        return (String)this.execute((RequestExecutor<R, T>)SimplePostRequestExecutor.create((RequestHttp)this), url, (T)WxGsonBuilder.create().toJson(obj));
    }

    public String post(String url, ToJson obj) throws WxErrorException {
        return this.post(url, obj == null ? "{}" : obj.toJson());
    }

    public String post(String url, JsonObject jsonObject) throws WxErrorException {
        return this.post(url, jsonObject == null ? "{}" : jsonObject.toString());
    }

    public String upload(String url, CommonUploadParam param) throws WxErrorException {
        RequestExecutor executor = CommonUploadRequestExecutor.create((RequestHttp)this.getRequestHttp());
        return (String)this.execute((RequestExecutor<R, T>)executor, url, (T)param);
    }

    public <R, T> R execute(RequestExecutor<R, T> executor, String uri, T data) throws WxErrorException {
        String dataForLog = data == null ? null : (data instanceof String ? (String)DataUtils.handleDataWithSecret((Object)((String)data)) : data.toString());
        return (R)this.executeWithRetry(uriWithAccessToken -> executor.execute(uriWithAccessToken, data, WxType.MiniApp), uri, dataForLog);
    }

    @Override
    public WxMaApiResponse execute(ApiSignaturePostRequestExecutor executor, String uri, Map<String, String> headers, String data) throws WxErrorException {
        String dataForLog = "Headers: " + headers.toString() + " Body: " + data;
        return this.executeWithRetry(uriWithAccessToken -> executor.execute(uriWithAccessToken, headers, data, WxType.MiniApp), uri, dataForLog);
    }

    private <R, T> R executeWithRetry(ExecutorAction<R> executor, String uri, String dataForLog) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, dataForLog, false);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new WxErrorException(WxError.builder().errorCode(e.getError().getErrorCode()).errorMsg("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570\uff01").build());
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        log.warn("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw e;
                if (retryTimes++ < this.maxRetryTimes) continue;
                log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new WxRuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, T> R executeInternal(ExecutorAction<R> executor, String uri, String dataForLog, boolean doNotAutoRefreshToken) throws WxErrorException {
        if (uri.contains("access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String accessToken = this.getAccessToken(false);
        if (StringUtils.isNotEmpty((CharSequence)this.getWxMaConfig().getApiHostUrl())) {
            uri = uri.replace("https://api.weixin.qq.com", this.getWxMaConfig().getApiHostUrl());
        }
        String uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "access_token=" + accessToken;
        try {
            R result = executor.execute(uriWithAccessToken);
            log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, result});
            return result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (WxConsts.ACCESS_TOKEN_ERROR_CODES.contains(error.getErrorCode())) {
                Lock lock = this.getWxMaConfig().getAccessTokenLock();
                lock.lock();
                try {
                    if (StringUtils.equals((CharSequence)this.getWxMaConfig().getAccessToken(), (CharSequence)accessToken)) {
                        this.getWxMaConfig().expireAccessToken();
                    }
                }
                catch (Exception ex) {
                    this.getWxMaConfig().expireAccessToken();
                }
                finally {
                    lock.unlock();
                }
                if (this.getWxMaConfig().autoRefreshToken() && !doNotAutoRefreshToken) {
                    log.warn("\u5373\u5c06\u91cd\u65b0\u83b7\u53d6\u65b0\u7684access_token\uff0c\u9519\u8bef\u4ee3\u7801\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)error.getErrorCode(), (Object)error.getErrorMsg());
                    return this.executeInternal(executor, uri, dataForLog, true);
                }
            }
            if (error.getErrorCode() != 0) {
                log.warn("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            log.warn("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, e.getMessage()});
            throw new WxRuntimeException((Throwable)e);
        }
    }

    protected String extractAccessToken(String resultContent) throws WxErrorException {
        log.debug("access-token response: {}", (Object)resultContent);
        WxMaConfig config = this.getWxMaConfig();
        WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.MiniApp);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
        config.updateAccessTokenProcessor(accessToken.getAccessToken(), accessToken.getExpiresIn());
        return accessToken.getAccessToken();
    }

    @Override
    public WxMaConfig getWxMaConfig() {
        if (this.configMap.size() == 1) {
            return this.configMap.values().iterator().next();
        }
        return this.configMap.get(WxMaConfigHolder.get());
    }

    @Override
    public void setWxMaConfig(WxMaConfig maConfig) {
        String appid = maConfig.getAppid();
        HashMap<String, WxMaConfig> map = new HashMap<String, WxMaConfig>();
        map.put(appid, maConfig);
        Map<String, WxMaConfig> configMap = Collections.unmodifiableMap(map);
        this.setMultiConfigs(configMap, appid);
    }

    @Override
    public void setMultiConfigs(Map<String, WxMaConfig> configs) {
        this.setMultiConfigs(configs, configs.keySet().iterator().next());
    }

    @Override
    @JsonDeserialize
    public void setMultiConfigs(Map<String, WxMaConfig> configs, String defaultMiniappId) {
        if (this.configMap != null) {
            this.configMap.putAll(configs);
        } else {
            this.configMap = Maps.newHashMap(configs);
        }
        WxMaConfigHolder.set(defaultMiniappId);
        this.initHttp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConfig(String miniappId, WxMaConfig configStorages) {
        BaseWxMaServiceImpl baseWxMaServiceImpl = this;
        synchronized (baseWxMaServiceImpl) {
            if (this.configMap == null || this.configMap.isEmpty()) {
                this.setWxMaConfig(configStorages);
            } else {
                WxMaConfigHolder.set(miniappId);
                this.configMap.put(miniappId, configStorages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfig(String miniappId) {
        BaseWxMaServiceImpl baseWxMaServiceImpl = this;
        synchronized (baseWxMaServiceImpl) {
            if (this.configMap.size() == 1) {
                this.configMap.remove(miniappId);
                log.warn("\u5df2\u5220\u9664\u6700\u540e\u4e00\u4e2a\u5c0f\u7a0b\u5e8f\u914d\u7f6e\uff1a{}\uff0c\u987b\u7acb\u5373\u4f7f\u7528setWxMaConfig\u6216setMultiConfigs\u6dfb\u52a0\u914d\u7f6e", (Object)miniappId);
                return;
            }
            if (WxMaConfigHolder.get().equals(miniappId)) {
                this.configMap.remove(miniappId);
                String defaultMpId = this.configMap.keySet().iterator().next();
                WxMaConfigHolder.set(defaultMpId);
                log.warn("\u5df2\u5220\u9664\u9ed8\u8ba4\u5c0f\u7a0b\u5e8f\u914d\u7f6e\uff0c\u5c0f\u7a0b\u5e8f\u3010{}\u3011\u88ab\u8bbe\u4e3a\u9ed8\u8ba4\u914d\u7f6e", (Object)defaultMpId);
                return;
            }
            this.configMap.remove(miniappId);
        }
    }

    @Override
    public WxMaService switchoverTo(String miniAppId) {
        return this.switchoverTo(miniAppId, null);
    }

    @Override
    public WxMaService switchoverTo(String miniAppId, Function<String, WxMaConfig> func) {
        WxMaConfig config;
        if (this.configMap.containsKey(miniAppId)) {
            WxMaConfigHolder.set(miniAppId);
            return this;
        }
        if (func != null && (config = func.apply(miniAppId)) != null) {
            this.addConfig(miniAppId, config);
            return this;
        }
        throw new WxRuntimeException(String.format("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u3010%s\u3011\u7684\u5c0f\u7a0b\u5e8f\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01", miniAppId));
    }

    @Override
    public boolean switchover(String mpId) {
        if (this.configMap.containsKey(mpId)) {
            WxMaConfigHolder.set(mpId);
            return true;
        }
        log.error("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u3010{}\u3011\u7684\u5c0f\u7a0b\u5e8f\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e\uff01", (Object)mpId);
        return false;
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public WxMaMsgService getMsgService() {
        return this.kefuService;
    }

    @Override
    public WxMaMediaService getMediaService() {
        return this.materialService;
    }

    @Override
    public WxMaUserService getUserService() {
        return this.userService;
    }

    @Override
    public WxMaQrcodeService getQrcodeService() {
        return this.qrCodeService;
    }

    @Override
    public WxMaSchemeService getWxMaSchemeService() {
        return this.schemeService;
    }

    @Override
    public WxMaSubscribeService getSubscribeService() {
        return this.subscribeService;
    }

    @Override
    public WxMaAnalysisService getAnalysisService() {
        return this.analysisService;
    }

    @Override
    public WxMaCodeService getCodeService() {
        return this.codeService;
    }

    @Override
    public WxMaJsapiService getJsapiService() {
        return this.jsapiService;
    }

    @Override
    public WxMaSettingService getSettingService() {
        return this.settingService;
    }

    @Override
    public WxMaShareService getShareService() {
        return this.shareService;
    }

    @Override
    public WxMaRunService getRunService() {
        return this.runService;
    }

    @Override
    public WxMaSecurityService getSecurityService() {
        return this.securityService;
    }

    @Override
    public WxMaPluginService getPluginService() {
        return this.pluginService;
    }

    @Override
    public WxMaExpressService getExpressService() {
        return this.expressService;
    }

    @Override
    public WxMaCloudService getCloudService() {
        return this.cloudService;
    }

    @Override
    public WxMaInternetService getInternetService() {
        return this.internetService;
    }

    @Override
    public WxMaLiveService getLiveService() {
        return this.liveService;
    }

    @Override
    public WxMaLiveGoodsService getLiveGoodsService() {
        return this.liveGoodsService;
    }

    @Override
    public WxMaLiveMemberService getLiveMemberService() {
        return this.liveMemberService;
    }

    @Override
    public WxOcrService getOcrService() {
        return this.ocrService;
    }

    @Override
    public WxImgProcService getImgProcService() {
        return this.imgProcService;
    }

    @Override
    public WxMaShopSpuService getShopSpuService() {
        return this.shopSpuService;
    }

    @Override
    public WxMaShopOrderService getShopOrderService() {
        return this.shopOrderService;
    }

    @Override
    public WxMaShopRegisterService getShopRegisterService() {
        return this.shopRegisterService;
    }

    @Override
    public WxMaShopAccountService getShopAccountService() {
        return this.shopAccountService;
    }

    @Override
    public WxMaShopCatService getShopCatService() {
        return this.shopCatService;
    }

    @Override
    public WxMaShopImgService getShopImgService() {
        return this.shopImgService;
    }

    @Override
    public WxMaShopAuditService getShopAuditService() {
        return this.shopAuditService;
    }

    @Override
    public WxMaShopAfterSaleService getShopAfterSaleService() {
        return this.shopAfterSaleService;
    }

    @Override
    public WxMaShopDeliveryService getShopDeliveryService() {
        return this.shopDeliveryService;
    }

    @Override
    public WxMaLinkService getLinkService() {
        return this.linkService;
    }

    @Override
    public WxMaReimburseInvoiceService getReimburseInvoiceService() {
        return this.reimburseInvoiceService;
    }

    @Override
    public WxMaDeviceSubscribeService getDeviceSubscribeService() {
        return this.deviceSubscribeService;
    }

    @Override
    public WxMaMarketingService getMarketingService() {
        return this.marketingService;
    }

    @Override
    public WxMaImmediateDeliveryService getWxMaImmediateDeliveryService() {
        return this.immediateDeliveryService;
    }

    @Override
    public WxMaShopSharerService getShopSharerService() {
        return this.shopSharerService;
    }

    @Override
    public WxMaProductService getProductService() {
        return this.productService;
    }

    @Override
    public WxMaProductOrderService getProductOrderService() {
        return this.productOrderService;
    }

    @Override
    public WxMaShopCouponService getWxMaShopCouponService() {
        return this.wxMaShopCouponService;
    }

    @Override
    public WxMaShopPayService getWxMaShopPayService() {
        return this.wxMaShopPayService;
    }

    @Override
    public WxMaOrderShippingService getWxMaOrderShippingService() {
        return this.wxMaOrderShippingService;
    }

    @Override
    public WxMaOrderManagementService getWxMaOrderManagementService() {
        return this.wxMaOrderManagementService;
    }

    @Override
    public WxMaOpenApiService getWxMaOpenApiService() {
        return this.wxMaOpenApiService;
    }

    @Override
    public WxMaVodService getWxMaVodService() {
        return this.wxMaVodService;
    }

    @Override
    public WxMaXPayService getWxMaXPayService() {
        return this.wxMaXPayService;
    }

    @Override
    public WxMaExpressDeliveryReturnService getWxMaExpressDeliveryReturnService() {
        return this.wxMaExpressDeliveryReturnService;
    }

    @Override
    public WxMaPromotionService getWxMaPromotionService() {
        return this.wxMaPromotionService;
    }

    @Override
    public String postWithSignature(String url, Object obj) throws WxErrorException {
        Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
        JsonObject jsonObject = obj == null ? (JsonObject)gson.fromJson("{}", JsonObject.class) : gson.toJsonTree(obj).getAsJsonObject();
        return this.postWithSignature(url, jsonObject);
    }

    private String generateNonce() {
        byte[] nonce = this.generateRandomBytes(16);
        return this.base64Encode(nonce).replace("=", "");
    }

    private byte[] generateRandomBytes(int length) {
        byte[] bytes = new byte[length];
        new SecureRandom().nextBytes(bytes);
        return bytes;
    }

    private String base64Encode(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    @Override
    public String postWithSignature(String url, JsonObject jsonObject) throws WxErrorException {
        byte[] realKey;
        long timestamp = System.currentTimeMillis() / 1000L;
        String appId = this.getWxMaConfig().getWechatMpAppid();
        String rndStr = UUID.randomUUID().toString().replace("-", "").substring(0, 30);
        String aesKey = this.getWxMaConfig().getApiSignatureAesKey();
        String aesKeySn = this.getWxMaConfig().getApiSignatureAesKeySn();
        jsonObject.addProperty("_n", rndStr);
        jsonObject.addProperty("_appid", appId);
        jsonObject.addProperty("_timestamp", (Number)timestamp);
        String plainText = jsonObject.toString();
        log.debug("URL:{}\u52a0\u5bc6\u524d\u8bf7\u6c42\u6570\u636e:{}", (Object)url, (Object)plainText);
        String urlPath = url.contains("?") ? url.substring(0, url.indexOf("?")) : url;
        String aad = urlPath + "|" + appId + "|" + timestamp + "|" + aesKeySn;
        try {
            realKey = Base64.getDecoder().decode(aesKey);
        }
        catch (Exception ex) {
            log.error("\u89e3\u6790AESKEY\u5931\u8d25 {}", (Object)aesKey, (Object)ex);
            throw new SecurityException("\u89e3\u6790AES KEY\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5ApiSignatureAesKey\u662f\u5426\u6b63\u786e", ex);
        }
        byte[] realIv = this.generateRandomBytes(12);
        byte[] realAad = aad.getBytes(StandardCharsets.UTF_8);
        byte[] realPlainText = plainText.getBytes(StandardCharsets.UTF_8);
        try {
            RSAPrivateKey priKey;
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            SecretKeySpec aesKeySpec = new SecretKeySpec(realKey, "AES");
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, realIv);
            cipher.init(1, (Key)aesKeySpec, parameterSpec);
            cipher.updateAAD(realAad);
            byte[] ciphertext = cipher.doFinal(realPlainText);
            byte[] encryptedData = Arrays.copyOfRange(ciphertext, 0, ciphertext.length - 16);
            byte[] authTag = Arrays.copyOfRange(ciphertext, ciphertext.length - 16, ciphertext.length);
            JsonObject reqData = new JsonObject();
            reqData.addProperty("iv", this.base64Encode(realIv));
            reqData.addProperty("data", this.base64Encode(encryptedData));
            reqData.addProperty("authtag", this.base64Encode(authTag));
            String requestJson = reqData.toString();
            String payload = urlPath + "\n" + appId + "\n" + timestamp + "\n" + requestJson;
            byte[] dataBuffer = payload.getBytes(StandardCharsets.UTF_8);
            try {
                String rsaPrivateKey = this.getWxMaConfig().getApiSignatureRsaPrivateKey();
                rsaPrivateKey = rsaPrivateKey.replace("-----BEGIN PRIVATE KEY-----", "");
                rsaPrivateKey = rsaPrivateKey.replace("-----END PRIVATE KEY-----", "");
                rsaPrivateKey = rsaPrivateKey.replaceAll("\\s+", "");
                byte[] decoded = Base64.getDecoder().decode(rsaPrivateKey.getBytes(StandardCharsets.UTF_8));
                PKCS8EncodedKeySpec rsaKeySpec = new PKCS8EncodedKeySpec(decoded);
                priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(rsaKeySpec);
            }
            catch (Exception ex) {
                log.error("\u89e3\u6790RSA KEY\u5931\u8d25 {}", (Object)aesKey, (Object)ex);
                throw new SecurityException("\u89e3\u6790RSA KEY\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5ApiSignatureRsaPrivateKey\u662f\u5426\u6b63\u786e\uff0c\u9700\u8981PKCS8\u683c\u5f0f\u79c1\u94a5", ex);
            }
            Signature signature = Signature.getInstance("RSASSA-PSS");
            PSSParameterSpec pssParameterSpec = new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1);
            signature.setParameter(pssParameterSpec);
            signature.initSign(priKey);
            signature.update(dataBuffer);
            byte[] sigBuffer = signature.sign();
            String signatureString = this.base64Encode(sigBuffer);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Wechatmp-Signature", signatureString);
            header.put("Wechatmp-Appid", appId);
            header.put("Wechatmp-TimeStamp", String.valueOf(timestamp));
            log.debug("\u53d1\u9001\u8bf7\u6c42uri:{}, headers:{}, postData:{}", new Object[]{url, header, requestJson});
            WxMaApiResponse response = this.execute(ApiSignaturePostRequestExecutor.create(this), url, header, requestJson);
            String respTs = response.getHeaders().get("Wechatmp-TimeStamp");
            String respAad = urlPath + "|" + appId + "|" + respTs + "|" + aesKeySn;
            if (!appId.equals(response.getHeaders().get("Wechatmp-Appid"))) {
                throw new RuntimeException("\u54cd\u5e94\u7684appId\u4e0d\u7b26 " + response.getHeaders().get("Wechatmp-Appid"));
            }
            String decryptedData = this.aesDecodeResponse(response, respAad, aesKeySpec);
            log.debug("\u89e3\u5bc6\u540e\u7684\u54cd\u5e94:{}", (Object)decryptedData);
            WxError error = WxError.fromJson((String)decryptedData, (WxType)WxType.MiniApp);
            if (error.getErrorCode() != 0) {
                log.debug("\u8c03\u7528API\u51fa\u9519\uff0c uri:{}, postData:{}, response:{}", new Object[]{url, plainText, error});
                throw new WxErrorException(error);
            }
            return decryptedData;
        }
        catch (SecurityException | WxErrorException ex) {
            throw ex;
        }
        catch (Exception e) {
            log.error("postWithSignature", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String aesDecodeResponse(WxMaApiResponse response, String aad, SecretKeySpec aesKeySpec) throws Exception {
        Map map = (Map)GSON.fromJson(response.getContent(), Map.class);
        String iv = (String)map.get("iv");
        String data = (String)map.get("data");
        String authTag = (String)map.get("authtag");
        byte[] dataBytes = Base64.getDecoder().decode(data);
        byte[] authTagBytes = Base64.getDecoder().decode(authTag);
        byte[] newDataBytes = new byte[dataBytes.length + authTagBytes.length];
        System.arraycopy(dataBytes, 0, newDataBytes, 0, dataBytes.length);
        System.arraycopy(authTagBytes, 0, newDataBytes, dataBytes.length, authTagBytes.length);
        byte[] aadBytes = aad.getBytes(StandardCharsets.UTF_8);
        byte[] ivBytes = Base64.getDecoder().decode(iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, ivBytes);
        cipher.init(2, (Key)aesKeySpec, gcmParameterSpec);
        cipher.updateAAD(aadBytes);
        byte[] decryptedBytes = cipher.doFinal(newDataBytes);
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }

    @Override
    public WxMaIntracityService getIntracityService() {
        return this.intracityService;
    }

    private static interface ExecutorAction<R> {
        public R execute(String var1) throws IOException, WxErrorException;
    }
}

