/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaUserService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.bean.WxMaUserInfo;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import cn.binarywang.wx.miniapp.util.crypt.WxMaCryptUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.SignUtils;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.apache.commons.codec.digest.DigestUtils;

public class WxMaUserServiceImpl
implements WxMaUserService {
    private static final String PHONE_INFO = "phone_info";
    private final WxMaService service;

    @Override
    public WxMaJscode2SessionResult getSessionInfo(String jsCode) throws WxErrorException {
        return this.service.jsCode2SessionInfo(jsCode);
    }

    @Override
    public WxMaUserInfo getUserInfo(String sessionKey, String encryptedData, String ivStr) {
        return WxMaUserInfo.fromJson(WxMaCryptUtils.decrypt(sessionKey, encryptedData, ivStr));
    }

    @Override
    public void setUserStorage(Map<String, String> kvMap, String sessionKey, String openid) throws WxErrorException {
        WxMaConfig config = this.service.getWxMaConfig();
        JsonObject param = new JsonObject();
        JsonArray array = new JsonArray();
        for (Map.Entry<String, String> e : kvMap.entrySet()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("key", e.getKey());
            jsonObject.addProperty("value", e.getValue());
            array.add((JsonElement)jsonObject);
        }
        param.add("kv_list", (JsonElement)array);
        String params = param.toString();
        String signature = SignUtils.createHmacSha256Sign((String)params, (String)sessionKey);
        String url = String.format("https://api.weixin.qq.com/wxa/set_user_storage?appid=%s&signature=%s&openid=%s&sig_method=%s", config.getAppid(), signature, openid, "hmac_sha256");
        this.service.post(url, params);
    }

    @Override
    public WxMaPhoneNumberInfo getPhoneNoInfo(String sessionKey, String encryptedData, String ivStr) {
        return WxMaPhoneNumberInfo.fromJson(WxMaCryptUtils.decrypt(sessionKey, encryptedData, ivStr));
    }

    @Override
    public WxMaPhoneNumberInfo getPhoneNumber(String code) throws WxErrorException {
        JsonObject param = new JsonObject();
        param.addProperty("code", code);
        String responseContent = this.service.post("https://api.weixin.qq.com/wxa/business/getuserphonenumber", param.toString());
        JsonObject response = GsonParser.parse((String)responseContent);
        if (response.has(PHONE_INFO)) {
            return (WxMaPhoneNumberInfo)WxMaGsonBuilder.create().fromJson((JsonElement)response.getAsJsonObject(PHONE_INFO), WxMaPhoneNumberInfo.class);
        }
        return null;
    }

    @Override
    public WxMaPhoneNumberInfo getPhoneNoInfo(String code) throws WxErrorException {
        return this.getPhoneNumber(code);
    }

    @Override
    public boolean checkUserInfo(String sessionKey, String rawData, String signature) {
        String generatedSignature = DigestUtils.sha1Hex((String)(rawData + sessionKey));
        return generatedSignature.equals(signature);
    }

    public WxMaUserServiceImpl(WxMaService service) {
        this.service = service;
    }
}

