/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.config.impl;

import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.common.enums.TicketType;
import me.chanjar.weixin.common.redis.WxRedisOps;

public class WxMaRedisBetterConfigImpl
extends WxMaDefaultConfigImpl {
    private static final String ACCESS_TOKEN_KEY_TPL = "%s:access_token:%s";
    private static final String TICKET_KEY_TPL = "%s:ticket:key:%s:%s";
    private static final String LOCK_KEY_TPL = "%s:lock:%s:";
    private final WxRedisOps redisOps;
    private final String keyPrefix;
    private volatile String accessTokenKey;
    private volatile String lockKey;

    public WxMaRedisBetterConfigImpl(WxRedisOps redisOps, String keyPrefix) {
        this.redisOps = redisOps;
        this.keyPrefix = keyPrefix;
    }

    @Override
    public void setAppid(String appId) {
        super.setAppid(appId);
        this.accessTokenKey = String.format(ACCESS_TOKEN_KEY_TPL, this.keyPrefix, appId);
        this.lockKey = String.format(LOCK_KEY_TPL, this.keyPrefix, appId);
        this.accessTokenLock = this.redisOps.getLock(this.lockKey.concat("accessTokenLock"));
        this.jsapiTicketLock = this.redisOps.getLock(this.lockKey.concat("jsapiTicketLock"));
        this.cardApiTicketLock = this.redisOps.getLock(this.lockKey.concat("cardApiTicketLock"));
    }

    @Override
    public String getAccessToken() {
        return this.redisOps.getValue(this.accessTokenKey);
    }

    @Override
    public boolean isAccessTokenExpired() {
        Long expire = this.redisOps.getExpire(this.accessTokenKey);
        return expire == null || expire < 2L;
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.redisOps.setValue(this.accessTokenKey, accessToken, expiresInSeconds - 200, TimeUnit.SECONDS);
    }

    @Override
    public void expireAccessToken() {
        this.redisOps.expire(this.accessTokenKey, 0, TimeUnit.SECONDS);
    }

    @Override
    public String getJsapiTicket() {
        return this.doGetTicket(TicketType.JSAPI);
    }

    @Override
    public boolean isJsapiTicketExpired() {
        return this.doIsTicketExpired(TicketType.JSAPI);
    }

    @Override
    public void expireJsapiTicket() {
        this.doExpireTicket(TicketType.JSAPI);
    }

    @Override
    public synchronized void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
        this.doUpdateTicket(TicketType.JSAPI, jsapiTicket, expiresInSeconds);
    }

    @Override
    public String getCardApiTicket() {
        return this.doGetTicket(TicketType.WX_CARD);
    }

    @Override
    public boolean isCardApiTicketExpired() {
        return this.doIsTicketExpired(TicketType.WX_CARD);
    }

    @Override
    public void expireCardApiTicket() {
        this.doExpireTicket(TicketType.WX_CARD);
    }

    @Override
    public synchronized void updateCardApiTicket(String cardApiTicket, int expiresInSeconds) {
        this.doUpdateTicket(TicketType.WX_CARD, cardApiTicket, expiresInSeconds);
    }

    private String getTicketRedisKey(TicketType type) {
        return String.format(TICKET_KEY_TPL, this.keyPrefix, this.appid, type.getCode());
    }

    private String doGetTicket(TicketType type) {
        return this.redisOps.getValue(this.getTicketRedisKey(type));
    }

    private boolean doIsTicketExpired(TicketType type) {
        return this.redisOps.getExpire(this.getTicketRedisKey(type)) < 2L;
    }

    private void doUpdateTicket(TicketType type, String ticket, int expiresInSeconds) {
        this.redisOps.setValue(this.getTicketRedisKey(type), ticket, expiresInSeconds - 200, TimeUnit.SECONDS);
    }

    private void doExpireTicket(TicketType type) {
        this.redisOps.expire(this.getTicketRedisKey(type), 0, TimeUnit.SECONDS);
    }
}

