/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxRuntimeException;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultText;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static Map<String, Object> xml2Map(String xmlString) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = saxReader.read((Reader)new StringReader(xmlString));
            Element root = doc.getRootElement();
            List elements = root.elements();
            for (Element element : elements) {
                String elementName = element.getName();
                if (map.containsKey(elementName)) {
                    if (map.get(elementName) instanceof List) {
                        ((List)map.get(elementName)).add(XmlUtils.element2MapOrString(element));
                        continue;
                    }
                    ArrayList value = Lists.newArrayList((Object[])new Object[]{map.get(elementName)});
                    value.add(XmlUtils.element2MapOrString(element));
                    map.put(elementName, value);
                    continue;
                }
                map.put(elementName, XmlUtils.element2MapOrString(element));
            }
        }
        catch (DocumentException | SAXException e) {
            throw new WxRuntimeException(e);
        }
        return map;
    }

    private static Object element2MapOrString(Element element) {
        List nodes = element.content();
        List<String> names = XmlUtils.names(nodes);
        if (names.size() < 1) {
            return element.getText();
        }
        HashMap result = Maps.newHashMap();
        HashSet distinctNames = Sets.newHashSet(names);
        if (distinctNames.size() == 1) {
            ArrayList list = Lists.newArrayList();
            for (Node node : nodes) {
                if (node instanceof DefaultText || !(node instanceof Element)) continue;
                list.add(XmlUtils.element2MapOrString((Element)node));
            }
            result.put(names.iterator().next(), list);
        } else if (distinctNames.size() == names.size()) {
            for (Node node : nodes) {
                if (node instanceof DefaultText || !(node instanceof Element)) continue;
                result.put(node.getName(), XmlUtils.element2MapOrString((Element)node));
            }
        } else {
            Map<String, Long> namesCountMap = names.stream().collect(Collectors.groupingBy(a -> a, Collectors.counting()));
            for (Node node : nodes) {
                List<Object> values;
                if (node instanceof DefaultText || !(node instanceof Element)) continue;
                String nodeName = node.getName();
                if (namesCountMap.get(nodeName) == 1L) {
                    result.put(nodeName, XmlUtils.element2MapOrString((Element)node));
                    continue;
                }
                if (result.containsKey(nodeName)) {
                    values = (List)result.get(nodeName);
                } else {
                    values = Lists.newArrayList();
                    result.put(nodeName, values);
                }
                values.add(XmlUtils.element2MapOrString((Element)node));
            }
        }
        return result;
    }

    private static List<String> names(List<Node> nodes) {
        ArrayList names = Lists.newArrayList();
        for (Node node : nodes) {
            if (node instanceof DefaultText || node instanceof CDATA) continue;
            names.add(node.getName());
        }
        return names;
    }
}

