/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.jodd;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.BaseMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.HttpResponseProxy;
import me.chanjar.weixin.common.util.http.RequestHttp;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class JoddHttpMediaDownloadRequestExecutor
extends BaseMediaDownloadRequestExecutor<HttpConnectionProvider, ProxyInfo> {
    public JoddHttpMediaDownloadRequestExecutor(RequestHttp requestHttp, File tmpDirFile) {
        super(requestHttp, tmpDirFile);
    }

    @Override
    public File execute(String uri, String queryParam, WxType wxType) throws WxErrorException, IOException {
        if (queryParam != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? queryParam : '&' + queryParam);
        }
        HttpRequest request = HttpRequest.get((String)uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            ((HttpConnectionProvider)this.requestHttp.getRequestHttpClient()).useProxy((ProxyInfo)this.requestHttp.getRequestHttpProxy());
        }
        request.withConnectionProvider((HttpConnectionProvider)this.requestHttp.getRequestHttpClient());
        HttpResponse response = request.send();
        response.charset("UTF-8");
        String contentType = response.header("Content-Type");
        if (contentType != null && contentType.startsWith("application/json")) {
            throw new WxErrorException(WxError.fromJson(response.bodyText(), wxType));
        }
        String fileName = new HttpResponseProxy(response).getFileName();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        String baseName = FilenameUtils.getBaseName((String)fileName);
        if (StringUtils.isBlank((CharSequence)fileName) || baseName.length() < 3) {
            baseName = String.valueOf(System.currentTimeMillis());
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(response.bodyBytes());){
            File file = FileUtils.createTmpFile(inputStream, baseName, FilenameUtils.getExtension((String)fileName), this.tmpDirFile);
            return file;
        }
    }
}

