/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.impl;

import com.binance.api.client.BinanceApiRestClient;
import com.binance.api.client.domain.account.Account;
import com.binance.api.client.domain.account.DepositAddress;
import com.binance.api.client.domain.account.DepositHistory;
import com.binance.api.client.domain.account.NewOrder;
import com.binance.api.client.domain.account.NewOrderResponse;
import com.binance.api.client.domain.account.Order;
import com.binance.api.client.domain.account.Trade;
import com.binance.api.client.domain.account.WithdrawHistory;
import com.binance.api.client.domain.account.request.AllOrdersRequest;
import com.binance.api.client.domain.account.request.CancelOrderRequest;
import com.binance.api.client.domain.account.request.OrderRequest;
import com.binance.api.client.domain.account.request.OrderStatusRequest;
import com.binance.api.client.domain.general.ExchangeInfo;
import com.binance.api.client.domain.market.AggTrade;
import com.binance.api.client.domain.market.BookTicker;
import com.binance.api.client.domain.market.Candlestick;
import com.binance.api.client.domain.market.CandlestickInterval;
import com.binance.api.client.domain.market.OrderBook;
import com.binance.api.client.domain.market.TickerPrice;
import com.binance.api.client.domain.market.TickerStatistics;
import com.binance.api.client.impl.BinanceApiService;
import com.binance.api.client.impl.BinanceApiServiceGenerator;
import java.util.List;

public class BinanceApiRestClientImpl
implements BinanceApiRestClient {
    private final BinanceApiService binanceApiService;

    public BinanceApiRestClientImpl(String apiKey, String secret) {
        this.binanceApiService = BinanceApiServiceGenerator.createService(BinanceApiService.class, apiKey, secret);
    }

    @Override
    public void ping() {
        BinanceApiServiceGenerator.executeSync(this.binanceApiService.ping());
    }

    @Override
    public Long getServerTime() {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getServerTime()).getServerTime();
    }

    @Override
    public ExchangeInfo getExchangeInfo() {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getExchangeInfo());
    }

    @Override
    public OrderBook getOrderBook(String symbol, Integer limit) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getOrderBook(symbol, limit));
    }

    @Override
    public List<AggTrade> getAggTrades(String symbol, String fromId, Integer limit, Long startTime, Long endTime) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getAggTrades(symbol, fromId, limit, startTime, endTime));
    }

    @Override
    public List<AggTrade> getAggTrades(String symbol) {
        return this.getAggTrades(symbol, null, null, null, null);
    }

    @Override
    public List<Candlestick> getCandlestickBars(String symbol, CandlestickInterval interval, Integer limit, Long startTime, Long endTime) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getCandlestickBars(symbol, interval.getIntervalId(), limit, startTime, endTime));
    }

    @Override
    public List<Candlestick> getCandlestickBars(String symbol, CandlestickInterval interval) {
        return this.getCandlestickBars(symbol, interval, null, null, null);
    }

    @Override
    public TickerStatistics get24HrPriceStatistics(String symbol) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.get24HrPriceStatistics(symbol));
    }

    @Override
    public List<TickerPrice> getAllPrices() {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getLatestPrices());
    }

    @Override
    public List<BookTicker> getBookTickers() {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getBookTickers());
    }

    @Override
    public NewOrderResponse newOrder(NewOrder order) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.newOrder(order.getSymbol(), order.getSide(), order.getType(), order.getTimeInForce(), order.getQuantity(), order.getPrice(), order.getStopPrice(), order.getIcebergQty(), order.getRecvWindow(), order.getTimestamp()));
    }

    @Override
    public void newOrderTest(NewOrder order) {
        BinanceApiServiceGenerator.executeSync(this.binanceApiService.newOrderTest(order.getSymbol(), order.getSide(), order.getType(), order.getTimeInForce(), order.getQuantity(), order.getPrice(), order.getStopPrice(), order.getIcebergQty(), order.getRecvWindow(), order.getTimestamp()));
    }

    @Override
    public Order getOrderStatus(OrderStatusRequest orderStatusRequest) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getOrderStatus(orderStatusRequest.getSymbol(), orderStatusRequest.getOrderId(), orderStatusRequest.getOrigClientOrderId(), orderStatusRequest.getRecvWindow(), orderStatusRequest.getTimestamp()));
    }

    @Override
    public void cancelOrder(CancelOrderRequest cancelOrderRequest) {
        BinanceApiServiceGenerator.executeSync(this.binanceApiService.cancelOrder(cancelOrderRequest.getSymbol(), cancelOrderRequest.getOrderId(), cancelOrderRequest.getOrigClientOrderId(), cancelOrderRequest.getNewClientOrderId(), cancelOrderRequest.getRecvWindow(), cancelOrderRequest.getTimestamp()));
    }

    @Override
    public List<Order> getOpenOrders(OrderRequest orderRequest) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getOpenOrders(orderRequest.getSymbol(), orderRequest.getRecvWindow(), orderRequest.getTimestamp()));
    }

    @Override
    public List<Order> getAllOrders(AllOrdersRequest orderRequest) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getAllOrders(orderRequest.getSymbol(), orderRequest.getOrderId(), orderRequest.getLimit(), orderRequest.getRecvWindow(), orderRequest.getTimestamp()));
    }

    @Override
    public Account getAccount(Long recvWindow, Long timestamp) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getAccount(recvWindow, timestamp));
    }

    @Override
    public Account getAccount() {
        return this.getAccount(6000000L, System.currentTimeMillis());
    }

    @Override
    public List<Trade> getMyTrades(String symbol, Integer limit, Long fromId, Long recvWindow, Long timestamp) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getMyTrades(symbol, limit, fromId, recvWindow, timestamp));
    }

    @Override
    public List<Trade> getMyTrades(String symbol, Integer limit) {
        return this.getMyTrades(symbol, limit, null, 6000000L, System.currentTimeMillis());
    }

    @Override
    public List<Trade> getMyTrades(String symbol) {
        return this.getMyTrades(symbol, null, null, 6000000L, System.currentTimeMillis());
    }

    @Override
    public void withdraw(String asset, String address, String amount, String name) {
        BinanceApiServiceGenerator.executeSync(this.binanceApiService.withdraw(asset, address, amount, name, 6000000L, System.currentTimeMillis()));
    }

    @Override
    public DepositHistory getDepositHistory(String asset) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getDepositHistory(asset, 6000000L, System.currentTimeMillis()));
    }

    @Override
    public WithdrawHistory getWithdrawHistory(String asset) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getWithdrawHistory(asset, 6000000L, System.currentTimeMillis()));
    }

    @Override
    public DepositAddress getDepositAddress(String asset) {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.getDepositAddress(asset, 6000000L, System.currentTimeMillis()));
    }

    @Override
    public String startUserDataStream() {
        return BinanceApiServiceGenerator.executeSync(this.binanceApiService.startUserDataStream()).toString();
    }

    @Override
    public void keepAliveUserDataStream(String listenKey) {
        BinanceApiServiceGenerator.executeSync(this.binanceApiService.keepAliveUserDataStream(listenKey));
    }

    @Override
    public void closeUserDataStream(String listenKey) {
        BinanceApiServiceGenerator.executeSync(this.binanceApiService.closeAliveUserDataStream(listenKey));
    }
}

