/*
 * Decompiled with CFR 0.152.
 */
package com.binance.api.client.domain.event;

import com.binance.api.client.domain.event.CandlestickEvent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class CandlestickEventSerializer
extends JsonSerializer<CandlestickEvent> {
    public void serialize(CandlestickEvent candlestickEvent, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("e", candlestickEvent.getEventType());
        gen.writeNumberField("E", candlestickEvent.getEventTime());
        gen.writeStringField("s", candlestickEvent.getSymbol());
        gen.writeObjectFieldStart("k");
        gen.writeNumberField("t", candlestickEvent.getOpenTime().longValue());
        gen.writeNumberField("T", candlestickEvent.getCloseTime().longValue());
        gen.writeStringField("i", candlestickEvent.getIntervalId());
        gen.writeNumberField("f", candlestickEvent.getFirstTradeId().longValue());
        gen.writeNumberField("L", candlestickEvent.getLastTradeId().longValue());
        gen.writeStringField("o", candlestickEvent.getOpen());
        gen.writeStringField("c", candlestickEvent.getClose());
        gen.writeStringField("h", candlestickEvent.getHigh());
        gen.writeStringField("l", candlestickEvent.getLow());
        gen.writeStringField("v", candlestickEvent.getVolume());
        gen.writeNumberField("n", candlestickEvent.getNumberOfTrades().longValue());
        gen.writeBooleanField("x", candlestickEvent.getBarFinal().booleanValue());
        gen.writeStringField("q", candlestickEvent.getQuoteAssetVolume());
        gen.writeStringField("V", candlestickEvent.getTakerBuyBaseAssetVolume());
        gen.writeStringField("Q", candlestickEvent.getTakerBuyQuoteAssetVolume());
        gen.writeEndObject();
    }
}

