/*
 * Decompiled with CFR 0.152.
 */
package com.acutecoder.pdf.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import com.acutecoder.pdf.PdfDocumentProperties;
import com.acutecoder.pdf.PdfListener;
import com.acutecoder.pdf.PdfViewer;
import com.acutecoder.pdf.ui.ExtensionsKt;
import com.acutecoder.pdf.ui.PdfToolBar;
import com.acutecoder.pdf.ui.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0002HIB'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020:2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<2\b\b\u0002\u0010=\u001a\u00020\u0015H\u0007J)\u0010>\u001a\u00020\u001c2!\u0010?\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001c0\u0018J)\u0010@\u001a\u00020\u001c2!\u0010?\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001c0\u0018J\u001a\u0010A\u001a\u00020\u001c2\b\b\u0001\u0010B\u001a\u00020\u00072\b\b\u0001\u0010C\u001a\u00020\u0007J\b\u0010D\u001a\u00020\u001cH\u0002J\b\u0010E\u001a\u00020\u001cH\u0002J\b\u0010F\u001a\u00020\u001cH\u0002J\u0010\u0010G\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002R\u001a\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0018\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010\u0016\u001a#\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001c0\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010\u001b\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001f\"\u0004\b#\u0010!R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)R\u001a\u0010-\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001f\"\u0004\b/\u0010!R\u0011\u00100\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006J"}, d2={"Lcom/acutecoder/pdf/ui/PdfScrollBar;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "rootVertical", "Landroid/view/View;", "kotlin.jvm.PlatformType", "Landroid/view/View;", "rootHorizontal", "root", "timer", "Ljava/util/Timer;", "timerTask", "Ljava/util/TimerTask;", "isSetupDone", "", "scrollModeChangeListeners", "", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "isHorizontalScroll", "", "useVerticalScrollBarForHorizontalMode", "getUseVerticalScrollBarForHorizontalMode", "()Z", "setUseVerticalScrollBarForHorizontalMode", "(Z)V", "value", "setHorizontalScroll", "hideDelayMillis", "", "getHideDelayMillis", "()J", "setHideDelayMillis", "(J)V", "animationDuration", "getAnimationDuration", "setAnimationDuration", "interactiveScrolling", "getInteractiveScrolling", "setInteractiveScrolling", "pageNumberInfo", "Landroid/widget/TextView;", "getPageNumberInfo", "()Landroid/widget/TextView;", "dragHandle", "Landroid/widget/ImageView;", "getDragHandle", "()Landroid/widget/ImageView;", "setupWith", "pdfViewer", "Lcom/acutecoder/pdf/PdfViewer;", "toolBar", "Lcom/acutecoder/pdf/ui/PdfToolBar;", "force", "addScrollModeChangeListener", "listener", "removeScrollModeChangeListener", "setContentColor", "contentColor", "handleColor", "startTimer", "animateShow", "animateHide", "applyScrollMode", "DragListenerX", "DragListenerY", "ui_release"})
@SourceDebugExtension(value={"SMAP\nPdfScrollBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PdfScrollBar.kt\ncom/acutecoder/pdf/ui/PdfScrollBar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,326:1\n1863#2,2:327\n*S KotlinDebug\n*F\n+ 1 PdfScrollBar.kt\ncom/acutecoder/pdf/ui/PdfScrollBar\n*L\n236#1:327,2\n*E\n"})
public final class PdfScrollBar
extends FrameLayout {
    @SuppressLint(value={"InflateParams"})
    private final View rootVertical;
    @SuppressLint(value={"InflateParams"})
    private final View rootHorizontal;
    private View root;
    @NotNull
    private final Timer timer;
    @Nullable
    private TimerTask timerTask;
    private boolean isSetupDone;
    @NotNull
    private final List<Function1<Boolean, Unit>> scrollModeChangeListeners;
    private boolean useVerticalScrollBarForHorizontalMode;
    private boolean isHorizontalScroll;
    private long hideDelayMillis;
    private long animationDuration;
    private boolean interactiveScrolling;

    @JvmOverloads
    public PdfScrollBar(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.rootVertical = LayoutInflater.from((Context)context).inflate(R.layout.pdf_scrollbar_vertical, null);
        this.rootHorizontal = LayoutInflater.from((Context)context).inflate(R.layout.pdf_scrollbar_horizontal, null);
        this.root = this.rootVertical;
        this.timer = new Timer();
        this.scrollModeChangeListeners = new ArrayList();
        this.hideDelayMillis = 2000L;
        this.animationDuration = 250L;
        this.interactiveScrolling = true;
        this.addView(this.root);
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet it = attributeSet;
            boolean bl = false;
            TypedArray typedArray = context.obtainStyledAttributes(it, R.styleable.PdfScrollBar, defStyleAttr, 0);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
            TypedArray typedArray2 = typedArray;
            int contentColor = typedArray2.getColor(R.styleable.PdfScrollBar_contentColor, -16777216);
            int handleColor = typedArray2.getColor(R.styleable.PdfScrollBar_handleColor, -921103);
            boolean useVerticalScrollBarForHorizontalMode = typedArray2.getBoolean(R.styleable.PdfScrollBar_useVerticalScrollBarForHorizontalMode, this.useVerticalScrollBarForHorizontalMode);
            this.setContentColor(contentColor, handleColor);
            this.useVerticalScrollBarForHorizontalMode = useVerticalScrollBarForHorizontalMode;
            typedArray2.recycle();
        }
        if (this.isInEditMode()) {
            this.getPageNumberInfo().setText((CharSequence)"1/3");
        } else {
            this.setVisibility(8);
        }
    }

    public /* synthetic */ PdfScrollBar(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final boolean getUseVerticalScrollBarForHorizontalMode() {
        return this.useVerticalScrollBarForHorizontalMode;
    }

    public final void setUseVerticalScrollBarForHorizontalMode(boolean bl) {
        this.useVerticalScrollBarForHorizontalMode = bl;
    }

    public final boolean isHorizontalScroll() {
        return this.isHorizontalScroll;
    }

    private final void setHorizontalScroll(boolean value) {
        boolean newValue;
        boolean bl = newValue = value && !this.useVerticalScrollBarForHorizontalMode;
        if (this.isHorizontalScroll == newValue) {
            return;
        }
        this.isHorizontalScroll = newValue;
        this.applyScrollMode(newValue);
    }

    public final long getHideDelayMillis() {
        return this.hideDelayMillis;
    }

    public final void setHideDelayMillis(long l) {
        this.hideDelayMillis = l;
    }

    public final long getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(long l) {
        this.animationDuration = l;
    }

    public final boolean getInteractiveScrolling() {
        return this.interactiveScrolling;
    }

    public final void setInteractiveScrolling(boolean bl) {
        this.interactiveScrolling = bl;
    }

    @NotNull
    public final TextView getPageNumberInfo() {
        View view = this.root.findViewById(R.id.page_number_info);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        return (TextView)view;
    }

    @NotNull
    public final ImageView getDragHandle() {
        View view = this.root.findViewById(R.id.drag_handle);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        return (ImageView)view;
    }

    @SuppressLint(value={"SetTextI18n", "ClickableViewAccessibility"})
    public final void setupWith(@NotNull PdfViewer pdfViewer, @Nullable PdfToolBar toolBar, boolean force) {
        Intrinsics.checkNotNullParameter((Object)pdfViewer, (String)"pdfViewer");
        if (this.isSetupDone && !force) {
            return;
        }
        this.isSetupDone = true;
        pdfViewer.post(() -> PdfScrollBar.setupWith$lambda$6(this, pdfViewer, toolBar));
    }

    public static /* synthetic */ void setupWith$default(PdfScrollBar pdfScrollBar, PdfViewer pdfViewer, PdfToolBar pdfToolBar, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            pdfToolBar = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        pdfScrollBar.setupWith(pdfViewer, pdfToolBar, bl);
    }

    public final void addScrollModeChangeListener(@NotNull Function1<? super Boolean, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.scrollModeChangeListeners.add(listener);
    }

    public final void removeScrollModeChangeListener(@NotNull Function1<? super Boolean, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.scrollModeChangeListeners.remove(listener);
    }

    public final void setContentColor(@ColorInt int contentColor, @ColorInt int handleColor) {
        this.getPageNumberInfo().setTextColor(contentColor);
        ExtensionsKt.setBgTintModes((View)this.getPageNumberInfo(), handleColor);
        ExtensionsKt.setTintModes(this.getDragHandle(), contentColor);
        ExtensionsKt.setBgTintModes((View)this.getDragHandle(), handleColor);
    }

    private final void startTimer() {
        this.timerTask = new TimerTask(this){
            final /* synthetic */ PdfScrollBar this$0;
            {
                this.this$0 = $receiver;
            }

            public void run() {
                PdfScrollBar.access$animateHide(this.this$0);
            }
        };
        this.timer.schedule(this.timerTask, this.hideDelayMillis);
    }

    private final void animateShow() {
        this.post(() -> PdfScrollBar.animateShow$lambda$7(this));
    }

    private final void animateHide() {
        this.post(() -> PdfScrollBar.animateHide$lambda$8(this));
    }

    private final void applyScrollMode(boolean isHorizontalScroll) {
        View view = this.rootVertical;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"rootVertical");
        ExtensionsKt.removeFromParent(view);
        View view2 = this.rootHorizontal;
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"rootHorizontal");
        ExtensionsKt.removeFromParent(view2);
        this.root = isHorizontalScroll ? this.rootHorizontal : this.rootVertical;
        this.addView(this.root);
        Iterable $this$forEach$iv = this.scrollModeChangeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)isHorizontalScroll);
        }
    }

    @JvmOverloads
    public PdfScrollBar(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PdfScrollBar(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final Unit setupWith$lambda$6$lambda$1(PdfViewer $pdfViewer, PdfScrollBar this$0, float x) {
        float ratio = x / (float)($pdfViewer.getWidth() - this$0.getWidth());
        PdfViewer.scrollToRatio$default((PdfViewer)$pdfViewer, (float)ratio, (boolean)false, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit setupWith$lambda$6$lambda$2(PdfScrollBar this$0, PdfViewer $pdfViewer, float y) {
        TimerTask timerTask = this$0.timerTask;
        if (timerTask != null) {
            timerTask.cancel();
        }
        if (this$0.getVisibility() != 0) {
            this$0.animateShow();
        }
        this$0.startTimer();
        float ratio = this$0.getX() / (float)($pdfViewer.getWidth() - this$0.getWidth());
        int pageNumber = MathKt.roundToInt((float)ExtensionsKt.checkNaN(ratio * (float)($pdfViewer.getPagesCount() - 1), 1.0f)) + 1;
        this$0.getPageNumberInfo().setText((CharSequence)(pageNumber + "/" + $pdfViewer.getPagesCount()));
        return Unit.INSTANCE;
    }

    private static final Unit setupWith$lambda$6$lambda$3(PdfToolBar $toolBar, PdfViewer $pdfViewer, PdfScrollBar this$0, float y) {
        PdfToolBar pdfToolBar = $toolBar;
        float ratio = (y - (float)(pdfToolBar != null ? pdfToolBar.getHeight() : 0)) / (float)($pdfViewer.getHeight() - this$0.getHeight());
        PdfViewer.scrollToRatio$default((PdfViewer)$pdfViewer, (float)ratio, (boolean)false, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit setupWith$lambda$6$lambda$4(PdfScrollBar this$0, PdfToolBar $toolBar, PdfViewer $pdfViewer, float y) {
        TimerTask timerTask = this$0.timerTask;
        if (timerTask != null) {
            timerTask.cancel();
        }
        if (this$0.getVisibility() != 0) {
            this$0.animateShow();
        }
        this$0.startTimer();
        PdfToolBar pdfToolBar = $toolBar;
        float ratio = (y - (float)(pdfToolBar != null ? pdfToolBar.getHeight() : 0)) / (float)($pdfViewer.getHeight() - this$0.getHeight());
        int pageNumber = MathKt.roundToInt((float)ExtensionsKt.checkNaN(ratio * (float)($pdfViewer.getPagesCount() - 1), 1.0f)) + 1;
        this$0.getPageNumberInfo().setText((CharSequence)(pageNumber + "/" + $pdfViewer.getPagesCount()));
        return Unit.INSTANCE;
    }

    private static final Unit setupWith$lambda$6$lambda$5(PdfViewer $this$onReady) {
        Intrinsics.checkNotNullParameter((Object)$this$onReady, (String)"$this$onReady");
        $this$onReady.getUi().setViewerScrollbar(false);
        return Unit.INSTANCE;
    }

    private static final void setupWith$lambda$6(PdfScrollBar this$0, PdfViewer $pdfViewer, PdfToolBar $toolBar) {
        DragListenerX dragListenerX = this$0.new DragListenerX((View)this$0, $pdfViewer.getWidth(), (Function1<? super Float, Unit>)((Function1)arg_0 -> PdfScrollBar.setupWith$lambda$6$lambda$1($pdfViewer, this$0, arg_0)), (Function1<? super Float, Unit>)((Function1)arg_0 -> PdfScrollBar.setupWith$lambda$6$lambda$2(this$0, $pdfViewer, arg_0)));
        PdfToolBar pdfToolBar = $toolBar;
        DragListenerY dragListenerY = this$0.new DragListenerY((View)this$0, $pdfViewer.getHeight(), pdfToolBar != null ? pdfToolBar.getHeight() : 0, (Function1<? super Float, Unit>)((Function1)arg_0 -> PdfScrollBar.setupWith$lambda$6$lambda$3($toolBar, $pdfViewer, this$0, arg_0)), (Function1<? super Float, Unit>)((Function1)arg_0 -> PdfScrollBar.setupWith$lambda$6$lambda$4(this$0, $toolBar, $pdfViewer, arg_0)));
        $pdfViewer.onReady(PdfScrollBar::setupWith$lambda$6$lambda$5);
        this$0.rootHorizontal.findViewById(R.id.drag_handle).setOnTouchListener((View.OnTouchListener)dragListenerX);
        this$0.rootVertical.findViewById(R.id.drag_handle).setOnTouchListener((View.OnTouchListener)dragListenerY);
        $pdfViewer.addListener(new PdfListener(this$0, $pdfViewer, dragListenerY, dragListenerX, $toolBar){
            final /* synthetic */ PdfScrollBar this$0;
            final /* synthetic */ PdfViewer $pdfViewer;
            final /* synthetic */ DragListenerY $dragListenerY;
            final /* synthetic */ DragListenerX $dragListenerX;
            final /* synthetic */ PdfToolBar $toolBar;
            {
                this.this$0 = $receiver;
                this.$pdfViewer = $pdfViewer;
                this.$dragListenerY = $dragListenerY;
                this.$dragListenerX = $dragListenerX;
                this.$toolBar = $toolBar;
            }

            public void onPageChange(int pageNumber) {
                this.this$0.getPageNumberInfo().setText((CharSequence)(pageNumber + "/" + this.$pdfViewer.getPagesCount()));
            }

            public void onPageLoadStart() {
                this.this$0.setVisibility(8);
            }

            public void onPageLoadSuccess(int pagesCount) {
                this.this$0.getPageNumberInfo().setText((CharSequence)(this.$pdfViewer.getCurrentPage() + "/" + this.$pdfViewer.getPagesCount()));
                this.$pdfViewer.scrollTo(0);
            }

            public void onScrollChange(int currentOffset, int totalOffset, boolean isHorizontalScroll) {
                TimerTask timerTask = PdfScrollBar.access$getTimerTask$p(this.this$0);
                if (timerTask != null) {
                    timerTask.cancel();
                }
                if (this.this$0.getVisibility() != 0) {
                    PdfScrollBar.access$animateShow(this.this$0);
                }
                PdfScrollBar.access$startTimer(this.this$0);
                PdfScrollBar.access$setHorizontalScroll(this.this$0, isHorizontalScroll);
                this.this$0.getPageNumberInfo().setText((CharSequence)(this.$pdfViewer.getCurrentPage() + "/" + this.$pdfViewer.getPagesCount()));
                if (!this.$dragListenerY.isDragging() && !this.$dragListenerX.isDragging()) {
                    float ratio = (float)currentOffset / (float)totalOffset;
                    if (this.this$0.isHorizontalScroll()) {
                        float left = (float)(this.$pdfViewer.getWidth() - this.this$0.getWidth()) * ratio;
                        this.this$0.setTranslationX(left);
                        this.this$0.setTranslationY(0.0f);
                    } else {
                        float top = (float)(this.$pdfViewer.getHeight() - this.this$0.getHeight()) * ratio;
                        PdfToolBar pdfToolBar = this.$toolBar;
                        this.this$0.setTranslationY((float)(pdfToolBar != null ? pdfToolBar.getHeight() : 0) + top);
                        this.this$0.setTranslationX(0.0f);
                    }
                }
            }

            public void onPageLoadFailed(String errorMessage) {
                PdfListener.DefaultImpls.onPageLoadFailed((PdfListener)this, (String)errorMessage);
            }

            public void onScaleChange(float scale) {
                PdfListener.DefaultImpls.onScaleChange((PdfListener)this, (float)scale);
            }

            public void onSavePdf(byte[] pdfAsBytes) {
                PdfListener.DefaultImpls.onSavePdf((PdfListener)this, (byte[])pdfAsBytes);
            }

            public void onFindMatchStart() {
                PdfListener.DefaultImpls.onFindMatchStart((PdfListener)this);
            }

            public void onFindMatchChange(int current, int total) {
                PdfListener.DefaultImpls.onFindMatchChange((PdfListener)this, (int)current, (int)total);
            }

            public void onFindMatchComplete(boolean found) {
                PdfListener.DefaultImpls.onFindMatchComplete((PdfListener)this, (boolean)found);
            }

            public void onLoadProperties(PdfDocumentProperties properties) {
                PdfListener.DefaultImpls.onLoadProperties((PdfListener)this, (PdfDocumentProperties)properties);
            }

            public void onPasswordDialogChange(boolean isOpen) {
                PdfListener.DefaultImpls.onPasswordDialogChange((PdfListener)this, (boolean)isOpen);
            }

            public void onScrollModeChange(PdfViewer.PageScrollMode scrollMode) {
                PdfListener.DefaultImpls.onScrollModeChange((PdfListener)this, (PdfViewer.PageScrollMode)scrollMode);
            }

            public void onSpreadModeChange(PdfViewer.PageSpreadMode spreadMode) {
                PdfListener.DefaultImpls.onSpreadModeChange((PdfListener)this, (PdfViewer.PageSpreadMode)spreadMode);
            }

            public void onRotationChange(PdfViewer.PageRotation rotation) {
                PdfListener.DefaultImpls.onRotationChange((PdfListener)this, (PdfViewer.PageRotation)rotation);
            }

            public void onSingleClick() {
                PdfListener.DefaultImpls.onSingleClick((PdfListener)this);
            }

            public void onDoubleClick() {
                PdfListener.DefaultImpls.onDoubleClick((PdfListener)this);
            }

            public void onLongClick() {
                PdfListener.DefaultImpls.onLongClick((PdfListener)this);
            }

            public void onLinkClick(String link) {
                PdfListener.DefaultImpls.onLinkClick((PdfListener)this, (String)link);
            }

            public void onSnapChange(boolean snapPage) {
                PdfListener.DefaultImpls.onSnapChange((PdfListener)this, (boolean)snapPage);
            }

            public void onSinglePageArrangementChange(boolean requestedArrangement, boolean appliedArrangement) {
                PdfListener.DefaultImpls.onSinglePageArrangementChange((PdfListener)this, (boolean)requestedArrangement, (boolean)appliedArrangement);
            }

            public void onEditorHighlightColorChange(@ColorInt int highlightColor) {
                PdfListener.DefaultImpls.onEditorHighlightColorChange((PdfListener)this, (int)highlightColor);
            }

            public void onEditorShowAllHighlightsChange(boolean showAll) {
                PdfListener.DefaultImpls.onEditorShowAllHighlightsChange((PdfListener)this, (boolean)showAll);
            }

            public void onEditorHighlightThicknessChange(@IntRange(from=8L, to=24L) int thickness) {
                PdfListener.DefaultImpls.onEditorHighlightThicknessChange((PdfListener)this, (int)thickness);
            }

            public void onEditorFreeFontColorChange(@ColorInt int fontColor) {
                PdfListener.DefaultImpls.onEditorFreeFontColorChange((PdfListener)this, (int)fontColor);
            }

            public void onEditorFreeFontSizeChange(@IntRange(from=5L, to=100L) int fontSize) {
                PdfListener.DefaultImpls.onEditorFreeFontSizeChange((PdfListener)this, (int)fontSize);
            }

            public void onEditorInkColorChange(@ColorInt int color) {
                PdfListener.DefaultImpls.onEditorInkColorChange((PdfListener)this, (int)color);
            }

            public void onEditorInkThicknessChange(@IntRange(from=1L, to=20L) int thickness) {
                PdfListener.DefaultImpls.onEditorInkThicknessChange((PdfListener)this, (int)thickness);
            }

            public void onEditorInkOpacityChange(@IntRange(from=1L, to=100L) int opacity) {
                PdfListener.DefaultImpls.onEditorInkOpacityChange((PdfListener)this, (int)opacity);
            }

            public void onScaleLimitChange(@FloatRange(from=-4.0, to=10.0) float minPageScale, @FloatRange(from=-4.0, to=10.0) float maxPageScale, @FloatRange(from=-4.0, to=10.0) float defaultPageScale) {
                PdfListener.DefaultImpls.onScaleLimitChange((PdfListener)this, (float)minPageScale, (float)maxPageScale, (float)defaultPageScale);
            }

            public void onActualScaleLimitChange(@FloatRange(from=0.0, to=10.0) float minPageScale, @FloatRange(from=0.0, to=10.0) float maxPageScale, @FloatRange(from=0.0, to=10.0) float defaultPageScale) {
                PdfListener.DefaultImpls.onActualScaleLimitChange((PdfListener)this, (float)minPageScale, (float)maxPageScale, (float)defaultPageScale);
            }

            public void onAlignModeChange(PdfViewer.PageAlignMode requestedMode, PdfViewer.PageAlignMode appliedMode) {
                PdfListener.DefaultImpls.onAlignModeChange((PdfListener)this, (PdfViewer.PageAlignMode)requestedMode, (PdfViewer.PageAlignMode)appliedMode);
            }

            public void onScrollSpeedLimitChange(PdfViewer.ScrollSpeedLimit requestedLimit, PdfViewer.ScrollSpeedLimit appliedLimit) {
                PdfListener.DefaultImpls.onScrollSpeedLimitChange((PdfListener)this, (PdfViewer.ScrollSpeedLimit)requestedLimit, (PdfViewer.ScrollSpeedLimit)appliedLimit);
            }
        });
    }

    private static final void animateShow$lambda$7(PdfScrollBar this$0) {
        this$0.setVisibility(0);
        this$0.animate().alpha(1.0f).setDuration(this$0.animationDuration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this$0){
            final /* synthetic */ PdfScrollBar this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationEnd(Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                this.this$0.setAlpha(1.0f);
            }
        }).start();
    }

    private static final void animateHide$lambda$8(PdfScrollBar this$0) {
        this$0.animate().alpha(0.0f).setDuration(this$0.animationDuration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this$0){
            final /* synthetic */ PdfScrollBar this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationEnd(Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                this.this$0.setVisibility(8);
                this.this$0.setAlpha(0.0f);
            }
        }).start();
    }

    public static final /* synthetic */ void access$animateHide(PdfScrollBar $this) {
        $this.animateHide();
    }

    public static final /* synthetic */ TimerTask access$getTimerTask$p(PdfScrollBar $this) {
        return $this.timerTask;
    }

    public static final /* synthetic */ void access$animateShow(PdfScrollBar $this) {
        $this.animateShow();
    }

    public static final /* synthetic */ void access$setHorizontalScroll(PdfScrollBar $this, boolean value) {
        $this.setHorizontalScroll(value);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007\u0012!\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/acutecoder/pdf/ui/PdfScrollBar$DragListenerX;", "Landroid/view/View$OnTouchListener;", "targetView", "Landroid/view/View;", "parentWidth", "", "onScrollChange", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "x", "", "onUpdatePageInfoForNonInteractiveMode", "<init>", "(Lcom/acutecoder/pdf/ui/PdfScrollBar;Landroid/view/View;ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "isDragging", "", "()Z", "setDragging", "(Z)V", "dX", "onTouch", "view", "event", "Landroid/view/MotionEvent;", "ui_release"})
    public final class DragListenerX
    implements View.OnTouchListener {
        @NotNull
        private View targetView;
        private final int parentWidth;
        @NotNull
        private final Function1<Float, Unit> onScrollChange;
        @NotNull
        private final Function1<Float, Unit> onUpdatePageInfoForNonInteractiveMode;
        private boolean isDragging;
        private float dX;

        public DragListenerX(View targetView, @NotNull int parentWidth, @NotNull Function1<? super Float, Unit> onScrollChange, Function1<? super Float, Unit> onUpdatePageInfoForNonInteractiveMode) {
            Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
            Intrinsics.checkNotNullParameter(onScrollChange, (String)"onScrollChange");
            Intrinsics.checkNotNullParameter(onUpdatePageInfoForNonInteractiveMode, (String)"onUpdatePageInfoForNonInteractiveMode");
            this.targetView = targetView;
            this.parentWidth = parentWidth;
            this.onScrollChange = onScrollChange;
            this.onUpdatePageInfoForNonInteractiveMode = onUpdatePageInfoForNonInteractiveMode;
        }

        public final boolean isDragging() {
            return this.isDragging;
        }

        public final void setDragging(boolean bl) {
            this.isDragging = bl;
        }

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouch(@NotNull View view, @NotNull MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            switch (event.getActionMasked()) {
                case 0: {
                    this.dX = this.targetView.getX() - event.getRawX();
                    this.isDragging = true;
                    break;
                }
                case 2: {
                    float x = RangesKt.coerceIn((float)(event.getRawX() + this.dX - (float)(PdfScrollBar.this.getWidth() / 2)), (float)0.0f, (float)((float)this.parentWidth - (float)PdfScrollBar.this.getWidth()));
                    this.targetView.setTranslationX(x);
                    if (PdfScrollBar.this.getInteractiveScrolling()) {
                        this.onScrollChange.invoke((Object)Float.valueOf(x));
                        break;
                    }
                    this.onUpdatePageInfoForNonInteractiveMode.invoke((Object)Float.valueOf(x));
                    break;
                }
                default: {
                    if (!PdfScrollBar.this.getInteractiveScrolling()) {
                        this.onScrollChange.invoke((Object)Float.valueOf(this.targetView.getTranslationX()));
                    }
                    this.isDragging = false;
                    PdfScrollBar.this.startTimer();
                    return false;
                }
            }
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012!\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\b\u0012!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/acutecoder/pdf/ui/PdfScrollBar$DragListenerY;", "Landroid/view/View$OnTouchListener;", "targetView", "Landroid/view/View;", "parentHeight", "", "topHeight", "onScrollChange", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "y", "", "onUpdatePageInfoForNonInteractiveMode", "<init>", "(Lcom/acutecoder/pdf/ui/PdfScrollBar;Landroid/view/View;IILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "isDragging", "", "()Z", "setDragging", "(Z)V", "dY", "onTouch", "view", "event", "Landroid/view/MotionEvent;", "ui_release"})
    public final class DragListenerY
    implements View.OnTouchListener {
        @NotNull
        private View targetView;
        private final int parentHeight;
        private final int topHeight;
        @NotNull
        private final Function1<Float, Unit> onScrollChange;
        @NotNull
        private final Function1<Float, Unit> onUpdatePageInfoForNonInteractiveMode;
        private boolean isDragging;
        private float dY;

        public DragListenerY(View targetView, int parentHeight, @NotNull int topHeight, @NotNull Function1<? super Float, Unit> onScrollChange, Function1<? super Float, Unit> onUpdatePageInfoForNonInteractiveMode) {
            Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
            Intrinsics.checkNotNullParameter(onScrollChange, (String)"onScrollChange");
            Intrinsics.checkNotNullParameter(onUpdatePageInfoForNonInteractiveMode, (String)"onUpdatePageInfoForNonInteractiveMode");
            this.targetView = targetView;
            this.parentHeight = parentHeight;
            this.topHeight = topHeight;
            this.onScrollChange = onScrollChange;
            this.onUpdatePageInfoForNonInteractiveMode = onUpdatePageInfoForNonInteractiveMode;
        }

        public final boolean isDragging() {
            return this.isDragging;
        }

        public final void setDragging(boolean bl) {
            this.isDragging = bl;
        }

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouch(@NotNull View view, @NotNull MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            switch (event.getActionMasked()) {
                case 0: {
                    this.dY = this.targetView.getY() - event.getRawY();
                    this.isDragging = true;
                    break;
                }
                case 2: {
                    float y = RangesKt.coerceIn((float)(event.getRawY() + this.dY - (float)(PdfScrollBar.this.getHeight() / 2)), (float)this.topHeight, (float)((float)this.topHeight + (float)this.parentHeight - (float)PdfScrollBar.this.getHeight()));
                    this.targetView.setTranslationY(y);
                    if (PdfScrollBar.this.getInteractiveScrolling()) {
                        this.onScrollChange.invoke((Object)Float.valueOf(y));
                        break;
                    }
                    this.onUpdatePageInfoForNonInteractiveMode.invoke((Object)Float.valueOf(y));
                    break;
                }
                default: {
                    if (!PdfScrollBar.this.getInteractiveScrolling()) {
                        this.onScrollChange.invoke((Object)Float.valueOf(this.targetView.getTranslationY()));
                    }
                    this.isDragging = false;
                    PdfScrollBar.this.startTimer();
                    return false;
                }
            }
            return true;
        }
    }
}

