/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib.pgn;

import com.github.bhlangonijr.chesslib.game.Event;
import com.github.bhlangonijr.chesslib.game.Game;
import com.github.bhlangonijr.chesslib.game.GameFactory;
import com.github.bhlangonijr.chesslib.game.GameResult;
import com.github.bhlangonijr.chesslib.game.Player;
import com.github.bhlangonijr.chesslib.game.PlayerType;
import com.github.bhlangonijr.chesslib.game.Round;
import com.github.bhlangonijr.chesslib.game.Termination;
import com.github.bhlangonijr.chesslib.game.TimeControl;
import com.github.bhlangonijr.chesslib.pgn.PgnException;
import com.github.bhlangonijr.chesslib.pgn.PgnProperty;
import com.github.bhlangonijr.chesslib.util.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;

public class GameLoader {
    public static Game loadNextGame(Iterator<String> iterator) {
        Event event = null;
        Round round = null;
        Game game = null;
        Player whitePlayer = null;
        Player blackPlayer = null;
        StringBuilder moveText = null;
        boolean moveTextParsing = false;
        block52: while (iterator.hasNext()) {
            String line = iterator.next();
            try {
                line = line.trim();
                if (line.startsWith("\ufeff")) {
                    line = line.substring(1);
                }
                if (PgnProperty.isProperty(line)) {
                    String tag;
                    PgnProperty p = PgnProperty.parsePgnProperty(line);
                    if (p == null) continue;
                    switch (tag = p.name.toLowerCase().trim()) {
                        case "event": {
                            if (moveTextParsing && game != null && game.getHalfMoves().size() == 0) {
                                GameLoader.setMoveText(game, moveText);
                            }
                            game = null;
                            round = null;
                            whitePlayer = null;
                            blackPlayer = null;
                            if (event == null) {
                                event = GameFactory.newEvent(p.value);
                            }
                            moveText = new StringBuilder();
                            break;
                        }
                        case "site": {
                            if (event == null) continue block52;
                            event.setSite(p.value);
                            break;
                        }
                        case "date": {
                            if (event == null) continue block52;
                            event.setStartDate(p.value);
                            break;
                        }
                        case "round": {
                            if (event == null) continue block52;
                            int r = 1;
                            try {
                                r = Integer.parseInt(p.value);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            r = Math.max(0, r);
                            round = event.getRound().get(r);
                            if (round != null) continue block52;
                            round = GameFactory.newRound(event, r);
                            event.getRound().put(r, round);
                            break;
                        }
                        case "white": {
                            if (round == null) {
                                round = GameFactory.newRound(event, 1);
                                event.getRound().put(1, round);
                            }
                            if (game == null) {
                                game = GameFactory.newGame(UUID.randomUUID().toString(), round);
                                game.setDate(event.getStartDate());
                                round.getGame().add(game);
                            }
                            Player player = GameFactory.newPlayer(PlayerType.HUMAN, p.value);
                            player.setId(p.value);
                            player.setDescription(p.value);
                            game.setWhitePlayer(player);
                            whitePlayer = player;
                            break;
                        }
                        case "black": {
                            if (round == null) {
                                round = GameFactory.newRound(event, 1);
                                event.getRound().put(1, round);
                            }
                            if (game == null) {
                                game = GameFactory.newGame(UUID.randomUUID().toString(), round);
                                game.setDate(event.getStartDate());
                                round.getGame().add(game);
                            }
                            Player player = GameFactory.newPlayer(PlayerType.HUMAN, p.value);
                            player.setId(p.value);
                            player.setDescription(p.value);
                            game.setBlackPlayer(player);
                            blackPlayer = player;
                            break;
                        }
                        case "result": {
                            if (game == null) continue block52;
                            GameResult r = GameResult.fromNotation(p.value);
                            game.setResult(r);
                            break;
                        }
                        case "plycount": {
                            if (game == null) continue block52;
                            game.setPlyCount(p.value);
                            break;
                        }
                        case "termination": {
                            if (game == null) continue block52;
                            try {
                                game.setTermination(Termination.fromValue(p.value.toUpperCase()));
                            }
                            catch (Exception e1) {
                                game.setTermination(Termination.UNTERMINATED);
                            }
                            break;
                        }
                        case "timecontrol": {
                            if (event == null || event.getTimeControl() != null) continue block52;
                            try {
                                event.setTimeControl(TimeControl.parseFromString(p.value.toUpperCase()));
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case "annotator": {
                            if (game == null) continue block52;
                            game.setAnnotator(p.value);
                            break;
                        }
                        case "fen": {
                            if (game == null) continue block52;
                            game.setFen(p.value);
                            break;
                        }
                        case "eco": {
                            if (game == null) continue block52;
                            game.setEco(p.value);
                            break;
                        }
                        case "opening": {
                            if (game == null) continue block52;
                            game.setOpening(p.value);
                            break;
                        }
                        case "variation": {
                            if (game == null) continue block52;
                            game.setVariation(p.value);
                            break;
                        }
                        case "whiteelo": {
                            if (whitePlayer == null) continue block52;
                            try {
                                whitePlayer.setElo(Integer.parseInt(p.value));
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case "blackelo": {
                            if (blackPlayer == null) continue block52;
                            try {
                                blackPlayer.setElo(Integer.parseInt(p.value));
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        default: {
                            if (game == null) continue block52;
                            if (game.getProperty() == null) {
                                game.setProperty(new HashMap<String, String>());
                            }
                            game.getProperty().put(p.name, p.value);
                        }
                    }
                    continue;
                }
                if (line.trim().equals("") || moveText == null) continue;
                moveText.append(line);
                moveText.append('\n');
                moveTextParsing = true;
                if (!line.endsWith("1-0") && !line.endsWith("0-1") && !line.endsWith("1/2-1/2") && !line.endsWith("*")) continue;
                if (game == null) break;
                GameLoader.setMoveText(game, moveText);
                break;
            }
            catch (Exception e) {
                String name = "";
                int r = 0;
                try {
                    r = round.getNumber();
                    name = event.getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new PgnException("Error parsing PGN[" + r + ", " + name + "]: ", e);
            }
        }
        return game;
    }

    private static void setMoveText(Game game, StringBuilder moveText) throws Exception {
        StringUtil.replaceAll(moveText, "1-0", "");
        StringUtil.replaceAll(moveText, "0-1", "");
        StringUtil.replaceAll(moveText, "1/2-1/2", "");
        StringUtil.replaceAll(moveText, "*", "");
        game.setMoveText(moveText);
        game.loadMoveText(moveText);
        game.setPlyCount(game.getHalfMoves().size() + "");
    }
}

