/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib.move;

import com.github.bhlangonijr.chesslib.Bitboard;
import com.github.bhlangonijr.chesslib.Board;
import com.github.bhlangonijr.chesslib.File;
import com.github.bhlangonijr.chesslib.Piece;
import com.github.bhlangonijr.chesslib.PieceType;
import com.github.bhlangonijr.chesslib.Rank;
import com.github.bhlangonijr.chesslib.Side;
import com.github.bhlangonijr.chesslib.Square;
import com.github.bhlangonijr.chesslib.move.Move;
import com.github.bhlangonijr.chesslib.move.MoveConversionException;
import com.github.bhlangonijr.chesslib.util.StringUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public class MoveList
extends LinkedList<Move>
implements List<Move> {
    private static final long serialVersionUID = -6204280556340150806L;
    private static final ThreadLocal<Board> boardHolder = ThreadLocal.withInitial(Board::new);
    private static final Move nullMove = new Move(Square.NONE, Square.NONE);
    private final String startFEN;
    private boolean dirty = true;
    private String[] sanArray;
    private String[] fanArray;
    private int parent;
    private int index;

    public MoveList() {
        this("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
    }

    public MoveList(String initialFEN) {
        this.startFEN = initialFEN;
    }

    public MoveList(MoveList halfMoves) {
        this(halfMoves.getStartFen());
        super.addAll(halfMoves);
    }

    protected static Board getBoard() {
        return boardHolder.get();
    }

    protected static String encodeToSan(Board board, Move move) throws MoveConversionException {
        return MoveList.encode(board, move, Piece::getSanSymbol);
    }

    protected static String encodeToFan(Board board, Move move) throws MoveConversionException {
        return MoveList.encode(board, move, Piece::getFanSymbol);
    }

    protected static String encode(Board board, Move move, Function<Piece, String> notation) throws MoveConversionException {
        boolean isCapture;
        int delta;
        StringBuilder san = new StringBuilder();
        Piece piece = board.getPiece(move.getFrom());
        if (piece.getPieceType().equals((Object)PieceType.KING) && Math.abs(delta = move.getTo().getFile().ordinal() - move.getFrom().getFile().ordinal()) >= 2) {
            if (!board.doMove(move, true)) {
                throw new MoveConversionException("Invalid move [" + move + "] for current setup: " + board.getFen());
            }
            san.append(delta > 0 ? "O-O" : "O-O-O");
            MoveList.addCheckFlag(board, san);
            return san.toString();
        }
        boolean pawnMove = piece.getPieceType().equals((Object)PieceType.PAWN) && move.getFrom().getFile().equals((Object)move.getTo().getFile());
        boolean ambResolved = false;
        san.append(notation.apply(piece));
        if (!pawnMove) {
            long amb = board.squareAttackedByPieceType(move.getTo(), board.getSideToMove(), piece.getPieceType());
            if ((amb &= move.getFrom().getBitboard() ^ 0xFFFFFFFFFFFFFFFFL) != 0L) {
                List<Square> fromList = Bitboard.bbToSquareList(amb);
                for (Square from : fromList) {
                    if (board.isMoveLegal(new Move(from, move.getTo()), false)) continue;
                    amb ^= from.getBitboard();
                }
            }
            if (amb != 0L) {
                if ((Bitboard.getFilebb(move.getFrom()) & amb) == 0L) {
                    san.append(move.getFrom().getFile().getNotation().toLowerCase());
                } else if ((Bitboard.getRankbb(move.getFrom()) & amb) == 0L) {
                    san.append(move.getFrom().getRank().getNotation().toLowerCase());
                } else {
                    san.append(move.getFrom().toString().toLowerCase());
                }
                ambResolved = true;
            }
        }
        if (!board.doMove(move, true)) {
            throw new MoveConversionException("Invalid move [" + move + "] for current setup: " + board.getFen());
        }
        Piece captured = board.getBackup().getLast().getCapturedPiece();
        boolean bl = isCapture = !captured.equals((Object)Piece.NONE);
        if (isCapture) {
            if (!ambResolved && piece.getPieceType().equals((Object)PieceType.PAWN)) {
                san.append(move.getFrom().getFile().getNotation().toLowerCase());
            }
            san.append("x");
        }
        san.append(move.getTo().toString().toLowerCase());
        if (!move.getPromotion().equals((Object)Piece.NONE)) {
            san.append("=");
            san.append(notation.apply(move.getPromotion()));
        }
        MoveList.addCheckFlag(board, san);
        return san.toString();
    }

    private static void addCheckFlag(Board board, StringBuilder san) {
        if (board.isKingAttacked()) {
            if (board.isMated()) {
                san.append("#");
            } else {
                san.append("+");
            }
        }
    }

    private static long findLegalSquares(Board board, Square to, Piece promotion, long pieces) {
        long result = 0L;
        if (pieces != 0L) {
            for (Square sqSource : Bitboard.bbToSquareList(pieces)) {
                Move move = new Move(sqSource, to, promotion);
                if (!board.isMoveLegal(move, true)) continue;
                result |= sqSource.getBitboard();
                break;
            }
        }
        return result;
    }

    public static MoveList createMoveListFrom(MoveList startMoves, int finalIndex) throws MoveConversionException {
        String fen = null;
        Board b = MoveList.getBoard();
        if (!b.getFen().equals(startMoves.getStartFen())) {
            b.loadFromFen(startMoves.getStartFen());
        }
        int i = 0;
        for (Move move : startMoves) {
            ++i;
            if (!b.doMove(move, false)) {
                throw new MoveConversionException("Couldn't parse SAN to MoveList: Illegal move: " + move + " [" + move.toString() + "] on " + b.getFen());
            }
            if (i < finalIndex) continue;
            fen = b.getFen();
            break;
        }
        if (fen == null) {
            fen = b.getFen();
        }
        return new MoveList(fen);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void add(int arg0, Move arg1) {
        this.dirty = true;
        super.add(arg0, arg1);
    }

    @Override
    public boolean add(Move arg0) {
        this.dirty = true;
        return super.add(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends Move> arg0) {
        this.dirty = true;
        return super.addAll(arg0);
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends Move> arg1) {
        this.dirty = true;
        return super.addAll(arg0, arg1);
    }

    @Override
    public Move removeFirst() {
        this.dirty = true;
        return (Move)super.removeFirst();
    }

    @Override
    public Move removeLast() {
        this.dirty = true;
        return (Move)super.removeLast();
    }

    @Override
    public boolean remove(Object o) {
        this.dirty = true;
        return super.remove(o);
    }

    @Override
    public Move remove(int index) {
        this.dirty = true;
        return (Move)super.remove(index);
    }

    @Override
    public void clear() {
        this.dirty = true;
        this.sanArray = null;
        this.fanArray = null;
        super.clear();
    }

    public String toSan() throws MoveConversionException {
        return this.toStringWithoutMoveNumbers(this.toSanArray());
    }

    public String toSanWithMoveNumbers() throws MoveConversionException {
        return this.toStringWithMoveNumbers(this.toSanArray());
    }

    public String toFan() throws MoveConversionException {
        return this.toStringWithoutMoveNumbers(this.toFanArray());
    }

    public String toFanWithMoveNumbers() throws MoveConversionException {
        return this.toStringWithMoveNumbers(this.toFanArray());
    }

    private String toStringWithoutMoveNumbers(String[] moveArray) throws MoveConversionException {
        StringBuilder sb = new StringBuilder();
        for (String move : moveArray) {
            sb.append(move);
            sb.append(" ");
        }
        return sb.toString();
    }

    private String toStringWithMoveNumbers(String[] moveArray) throws MoveConversionException {
        StringBuilder sb = new StringBuilder();
        for (int halfMove = 0; halfMove < moveArray.length; ++halfMove) {
            if (halfMove % 2 == 0) {
                sb.append(halfMove / 2 + 1).append(". ");
            }
            sb.append(moveArray[halfMove]).append(" ");
        }
        return sb.toString();
    }

    public String[] toSanArray() throws MoveConversionException {
        if (!this.dirty && this.sanArray != null) {
            return this.sanArray;
        }
        this.updateSanArray();
        this.updateFanArray();
        return this.sanArray;
    }

    public String[] toFanArray() throws MoveConversionException {
        if (!this.dirty && this.fanArray != null) {
            return this.fanArray;
        }
        this.updateSanArray();
        this.updateFanArray();
        return this.fanArray;
    }

    private void updateSanArray() throws MoveConversionException {
        this.sanArray = new String[this.size()];
        Board b = MoveList.getBoard();
        if (!b.getFen().equals(this.getStartFen())) {
            b.loadFromFen(this.getStartFen());
        }
        int i = 0;
        for (Move move : this) {
            this.sanArray[i++] = MoveList.encodeToSan(b, move);
        }
        this.dirty = false;
    }

    private void updateFanArray() throws MoveConversionException {
        this.fanArray = new String[this.size()];
        Board b = MoveList.getBoard();
        if (!b.getFen().equals(this.getStartFen())) {
            b.loadFromFen(this.getStartFen());
        }
        int i = 0;
        for (Move move : this) {
            this.fanArray[i++] = MoveList.encodeToFan(b, move);
        }
        this.dirty = false;
    }

    public String getStartFen() {
        return this.startFEN;
    }

    public synchronized void loadFromText(String text) throws MoveConversionException {
        Board b = MoveList.getBoard();
        if (!b.getFen().equals(this.getStartFen())) {
            b.loadFromFen(this.getStartFen());
        }
        try {
            Side side = b.getSideToMove();
            text = StringUtil.normalize(text);
            String[] m = text.split(" ");
            int i = 0;
            for (String strMove : m) {
                Move move = new Move(strMove, side);
                this.add(i++, move);
                side = side.flip();
            }
        }
        catch (Exception e) {
            throw new MoveConversionException("Couldn't parse text to MoveList: " + e.getMessage());
        }
    }

    public void addSanMove(String san) throws MoveConversionException {
        this.addSanMove(san, false, true);
    }

    public void addSanMove(String san, boolean replay, boolean fullValidation) throws MoveConversionException {
        Move move;
        Board b = MoveList.getBoard();
        if (replay) {
            if (!b.getFen().equals(this.getStartFen())) {
                b.loadFromFen(this.getStartFen());
            }
            for (Move move2 : this) {
                if (b.doMove(move2, false)) continue;
                throw new MoveConversionException("Couldn't parse SAN to MoveList: Illegal move: " + move2 + " [" + move2.toString() + "] on " + b.getFen());
            }
        }
        if ((move = this.decodeSan(b, san, b.getSideToMove())) == nullMove) {
            return;
        }
        move.setSan(san);
        if (!b.doMove(move, fullValidation)) {
            throw new MoveConversionException("Couldn't parse SAN to MoveList: Illegal move: " + move + " [" + san + "] on " + b.getFen());
        }
        this.add(this.size(), move);
    }

    public void loadFromSan(String text) throws MoveConversionException {
        Board b = MoveList.getBoard();
        if (!b.getFen().equals(this.getStartFen())) {
            b.loadFromFen(this.getStartFen());
        }
        try {
            String[] m;
            text = StringUtil.normalize(text);
            for (String strMove : m = text.split(" ")) {
                if (strMove.startsWith("$") || strMove.contains("...")) continue;
                if (strMove.contains(".")) {
                    strMove = StringUtil.afterSequence(strMove, ".");
                }
                if (strMove.trim().equals("")) continue;
                this.addSanMove(strMove);
            }
        }
        catch (MoveConversionException e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new MoveConversionException("Couldn't parse SAN to MoveList: " + e2.getMessage());
        }
    }

    protected Move decodeSan(Board board, String san, Side side) throws MoveConversionException {
        Piece promotion;
        Square to;
        if (san.equalsIgnoreCase("Z0")) {
            return nullMove;
        }
        san = this.normalizeSan(san);
        String strPromotion = StringUtil.afterSequence(san, "=", 1);
        char lastChar = (san = StringUtil.beforeSequence(san, "=")).charAt(san.length() - 1);
        if (Character.isLetter(lastChar) && Character.toUpperCase(lastChar) != 'O') {
            san = san.substring(0, san.length() - 1);
            strPromotion = lastChar + "";
        }
        if (san.equals("O-O") || san.equals("O-O-O")) {
            if (san.equals("O-O")) {
                return board.getContext().getoo(side);
            }
            return board.getContext().getooo(side);
        }
        if (san.length() == 3 && Character.isUpperCase(san.charAt(2))) {
            strPromotion = san.substring(2, 3);
            san = san.substring(0, 2);
        }
        Square from = Square.NONE;
        try {
            to = Square.valueOf(StringUtil.lastSequence(san.toUpperCase(), 2));
        }
        catch (Exception e) {
            throw new MoveConversionException("Coudn't parse destination square[" + san + "]: " + san.toUpperCase());
        }
        Piece piece = strPromotion.equals("") ? Piece.NONE : (promotion = Piece.fromFenSymbol(side.equals((Object)Side.WHITE) ? strPromotion.toUpperCase() : strPromotion.toLowerCase()));
        if (san.length() == 2) {
            int f;
            long mask = Bitboard.getBbtable(to) - 1L;
            long xfrom = (side.equals((Object)Side.WHITE) ? mask : mask ^ 0xFFFFFFFFFFFFFFFFL) & Bitboard.getFilebb(to) & board.getBitboard(Piece.make(side, PieceType.PAWN));
            int n = f = side.equals((Object)Side.BLACK) ? Bitboard.bitScanForward(xfrom) : Bitboard.bitScanReverse(xfrom);
            if (f >= 0 && f <= 63) {
                from = Square.squareAt(f);
            }
        } else {
            String strFrom;
            String string = strFrom = san.contains("x") ? StringUtil.beforeSequence(san, "x") : san.substring(0, san.length() - 2);
            if (strFrom == null || strFrom.length() == 0 || strFrom.length() > 3) {
                throw new MoveConversionException("Couldn't parse 'from' square " + san + ": Too many/few characters.");
            }
            PieceType fromPiece = PieceType.PAWN;
            if (Character.isUpperCase(strFrom.charAt(0))) {
                fromPiece = PieceType.fromSanSymbol(strFrom.charAt(0) + "");
            }
            if (strFrom.length() == 3) {
                from = Square.valueOf(strFrom.substring(1, 3).toUpperCase());
            } else {
                String location = "";
                if (strFrom.length() == 2) {
                    if (Character.isUpperCase(strFrom.charAt(0))) {
                        location = strFrom.substring(1, 2);
                    } else {
                        location = strFrom.substring(0, 2);
                        from = Square.valueOf(location.toUpperCase());
                    }
                } else if (Character.isLowerCase(strFrom.charAt(0))) {
                    location = strFrom;
                }
                if (location.length() < 2) {
                    long xfrom = board.squareAttackedByPieceType(to, board.getSideToMove(), fromPiece);
                    if (location.length() > 0) {
                        if (Character.isDigit(location.charAt(0))) {
                            int irank = Integer.parseInt(location);
                            if (irank < 1 || irank > 8) {
                                throw new MoveConversionException("Couldn't parse rank: " + location);
                            }
                            Rank rank = Rank.allRanks[irank - 1];
                            xfrom &= Bitboard.getRankbb(rank);
                        } else {
                            try {
                                File file = File.valueOf("FILE_" + location.toUpperCase());
                                xfrom &= Bitboard.getFilebb(file);
                            }
                            catch (Exception e) {
                                throw new MoveConversionException("Couldn't parse file: " + location);
                            }
                        }
                    }
                    if (xfrom != 0L) {
                        int f;
                        if (!Bitboard.hasOnly1Bit(xfrom)) {
                            xfrom = MoveList.findLegalSquares(board, to, promotion, xfrom);
                        }
                        if ((f = Bitboard.bitScanForward(xfrom)) >= 0 && f <= 63) {
                            from = Square.squareAt(f);
                        }
                    }
                }
            }
        }
        if (from.equals((Object)Square.NONE)) {
            throw new MoveConversionException("Couldn't parse 'from' square " + san + " to setup: " + board.getFen());
        }
        return new Move(from, to, promotion);
    }

    public String getFen(int atMoveIndex) {
        return this.getFen(atMoveIndex, true);
    }

    public String getFen(int atMoveIndex, boolean includeCounters) {
        Board b = MoveList.getBoard();
        if (!b.getFen().equals(this.getStartFen())) {
            b.loadFromFen(this.getStartFen());
        }
        int i = 0;
        for (Move move : this) {
            ++i;
            if (!b.doMove(move, false)) {
                throw new IllegalArgumentException("Couldn't parse SAN to MoveList: Illegal move: " + move + " [" + move.toString() + "] on " + b.getFen(includeCounters));
            }
            if (i < atMoveIndex) continue;
            return b.getFen(includeCounters);
        }
        return null;
    }

    public String getFen() {
        return this.getFen(this.size());
    }

    public int getParent() {
        return this.parent;
    }

    public void setParent(int parent) {
        this.parent = parent;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Move move : this) {
            b.append(move.toString());
            b.append(" ");
        }
        return b.toString().trim();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.toString().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MoveList) {
            MoveList l = (MoveList)obj;
            if (l.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < l.size(); ++i) {
                if (((Move)l.get(i)).equals(this.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String normalizeSan(String san) {
        return san.replace("+", "").replace("#", "").replace("!", "").replace("?", "").replace("ep", "").replace("\n", " ");
    }
}

